/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class BeanConfigurator<T>
extends BeanConfiguratorBase<BeanConfigurator<T>, T> {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final Consumer<BeanInfo> beanConsumer;
    private final BeanDeployment beanDeployment;

    BeanConfigurator(DotName implClassName, BeanDeployment beanDeployment, Consumer<BeanInfo> beanConsumer) {
        super(implClassName);
        this.beanDeployment = beanDeployment;
        this.beanConsumer = beanConsumer;
    }

    public void done() {
        if (this.consumed.compareAndSet(false, true)) {
            ClassInfo implClass = IndexClassLookupUtils.getClassByName(this.beanDeployment.getBeanArchiveIndex(), Objects.requireNonNull(this.implClazz));
            if (implClass == null) {
                throw new IllegalStateException("Unable to find the bean class in the index: " + this.implClazz);
            }
            this.beanConsumer.accept(new BeanInfo.Builder().implClazz(implClass).providerType(this.providerType).beanDeployment(this.beanDeployment).scope(this.scope).types(this.types).qualifiers(this.qualifiers).alternative(this.alternative).priority(this.priority).name(this.name).creator(this.creatorConsumer).destroyer(this.destroyerConsumer).params(this.params).defaultBean(this.defaultBean).removable(this.removable).forceApplicationClass(this.forceApplicationClass).targetPackageName(this.targetPackageName).build());
        }
    }
}

