/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorGenerator
extends BeanGenerator {
    protected static final String FIELD_NAME_BINDINGS = "bindings";

    public InterceptorGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(annotationLiterals, applicationClassPredicate, privateMembers, generateSources, reflectionRegistration, existingClasses, beanToGeneratedName, injectionPointAnnotationsPredicate, Collections.emptyList());
    }

    Collection<ResourceOutput.Resource> generate(InterceptorInfo interceptor) {
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(interceptor.getProviderType());
        ClassInfo interceptorClass = interceptor.getTarget().get().asClass();
        Object baseName = interceptorClass.enclosingClass() != null ? DotNames.simpleName(interceptorClass.enclosingClass()) + "_" + DotNames.simpleName(interceptorClass) : DotNames.simpleName(interceptorClass);
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = InterceptorGenerator.generatedNameFromTarget(targetPackage, (String)baseName, "_Bean");
        this.beanToGeneratedName.put(interceptor, generatedName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(interceptor.getBeanClass());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.INTERCEPTOR_BEAN : null, this.generateSources);
        ClassCreator interceptorCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableInterceptor.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)interceptorCreator.getFieldCreator("types", Set.class).setModifiers(18);
        FieldCreator bindings = (FieldCreator)interceptorCreator.getFieldCreator(FIELD_NAME_BINDINGS, Set.class).setModifiers(18);
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createProviderFields(interceptorCreator, interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor(classOutput, interceptorCreator, interceptor, injectionPointToProviderField, bindings.getFieldDescriptor(), this.reflectionRegistration);
        this.implementGetIdentifier(interceptor, interceptorCreator);
        this.implementSupplierGet(interceptorCreator);
        this.implementCreate(classOutput, interceptorCreator, interceptor, providerType, (String)baseName, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(interceptor, interceptorCreator, providerType, (String)baseName);
        this.implementGetTypes(interceptorCreator, beanTypes.getFieldDescriptor());
        this.implementGetBeanClass(interceptor, interceptorCreator);
        this.implementGetInterceptorBindings(interceptorCreator, bindings.getFieldDescriptor());
        this.implementIntercepts(interceptorCreator, interceptor);
        this.implementIntercept(interceptorCreator, interceptor, providerType, this.reflectionRegistration, isApplicationClass);
        this.implementGetPriority(interceptorCreator, interceptor);
        this.implementEquals(interceptor, interceptorCreator);
        this.implementHashCode(interceptor, interceptorCreator);
        interceptorCreator.close();
        return classOutput.getResources();
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator creator, InterceptorInfo interceptor, Map<InjectionPointInfo, String> injectionPointToProviderField, FieldDescriptor bindings, ReflectionRegistration reflectionRegistration) {
        MethodCreator constructor = this.initConstructor(classOutput, creator, interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, reflectionRegistration);
        ResultHandle bindingsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (AnnotationInstance bindingAnnotation : interceptor.getBindings()) {
            ClassInfo bindingClass = interceptor.getDeployment().getInterceptorBinding(bindingAnnotation.name());
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.create((BytecodeCreator)constructor, bindingClass, bindingAnnotation)});
        }
        constructor.writeInstanceField(bindings, constructor.getThis(), bindingsHandle);
        constructor.returnValue(null);
    }

    protected void implementGetInterceptorBindings(ClassCreator creator, FieldDescriptor bindingsField) {
        MethodCreator getBindings = (MethodCreator)creator.getMethodCreator("getInterceptorBindings", Set.class, new Class[0]).setModifiers(1);
        getBindings.returnValue(getBindings.readInstanceField(bindingsField, getBindings.getThis()));
    }

    protected void implementGetPriority(ClassCreator creator, InterceptorInfo interceptor) {
        MethodCreator getPriority = (MethodCreator)creator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(interceptor.getPriority().intValue()));
    }

    protected void implementIntercepts(ClassCreator creator, InterceptorInfo interceptor) {
        MethodCreator intercepts = (MethodCreator)creator.getMethodCreator("intercepts", Boolean.TYPE, new Class[]{InterceptionType.class}).setModifiers(1);
        this.addIntercepts(interceptor, InterceptionType.AROUND_INVOKE, intercepts);
        this.addIntercepts(interceptor, InterceptionType.POST_CONSTRUCT, intercepts);
        this.addIntercepts(interceptor, InterceptionType.PRE_DESTROY, intercepts);
        this.addIntercepts(interceptor, InterceptionType.AROUND_CONSTRUCT, intercepts);
        intercepts.returnValue(intercepts.load(false));
    }

    private void addIntercepts(InterceptorInfo interceptor, InterceptionType interceptionType, MethodCreator intercepts) {
        if (interceptor.intercepts(interceptionType)) {
            ResultHandle enumValue = intercepts.readStaticField(FieldDescriptor.of((String)InterceptionType.class.getName(), (String)interceptionType.name(), (String)InterceptionType.class.getName()));
            BranchResult result = intercepts.ifNonZero(intercepts.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, enumValue, new ResultHandle[]{intercepts.getMethodParam(0)}));
            result.trueBranch().returnValue(result.trueBranch().load(true));
        }
    }

    protected void implementIntercept(ClassCreator creator, InterceptorInfo interceptor, BeanGenerator.ProviderType providerType, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        MethodCreator intercept = ((MethodCreator)creator.getMethodCreator("intercept", Object.class, new Class[]{InterceptionType.class, Object.class, InvocationContext.class}).setModifiers(1)).addException(Exception.class);
        this.addIntercept(intercept, interceptor.getAroundInvoke(), InterceptionType.AROUND_INVOKE, providerType, reflectionRegistration, isApplicationClass);
        this.addIntercept(intercept, interceptor.getPostConstruct(), InterceptionType.POST_CONSTRUCT, providerType, reflectionRegistration, isApplicationClass);
        this.addIntercept(intercept, interceptor.getPreDestroy(), InterceptionType.PRE_DESTROY, providerType, reflectionRegistration, isApplicationClass);
        this.addIntercept(intercept, interceptor.getAroundConstruct(), InterceptionType.AROUND_CONSTRUCT, providerType, reflectionRegistration, isApplicationClass);
        intercept.returnValue(intercept.loadNull());
    }

    private void addIntercept(MethodCreator intercept, MethodInfo interceptorMethod, InterceptionType interceptionType, BeanGenerator.ProviderType providerType, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        if (interceptorMethod != null) {
            ResultHandle ret;
            ResultHandle enumValue = intercept.readStaticField(FieldDescriptor.of((String)InterceptionType.class.getName(), (String)interceptionType.name(), (String)InterceptionType.class.getName()));
            BranchResult result = intercept.ifNonZero(intercept.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, enumValue, new ResultHandle[]{intercept.getMethodParam(0)}));
            BytecodeCreator trueBranch = result.trueBranch();
            Class<Object> retType = null;
            retType = InterceptionType.AROUND_INVOKE.equals((Object)interceptionType) ? Object.class : (interceptorMethod.returnType().kind().equals((Object)Type.Kind.VOID) ? Void.TYPE : Object.class);
            Class invocationContextClass = interceptorMethod.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) ? InvocationContext.class : ArcInvocationContext.class;
            if (Modifier.isPrivate(interceptorMethod.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Interceptor method %s#%s()", interceptorMethod.declaringClass().name(), interceptorMethod.name()));
                ResultHandle paramTypesArray = trueBranch.newArray(Class.class, trueBranch.load(1));
                trueBranch.writeArrayValue(paramTypesArray, 0, trueBranch.loadClass(invocationContextClass));
                ResultHandle argsArray = trueBranch.newArray(Object.class, trueBranch.load(1));
                trueBranch.writeArrayValue(argsArray, 0, intercept.getMethodParam(2));
                reflectionRegistration.registerMethod(interceptorMethod);
                ret = trueBranch.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{trueBranch.loadClass(interceptorMethod.declaringClass().name().toString()), trueBranch.load(interceptorMethod.name()), paramTypesArray, intercept.getMethodParam(1), argsArray});
            } else {
                ret = trueBranch.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)providerType.className(), (String)interceptorMethod.name(), retType, (Object[])new Object[]{invocationContextClass}), intercept.getMethodParam(1), new ResultHandle[]{intercept.getMethodParam(2)});
            }
            trueBranch.returnValue(InterceptionType.AROUND_INVOKE.equals((Object)interceptionType) ? ret : trueBranch.loadNull());
        }
    }
}

