/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.arc.impl.TypeVariableImpl;
import io.quarkus.arc.impl.WildcardTypeImpl;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public final class Types {
    static final Logger LOGGER = Logger.getLogger(Types.class);
    private static final org.jboss.jandex.Type OBJECT_TYPE = org.jboss.jandex.Type.create((DotName)DotNames.OBJECT, (Type.Kind)Type.Kind.CLASS);
    private static final Set<String> PRIMITIVE_CLASS_NAMES = new HashSet<String>();
    private static final Set<DotName> BANNED_INTERFACE_TYPES;

    private Types() {
    }

    public static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type) {
        return Types.getTypeHandle(creator, type, null);
    }

    public static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type, ResultHandle tccl) {
        AssignableResultHandle result = creator.createVariable(Object.class);
        Types.getTypeHandle(result, creator, type, tccl, null);
        return result;
    }

    static void getTypeHandle(AssignableResultHandle variable, BytecodeCreator creator, org.jboss.jandex.Type type, ResultHandle tccl, TypeCache cache) {
        block21: {
            block26: {
                block25: {
                    ResultHandle wildcardHandle;
                    block24: {
                        block23: {
                            block22: {
                                ResultHandle boundsHandle;
                                block20: {
                                    if (cache != null) {
                                        ResultHandle cachedType = cache.get(type, creator);
                                        BranchResult cachedNull = creator.ifNull(cachedType);
                                        cachedNull.falseBranch().assign(variable, cachedType);
                                        creator = cachedNull.trueBranch();
                                    }
                                    if (!Type.Kind.CLASS.equals((Object)type.kind())) break block20;
                                    String className = type.asClassType().name().toString();
                                    ResultHandle classHandle = Types.doLoadClass(creator, className, tccl);
                                    if (cache != null) {
                                        cache.put(type, classHandle, creator);
                                    }
                                    creator.assign(variable, classHandle);
                                    break block21;
                                }
                                if (!Type.Kind.TYPE_VARIABLE.equals((Object)type.kind())) break block22;
                                TypeVariable typeVariable = type.asTypeVariable();
                                List bounds = typeVariable.bounds();
                                if (bounds.isEmpty()) {
                                    boundsHandle = creator.newArray(Type.class, creator.load(0));
                                } else {
                                    boundsHandle = creator.newArray(Type.class, creator.load(bounds.size()));
                                    for (int i = 0; i < bounds.size(); ++i) {
                                        AssignableResultHandle boundHandle = creator.createVariable(Object.class);
                                        Types.getTypeHandle(boundHandle, creator, (org.jboss.jandex.Type)bounds.get(i), tccl, cache);
                                        creator.writeArrayValue(boundsHandle, i, (ResultHandle)boundHandle);
                                    }
                                }
                                ResultHandle typeVariableHandle = creator.newInstance(MethodDescriptor.ofConstructor(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), new ResultHandle[]{creator.load(typeVariable.identifier()), boundsHandle});
                                if (cache != null) {
                                    cache.put((org.jboss.jandex.Type)typeVariable, typeVariableHandle, creator);
                                }
                                creator.assign(variable, typeVariableHandle);
                                break block21;
                            }
                            if (!Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind())) break block23;
                            Types.getParameterizedType(variable, creator, tccl, type.asParameterizedType(), cache);
                            break block21;
                        }
                        if (!Type.Kind.ARRAY.equals((Object)type.kind())) break block24;
                        org.jboss.jandex.Type componentType = type.asArrayType().component();
                        AssignableResultHandle componentTypeHandle = creator.createVariable(Object.class);
                        Types.getTypeHandle(componentTypeHandle, creator, componentType, tccl, cache);
                        ResultHandle arrayHandle = creator.newInstance(MethodDescriptor.ofConstructor(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{componentTypeHandle});
                        if (cache != null) {
                            cache.put(type, arrayHandle, creator);
                        }
                        creator.assign(variable, arrayHandle);
                        break block21;
                    }
                    if (!Type.Kind.WILDCARD_TYPE.equals((Object)type.kind())) break block25;
                    org.jboss.jandex.WildcardType wildcardType = type.asWildcardType();
                    if (wildcardType.superBound() == null) {
                        AssignableResultHandle extendsBoundHandle = creator.createVariable(Object.class);
                        Types.getTypeHandle(extendsBoundHandle, creator, wildcardType.extendsBound(), tccl, cache);
                        wildcardHandle = creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{extendsBoundHandle});
                    } else {
                        AssignableResultHandle superBoundHandle = creator.createVariable(Object.class);
                        Types.getTypeHandle(superBoundHandle, creator, wildcardType.superBound(), tccl, cache);
                        wildcardHandle = creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{superBoundHandle});
                    }
                    if (cache != null) {
                        cache.put((org.jboss.jandex.Type)wildcardType, wildcardHandle, creator);
                    }
                    creator.assign(variable, wildcardHandle);
                    break block21;
                }
                if (!Type.Kind.PRIMITIVE.equals((Object)type.kind())) break block26;
                switch (type.asPrimitiveType().primitive()) {
                    case INT: {
                        creator.assign(variable, creator.loadClass(Integer.TYPE));
                        break block21;
                    }
                    case LONG: {
                        creator.assign(variable, creator.loadClass(Long.TYPE));
                        break block21;
                    }
                    case BOOLEAN: {
                        creator.assign(variable, creator.loadClass(Boolean.TYPE));
                        break block21;
                    }
                    case BYTE: {
                        creator.assign(variable, creator.loadClass(Byte.TYPE));
                        break block21;
                    }
                    case CHAR: {
                        creator.assign(variable, creator.loadClass(Character.TYPE));
                        break block21;
                    }
                    case DOUBLE: {
                        creator.assign(variable, creator.loadClass(Double.TYPE));
                        break block21;
                    }
                    case FLOAT: {
                        creator.assign(variable, creator.loadClass(Float.TYPE));
                        break block21;
                    }
                    case SHORT: {
                        creator.assign(variable, creator.loadClass(Short.TYPE));
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported primitive type: " + type);
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported bean type: " + type.kind() + ", " + type);
        }
    }

    static void getParameterizedType(AssignableResultHandle variable, BytecodeCreator creator, ResultHandle tccl, ParameterizedType parameterizedType, TypeCache cache) {
        List arguments = parameterizedType.arguments();
        ResultHandle typeArgsHandle = creator.newArray(Type.class, creator.load(arguments.size()));
        for (int i = 0; i < arguments.size(); ++i) {
            AssignableResultHandle argumentHandle = creator.createVariable(Object.class);
            Types.getTypeHandle(argumentHandle, creator, (org.jboss.jandex.Type)arguments.get(i), tccl, cache);
            creator.writeArrayValue(typeArgsHandle, i, (ResultHandle)argumentHandle);
        }
        org.jboss.jandex.Type rawType = org.jboss.jandex.Type.create((DotName)parameterizedType.name(), (Type.Kind)Type.Kind.CLASS);
        ResultHandle rawTypeHandle = null;
        if (cache != null) {
            rawTypeHandle = cache.get(rawType, creator);
        }
        if (rawTypeHandle == null) {
            rawTypeHandle = Types.doLoadClass(creator, parameterizedType.name().toString(), tccl);
            if (cache != null) {
                cache.put(rawType, rawTypeHandle, creator);
            }
        }
        ResultHandle parameterizedTypeHandle = creator.newInstance(MethodDescriptor.ofConstructor(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class}), new ResultHandle[]{rawTypeHandle, typeArgsHandle});
        if (cache != null) {
            cache.put((org.jboss.jandex.Type)parameterizedType, parameterizedTypeHandle, creator);
        }
        creator.assign(variable, parameterizedTypeHandle);
    }

    public static void getParameterizedType(AssignableResultHandle variable, BytecodeCreator creator, ResultHandle tccl, ParameterizedType parameterizedType) {
        Types.getParameterizedType(variable, creator, tccl, parameterizedType, null);
    }

    public static ResultHandle getParameterizedType(BytecodeCreator creator, ResultHandle tccl, ParameterizedType parameterizedType) {
        AssignableResultHandle result = creator.createVariable(Object.class);
        Types.getParameterizedType(result, creator, tccl, parameterizedType, null);
        return result;
    }

    private static ResultHandle doLoadClass(BytecodeCreator creator, String className, ResultHandle tccl) {
        if (className.startsWith("java.")) {
            return creator.loadClass(className);
        }
        if (tccl == null) {
            ResultHandle currentThread = creator.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
            tccl = creator.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        }
        return creator.invokeStaticMethod(MethodDescriptors.CL_FOR_NAME, new ResultHandle[]{creator.load(className), creator.load(false), tccl});
    }

    static org.jboss.jandex.Type getProviderType(ClassInfo classInfo) {
        List typeParameters = classInfo.typeParameters();
        if (!typeParameters.isEmpty()) {
            return ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParameters.toArray(new org.jboss.jandex.Type[0]), null);
        }
        return org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
    }

    static Set<org.jboss.jandex.Type> getProducerMethodTypeClosure(MethodInfo producerMethod, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type returnType = producerMethod.returnType();
        if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
            throw new DefinitionException("A type variable is not a legal bean type: " + producerMethod);
        }
        if (returnType.kind() == Type.Kind.PRIMITIVE || returnType.kind() == Type.Kind.ARRAY) {
            HashSet<org.jboss.jandex.Type> types2 = new HashSet<org.jboss.jandex.Type>();
            types2.add(returnType);
            types2.add(OBJECT_TYPE);
            return types2;
        }
        ClassInfo returnTypeClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), returnType);
        if (returnTypeClassInfo == null) {
            throw new IllegalArgumentException("Producer method return type not found in index: " + producerMethod.returnType().name());
        }
        if (Type.Kind.CLASS.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Collections.emptyMap(), beanDeployment, null);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Types.buildResolvedMap(returnType.asParameterizedType().arguments(), returnTypeClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerMethod));
    }

    static Set<org.jboss.jandex.Type> getProducerFieldTypeClosure(FieldInfo producerField, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type fieldType = producerField.type();
        if (fieldType.kind() == Type.Kind.TYPE_VARIABLE) {
            throw new DefinitionException("A type variable is not a legal bean type: " + producerField);
        }
        if (fieldType.kind() == Type.Kind.PRIMITIVE || fieldType.kind() == Type.Kind.ARRAY) {
            types = new HashSet<org.jboss.jandex.Type>();
            types.add(fieldType);
            types.add(OBJECT_TYPE);
        } else {
            ClassInfo fieldClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), producerField.type());
            if (fieldClassInfo == null) {
                throw new IllegalArgumentException("Producer field type not found in index: " + producerField.type().name());
            }
            if (Type.Kind.CLASS.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Collections.emptyMap(), beanDeployment, null);
            } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Types.buildResolvedMap(fieldType.asParameterizedType().arguments(), fieldClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null);
            } else {
                throw new IllegalArgumentException("Unsupported return type");
            }
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerField));
    }

    static Set<org.jboss.jandex.Type> getClassBeanTypeClosure(ClassInfo classInfo, BeanDeployment beanDeployment) {
        List typeParameters = classInfo.typeParameters();
        Set<org.jboss.jandex.Type> types = typeParameters.isEmpty() ? Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, null) : Types.getTypeClosure(classInfo, null, Types.buildResolvedMap(typeParameters, typeParameters, Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null);
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)classInfo));
    }

    static List<org.jboss.jandex.Type> getResolvedParameters(ClassInfo classInfo, MethodInfo method, IndexView index) {
        return Types.getResolvedParameters(classInfo, Collections.emptyMap(), method, index);
    }

    static List<org.jboss.jandex.Type> getResolvedParameters(ClassInfo classInfo, Map<TypeVariable, org.jboss.jandex.Type> resolvedMap, MethodInfo method, IndexView index) {
        List typeParameters = classInfo.typeParameters();
        List parameters = method.parameterTypes();
        if (typeParameters.isEmpty()) {
            return parameters;
        }
        resolvedMap = Types.buildResolvedMap(typeParameters, typeParameters, resolvedMap, index);
        ArrayList<org.jboss.jandex.Type> resolved = new ArrayList<org.jboss.jandex.Type>();
        for (org.jboss.jandex.Type param : parameters) {
            switch (param.kind()) {
                case ARRAY: 
                case PRIMITIVE: 
                case CLASS: {
                    resolved.add(param);
                    break;
                }
                case TYPE_VARIABLE: 
                case PARAMETERIZED_TYPE: {
                    resolved.add(Types.resolveTypeParam(param, resolvedMap, index));
                }
            }
        }
        return resolved;
    }

    /*
     * Unable to fully structure code
     */
    static Set<org.jboss.jandex.Type> getTypeClosure(ClassInfo classInfo, AnnotationTarget producerFieldOrMethod, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment, BiConsumer<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariablesConsumer) {
        types = new HashSet<org.jboss.jandex.Type>();
        typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty()) ** GOTO lbl-1000
        if (!typeParameters.stream().allMatch((Predicate<TypeVariable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Lorg/jboss/jandex/TypeVariable;)Z)(resolvedTypeParameters))) lbl-1000:
        // 2 sources

        {
            types.add(org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        } else {
            typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            skipThisType = false;
            for (i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = resolvedTypeParameters.get(typeParameters.get(i));
                if (!typeParams[i].kind().equals((Object)Type.Kind.WILDCARD_TYPE) || producerFieldOrMethod == null) continue;
                Types.LOGGER.info((Object)("Producer " + (producerFieldOrMethod.kind().equals((Object)AnnotationTarget.Kind.FIELD) != false ? "field " : "method ") + producerFieldOrMethod + " contains a parameterized typed with a wildcard. This type is not a legal bean type according to CDI specification and will be ignored during bean resolution."));
                skipThisType = true;
            }
            if (resolvedTypeVariablesConsumer != null) {
                resolved = new HashMap<TypeVariable, org.jboss.jandex.Type>();
                for (i = 0; i < typeParameters.size(); ++i) {
                    resolved.put((TypeVariable)typeParameters.get(i), typeParams[i]);
                }
                resolvedTypeVariablesConsumer.accept(classInfo, resolved);
            }
            if (!skipThisType) {
                types.add((org.jboss.jandex.Type)ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParams, null));
            }
        }
        for (org.jboss.jandex.Type interfaceType : classInfo.interfaceTypes()) {
            if (Types.BANNED_INTERFACE_TYPES.contains(interfaceType.name()) || (interfaceClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), interfaceType.name())) == null) continue;
            resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getBeanArchiveIndex());
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, producerFieldOrMethod, resolved, beanDeployment, resolvedTypeVariablesConsumer));
        }
        if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getBeanArchiveIndex());
            }
            types.addAll(Types.getTypeClosure(superClassInfo, producerFieldOrMethod, resolved, beanDeployment, resolvedTypeVariablesConsumer));
        }
        return types;
    }

    static Set<org.jboss.jandex.Type> getDelegateTypeClosure(InjectionPointInfo delegateInjectionPoint, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type delegateType = delegateInjectionPoint.getRequiredType();
        if (delegateType.kind() == Type.Kind.TYPE_VARIABLE || delegateType.kind() == Type.Kind.PRIMITIVE || delegateType.kind() == Type.Kind.ARRAY) {
            throw new DefinitionException("Illegal delegate type declared:" + delegateInjectionPoint.getTargetInfo());
        }
        ClassInfo delegateTypeClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), delegateType);
        if (delegateTypeClass == null) {
            throw new IllegalArgumentException("Delegate type not found in index: " + delegateType);
        }
        if (Type.Kind.CLASS.equals((Object)delegateType.kind())) {
            types = Types.getTypeClosure(delegateTypeClass, delegateInjectionPoint.getTarget(), Collections.emptyMap(), beanDeployment, null);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)delegateType.kind())) {
            types = Types.getTypeClosure(delegateTypeClass, delegateInjectionPoint.getTarget(), Types.buildResolvedMap(delegateType.asParameterizedType().arguments(), delegateTypeClass.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return types;
    }

    static Map<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariables(ClassInfo classInfo, BeanDeployment beanDeployment) {
        HashMap<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariables = new HashMap<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>>();
        Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, resolvedTypeVariables::put);
        return resolvedTypeVariables;
    }

    static Set<org.jboss.jandex.Type> restrictBeanTypes(Set<org.jboss.jandex.Type> types, Collection<AnnotationInstance> annotations) {
        AnnotationInstance typed = annotations.stream().filter(a -> a.name().equals((Object)DotNames.TYPED)).findFirst().orElse(null);
        if (typed != null) {
            AnnotationValue typedValue = typed.value();
            if (typedValue == null) {
                types.clear();
                types.add(OBJECT_TYPE);
            } else {
                HashSet<DotName> typedClasses = new HashSet<DotName>();
                for (org.jboss.jandex.Type type : typedValue.asClassArray()) {
                    typedClasses.add(type.name());
                }
                Iterator<org.jboss.jandex.Type> iterator = types.iterator();
                while (iterator.hasNext()) {
                    org.jboss.jandex.Type nextType = iterator.next();
                    if (typedClasses.contains(nextType.name()) || DotNames.OBJECT.equals((Object)nextType.name())) continue;
                    iterator.remove();
                }
            }
        }
        return types;
    }

    static <T extends org.jboss.jandex.Type> Map<TypeVariable, org.jboss.jandex.Type> buildResolvedMap(List<T> resolvedArguments, List<TypeVariable> typeVariables, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        HashMap<TypeVariable, org.jboss.jandex.Type> resolvedMap = new HashMap<TypeVariable, org.jboss.jandex.Type>();
        for (int i = 0; i < resolvedArguments.size(); ++i) {
            resolvedMap.put(typeVariables.get(i), Types.resolveTypeParam((org.jboss.jandex.Type)resolvedArguments.get(i), resolvedTypeParameters, index));
        }
        return resolvedMap;
    }

    static org.jboss.jandex.Type resolveTypeParam(org.jboss.jandex.Type typeParam, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        ParameterizedType parameterizedType;
        ClassInfo classInfo;
        if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
            return resolvedTypeParameters.getOrDefault(typeParam, typeParam);
        }
        if (typeParam.kind() == Type.Kind.PARAMETERIZED_TYPE && (classInfo = IndexClassLookupUtils.getClassByName(index, (parameterizedType = typeParam.asParameterizedType()).name())) != null) {
            List typeParameters = classInfo.typeParameters();
            List arguments = parameterizedType.arguments();
            Map<TypeVariable, org.jboss.jandex.Type> resolvedMap = Types.buildResolvedMap(arguments, typeParameters, resolvedTypeParameters, index);
            org.jboss.jandex.Type[] typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = Types.resolveTypeParam((org.jboss.jandex.Type)arguments.get(i), resolvedMap, index);
            }
            return ParameterizedType.create((DotName)parameterizedType.name(), (org.jboss.jandex.Type[])typeParams, null);
        }
        return typeParam;
    }

    static String getPackageName(String className) {
        return (className = className.replace('/', '.')).contains(".") ? className.substring(0, className.lastIndexOf(".")) : "";
    }

    static String getSimpleName(String className) {
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1, className.length()) : className;
    }

    static org.jboss.jandex.Type box(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return Types.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static org.jboss.jandex.Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return org.jboss.jandex.Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return org.jboss.jandex.Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }

    static boolean isPrimitiveClassName(String className) {
        return PRIMITIVE_CLASS_NAMES.contains(className);
    }

    static boolean containsTypeVariable(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            return true;
        }
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (org.jboss.jandex.Type arg : type.asParameterizedType().arguments()) {
                if (!Types.containsTypeVariable(arg)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PRIMITIVE_CLASS_NAMES.add("byte");
        PRIMITIVE_CLASS_NAMES.add("char");
        PRIMITIVE_CLASS_NAMES.add("double");
        PRIMITIVE_CLASS_NAMES.add("float");
        PRIMITIVE_CLASS_NAMES.add("int");
        PRIMITIVE_CLASS_NAMES.add("long");
        PRIMITIVE_CLASS_NAMES.add("short");
        PRIMITIVE_CLASS_NAMES.add("boolean");
        BANNED_INTERFACE_TYPES = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"java.lang.constant.ConstantDesc"), DotName.createSimple((String)"java.lang.constant.Constable")));
    }

    static interface TypeCache {
        public void initialize(MethodCreator var1);

        public ResultHandle get(org.jboss.jandex.Type var1, BytecodeCreator var2);

        public void put(org.jboss.jandex.Type var1, ResultHandle var2, BytecodeCreator var3);
    }
}

