/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralGenerator;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class AnnotationLiteralProcessor {
    private static final String ANNOTATION_LITERAL_SUFFIX = "_ArcAnnotationLiteral";
    private final ComputingCache<CacheKey, AnnotationLiteralClassInfo> cache = new ComputingCache(key -> new AnnotationLiteralClassInfo(AnnotationLiteralProcessor.generateAnnotationLiteralClassName(key.annotationName()), applicationClassPredicate.test(key.annotationName()), key.annotationClass));
    private final IndexView beanArchiveIndex;

    AnnotationLiteralProcessor(IndexView beanArchiveIndex, Predicate<DotName> applicationClassPredicate) {
        this.beanArchiveIndex = beanArchiveIndex;
    }

    boolean hasLiteralsToGenerate() {
        return !this.cache.isEmpty();
    }

    ComputingCache<CacheKey, AnnotationLiteralClassInfo> getCache() {
        return this.cache;
    }

    @Deprecated
    public ResultHandle process(BytecodeCreator bytecode, ClassOutput classOutput, ClassInfo annotationClass, AnnotationInstance annotationInstance, String targetPackage) {
        return this.create(bytecode, annotationClass, annotationInstance);
    }

    public ResultHandle create(BytecodeCreator bytecode, ClassInfo annotationClass, AnnotationInstance annotationInstance) {
        if (!annotationInstance.runtimeVisible()) {
            throw new IllegalArgumentException("Annotation does not have @Retention(RUNTIME): " + annotationInstance);
        }
        Objects.requireNonNull(annotationClass, "Annotation class not available: " + annotationInstance);
        AnnotationLiteralClassInfo literal = (AnnotationLiteralClassInfo)this.cache.getValue((Object)new CacheKey(annotationClass));
        if (literal.annotationMembers().isEmpty()) {
            return bytecode.readStaticField(FieldDescriptor.of((String)literal.generatedClassName, (String)"INSTANCE", (String)literal.generatedClassName));
        }
        ResultHandle[] constructorParameters = new ResultHandle[literal.annotationMembers().size()];
        int constructorParameterIndex = 0;
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            ResultHandle retValue;
            AnnotationValue value = annotationInstance.value(annotationMember.name());
            if (value == null) {
                value = annotationMember.defaultValue();
            }
            if (value == null) {
                throw new IllegalStateException(String.format("Value is not set for %s.%s(). Most probably an older version of Jandex was used to index an application dependency. Make sure that Jandex 2.1+ is used.", annotationMember.declaringClass().name(), annotationMember.name()));
            }
            constructorParameters[constructorParameterIndex] = retValue = this.loadValue(bytecode, literal, annotationMember, value);
            ++constructorParameterIndex;
        }
        return bytecode.newInstance(MethodDescriptor.ofConstructor((Object)literal.generatedClassName, (Object[])literal.annotationMembers().stream().map(m -> m.returnType().name().toString()).toArray()), constructorParameters);
    }

    private ResultHandle loadValue(BytecodeCreator bytecode, AnnotationLiteralClassInfo literal, MethodInfo annotationMember, AnnotationValue annotationMemberValue) {
        ResultHandle retValue;
        switch (annotationMemberValue.kind()) {
            case BOOLEAN: {
                retValue = bytecode.load(annotationMemberValue.asBoolean());
                break;
            }
            case BYTE: {
                retValue = bytecode.load(annotationMemberValue.asByte());
                break;
            }
            case SHORT: {
                retValue = bytecode.load(annotationMemberValue.asShort());
                break;
            }
            case INTEGER: {
                retValue = bytecode.load(annotationMemberValue.asInt());
                break;
            }
            case LONG: {
                retValue = bytecode.load(annotationMemberValue.asLong());
                break;
            }
            case FLOAT: {
                retValue = bytecode.load(annotationMemberValue.asFloat());
                break;
            }
            case DOUBLE: {
                retValue = bytecode.load(annotationMemberValue.asDouble());
                break;
            }
            case CHARACTER: {
                retValue = bytecode.load(annotationMemberValue.asChar());
                break;
            }
            case STRING: {
                retValue = bytecode.load(annotationMemberValue.asString());
                break;
            }
            case ENUM: {
                retValue = bytecode.readStaticField(FieldDescriptor.of((String)annotationMemberValue.asEnumType().toString(), (String)annotationMemberValue.asEnum(), (String)annotationMemberValue.asEnumType().toString()));
                break;
            }
            case CLASS: {
                if (annotationMemberValue.equals((Object)annotationMember.defaultValue())) {
                    retValue = bytecode.readStaticField(FieldDescriptor.of((String)literal.generatedClassName, (String)AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), (String)annotationMember.returnType().name().toString()));
                    break;
                }
                retValue = bytecode.loadClass(annotationMemberValue.asClass().name().toString());
                break;
            }
            case NESTED: {
                AnnotationInstance nestedAnnotation = annotationMemberValue.asNested();
                DotName annotationName = nestedAnnotation.name();
                ClassInfo annotationClass = this.beanArchiveIndex.getClassByName(annotationName);
                if (annotationClass == null) {
                    throw new IllegalStateException("Class of nested annotation " + nestedAnnotation + " missing");
                }
                retValue = this.create(bytecode, annotationClass, nestedAnnotation);
                break;
            }
            case ARRAY: {
                retValue = this.loadArrayValue(bytecode, literal, annotationMember, annotationMemberValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported value: " + annotationMemberValue);
            }
        }
        return retValue;
    }

    private ResultHandle loadArrayValue(BytecodeCreator bytecode, AnnotationLiteralClassInfo literal, MethodInfo annotationMember, AnnotationValue annotationMemberValue) {
        ResultHandle retValue;
        AnnotationValue.Kind componentKind = annotationMemberValue.componentKind();
        switch (componentKind) {
            case BOOLEAN: {
                boolean[] booleanArray = annotationMemberValue.asBooleanArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), booleanArray.length);
                for (int i = 0; i < booleanArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(booleanArray[i]));
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = annotationMemberValue.asByteArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), byteArray.length);
                for (int i = 0; i < byteArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(byteArray[i]));
                }
                break;
            }
            case SHORT: {
                short[] shortArray = annotationMemberValue.asShortArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), shortArray.length);
                for (int i = 0; i < shortArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(shortArray[i]));
                }
                break;
            }
            case INTEGER: {
                int[] intArray = annotationMemberValue.asIntArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), intArray.length);
                for (int i = 0; i < intArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(intArray[i]));
                }
                break;
            }
            case LONG: {
                long[] longArray = annotationMemberValue.asLongArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), longArray.length);
                for (int i = 0; i < longArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(longArray[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = annotationMemberValue.asFloatArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), floatArray.length);
                for (int i = 0; i < floatArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(floatArray[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = annotationMemberValue.asDoubleArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), doubleArray.length);
                for (int i = 0; i < doubleArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(doubleArray[i]));
                }
                break;
            }
            case CHARACTER: {
                char[] charArray = annotationMemberValue.asCharArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), charArray.length);
                for (int i = 0; i < charArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(charArray[i]));
                }
                break;
            }
            case STRING: {
                String[] stringArray = annotationMemberValue.asStringArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.load(stringArray[i]));
                }
                break;
            }
            case ENUM: {
                String[] enumArray = annotationMemberValue.asEnumArray();
                DotName[] enumTypeArray = annotationMemberValue.asEnumTypeArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), enumArray.length);
                for (int i = 0; i < enumArray.length; ++i) {
                    ResultHandle enumValue = bytecode.readStaticField(FieldDescriptor.of((String)enumTypeArray[i].toString(), (String)enumArray[i], (String)enumTypeArray[i].toString()));
                    bytecode.writeArrayValue(retValue, i, enumValue);
                }
                break;
            }
            case CLASS: {
                if (annotationMemberValue.equals((Object)annotationMember.defaultValue())) {
                    retValue = bytecode.readStaticField(FieldDescriptor.of((String)literal.generatedClassName, (String)AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), (String)annotationMember.returnType().name().toString()));
                    break;
                }
                Type[] classArray = annotationMemberValue.asClassArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), classArray.length);
                for (int i = 0; i < classArray.length; ++i) {
                    bytecode.writeArrayValue(retValue, i, bytecode.loadClass(classArray[i].name().toString()));
                }
                break;
            }
            case NESTED: {
                AnnotationInstance[] nestedArray = annotationMemberValue.asNestedArray();
                retValue = bytecode.newArray(AnnotationLiteralProcessor.componentType(annotationMember), nestedArray.length);
                for (int i = 0; i < nestedArray.length; ++i) {
                    AnnotationInstance nestedAnnotation = nestedArray[i];
                    DotName annotationName = nestedAnnotation.name();
                    ClassInfo annotationClass = this.beanArchiveIndex.getClassByName(annotationName);
                    if (annotationClass == null) {
                        throw new IllegalStateException("Class of nested annotation " + nestedAnnotation + " missing");
                    }
                    ResultHandle nestedAnnotationValue = this.create(bytecode, annotationClass, nestedAnnotation);
                    bytecode.writeArrayValue(retValue, i, nestedAnnotationValue);
                }
                break;
            }
            case UNKNOWN: {
                DotName componentName = AnnotationLiteralProcessor.componentTypeName(annotationMember);
                if (PrimitiveType.BOOLEAN.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_BOOLEAN_ARRAY);
                    break;
                }
                if (PrimitiveType.BYTE.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_BYTE_ARRAY);
                    break;
                }
                if (PrimitiveType.SHORT.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_SHORT_ARRAY);
                    break;
                }
                if (PrimitiveType.INT.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_INT_ARRAY);
                    break;
                }
                if (PrimitiveType.LONG.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_LONG_ARRAY);
                    break;
                }
                if (PrimitiveType.FLOAT.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_FLOAT_ARRAY);
                    break;
                }
                if (PrimitiveType.DOUBLE.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_DOUBLE_ARRAY);
                    break;
                }
                if (PrimitiveType.CHAR.name().equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_CHAR_ARRAY);
                    break;
                }
                if (DotNames.STRING.equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_STRING_ARRAY);
                    break;
                }
                if (DotNames.CLASS.equals((Object)componentName)) {
                    retValue = bytecode.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                    break;
                }
                retValue = bytecode.newArray(componentName.toString(), bytecode.load(0));
                break;
            }
            default: {
                throw new IllegalStateException("Array component kind is " + componentKind + ", this should never happen");
            }
        }
        return retValue;
    }

    private static String componentType(MethodInfo method) {
        return AnnotationLiteralProcessor.componentTypeName(method).toString();
    }

    private static DotName componentTypeName(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.component().name();
    }

    private static String generateAnnotationLiteralClassName(DotName annotationName) {
        boolean isJavaLang = annotationName.toString().startsWith("java.lang");
        String nameToUse = isJavaLang ? AbstractGenerator.DEFAULT_PACKAGE + annotationName.withoutPackagePrefix() : annotationName.toString();
        return nameToUse + ANNOTATION_LITERAL_SUFFIX;
    }

    static class AnnotationLiteralClassInfo {
        final String generatedClassName;
        final boolean isApplicationClass;
        final ClassInfo annotationClass;

        AnnotationLiteralClassInfo(String generatedClassName, boolean isApplicationClass, ClassInfo annotationClass) {
            this.generatedClassName = generatedClassName;
            this.isApplicationClass = isApplicationClass;
            this.annotationClass = annotationClass;
        }

        DotName annotationName() {
            return this.annotationClass.name();
        }

        List<MethodInfo> annotationMembers() {
            ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
            for (MethodInfo method : this.annotationClass.unsortedMethods()) {
                if (method.name().equals("<clinit>") || method.name().equals("<init>")) continue;
                result.add(method);
            }
            return result;
        }
    }

    static class CacheKey {
        final ClassInfo annotationClass;

        CacheKey(ClassInfo annotationClass) {
            this.annotationClass = annotationClass;
        }

        DotName annotationName() {
            return this.annotationClass.name();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.annotationClass.name(), cacheKey.annotationClass.name());
        }

        public int hashCode() {
            return Objects.hash(this.annotationClass.name());
        }
    }
}

