/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ConfiguratorBase;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.QualifierConfigurator;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public abstract class BeanConfiguratorBase<THIS extends BeanConfiguratorBase<THIS, T>, T>
extends ConfiguratorBase<THIS>
implements Consumer<AnnotationInstance> {
    protected final DotName implClazz;
    protected final Set<Type> types;
    protected final Set<AnnotationInstance> qualifiers;
    protected ScopeInfo scope;
    protected Boolean alternative;
    protected final List<StereotypeInfo> stereotypes;
    protected String name;
    protected Consumer<MethodCreator> creatorConsumer;
    protected Consumer<MethodCreator> destroyerConsumer;
    protected boolean defaultBean;
    protected boolean removable;
    protected Type providerType;
    protected boolean forceApplicationClass;
    protected String targetPackageName;
    protected Integer priority;

    protected BeanConfiguratorBase(DotName implClazz) {
        this.implClazz = implClazz;
        this.types = new HashSet<Type>();
        this.qualifiers = new HashSet<AnnotationInstance>();
        this.stereotypes = new ArrayList<StereotypeInfo>();
        this.removable = true;
    }

    public THIS read(BeanConfiguratorBase<?, ?> base) {
        super.read(base);
        this.types.clear();
        this.types.addAll(base.types);
        this.qualifiers.clear();
        this.qualifiers.addAll(base.qualifiers);
        this.forceApplicationClass = base.forceApplicationClass;
        this.targetPackageName = base.targetPackageName;
        this.scope(base.scope);
        this.alternative = base.alternative;
        this.priority = base.priority;
        this.stereotypes.clear();
        this.stereotypes.addAll(base.stereotypes);
        this.name(base.name);
        this.creator(base.creatorConsumer);
        this.destroyer(base.destroyerConsumer);
        if (base.defaultBean) {
            this.defaultBean();
        }
        this.removable = base.removable;
        this.providerType(base.providerType);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS types(Class<?> ... types) {
        for (Class<?> type : types) {
            this.addType(type);
        }
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS types(Type ... types) {
        Collections.addAll(this.types, types);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(DotName className) {
        this.types.add(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(Type type) {
        this.types.add(type);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(Class<?> type) {
        return this.addType(DotName.createSimple((String)type.getName()));
    }

    public THIS addQualifier(Class<? extends Annotation> annotationClass) {
        return this.addQualifier(DotName.createSimple((String)annotationClass.getName()));
    }

    public THIS addQualifier(DotName annotationName) {
        return this.addQualifier(AnnotationInstance.create((DotName)annotationName, null, (AnnotationValue[])new AnnotationValue[0]));
    }

    public THIS addQualifier(AnnotationInstance qualifier) {
        this.qualifiers.add(qualifier);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public QualifierConfigurator<THIS> addQualifier() {
        return new QualifierConfigurator<BeanConfiguratorBase>((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public THIS qualifiers(AnnotationInstance ... qualifiers) {
        Collections.addAll(this.qualifiers, qualifiers);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS scope(ScopeInfo scope) {
        this.scope = scope;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS scope(Class<? extends Annotation> scope) {
        DotName scopeName = DotName.createSimple((String)scope.getName());
        BuiltinScope builtinScope = BuiltinScope.from(scopeName);
        this.scope = builtinScope != null ? builtinScope.getInfo() : new ScopeInfo(scopeName, scope.isAnnotationPresent(NormalScope.class), scope.isAnnotationPresent(Inherited.class));
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS name(String name) {
        this.name = name;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS named(String name) {
        return (THIS)((BeanConfiguratorBase)((BeanConfiguratorBase)this.name(name)).addQualifier().annotation(DotNames.NAMED).addValue("value", name).done());
    }

    public THIS defaultBean() {
        this.defaultBean = true;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS unremovable() {
        this.removable = false;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS forceApplicationClass() {
        this.forceApplicationClass = true;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS targetPackageName(String name) {
        this.targetPackageName = name;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS alternativePriority(int value) {
        this.alternative = true;
        this.priority = value;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS priority(int value) {
        this.priority = value;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addStereotype(StereotypeInfo stereotype) {
        this.stereotypes.add(stereotype);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS stereotypes(StereotypeInfo ... stereotypes) {
        Collections.addAll(this.stereotypes, stereotypes);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS providerType(Type providerType) {
        this.providerType = providerType;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public <U extends T> THIS creator(Class<? extends BeanCreator<U>> creatorClazz) {
        return this.creator((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), paramsHandle};
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class, Map.class}), creatorHandle, params);
            mc.returnValue(ret);
        });
    }

    public THIS creator(Consumer<MethodCreator> methodCreatorConsumer) {
        this.creatorConsumer = methodCreatorConsumer;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public <U extends T> THIS destroyer(Class<? extends BeanDestroyer<U>> destroyerClazz) {
        return this.destroyer((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle destoyerHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)destroyerClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), mc.getMethodParam(1), paramsHandle};
            mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanDestroyer.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class, Map.class}), destoyerHandle, params);
            mc.returnValue(null);
        });
    }

    public THIS destroyer(Consumer<MethodCreator> methodCreatorConsumer) {
        this.destroyerConsumer = methodCreatorConsumer;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    protected static <T> T cast(Object obj) {
        return (T)obj;
    }

    @Override
    public void accept(AnnotationInstance qualifier) {
        this.addQualifier(qualifier);
    }
}

