/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class Injection {
    private static final Logger LOGGER = Logger.getLogger(Injection.class);
    final AnnotationTarget target;
    final List<InjectionPointInfo> injectionPoints;

    static List<Injection> forBean(AnnotationTarget beanTarget, BeanInfo declaringBean, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        if (AnnotationTarget.Kind.CLASS.equals((Object)beanTarget.kind())) {
            ArrayList<Injection> injections = new ArrayList<Injection>();
            Injection.forClassBean(beanTarget.asClass(), beanTarget.asClass(), beanDeployment, injections, transformer, false);
            Set injectConstructors = injections.stream().filter(Injection::isConstructor).map(Injection::getTarget).collect(Collectors.toSet());
            if (injectConstructors.size() > 1) {
                throw new DefinitionException("Multiple @Inject constructors found on " + beanTarget.asClass().name() + ":\n" + injectConstructors.stream().map(Object::toString).collect(Collectors.joining("\n")));
            }
            Set initializerMethods = injections.stream().filter(it -> it.isMethod() && !it.isConstructor()).map(Injection::getTarget).map(AnnotationTarget::asMethod).collect(Collectors.toSet());
            for (MethodInfo initializerMethod : initializerMethods) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)initializerMethod, DotNames.PRODUCES)) {
                    throw new DefinitionException("Initializer method must not be marked @Produces (alternatively, producer method must not be marked @Inject): " + beanTarget.asClass() + "." + initializerMethod.name());
                }
                if (Annotations.contains(Annotations.getParameterAnnotations(beanDeployment, initializerMethod), DotNames.DISPOSES)) {
                    throw new DefinitionException("Initializer method must not have a parameter marked @Disposes (alternatively, disposer method must not be marked @Inject): " + beanTarget.asClass() + "." + initializerMethod.name());
                }
                if (Annotations.contains(Annotations.getParameterAnnotations(beanDeployment, initializerMethod), DotNames.OBSERVES)) {
                    throw new DefinitionException("Initializer method must not have a parameter marked @Observes (alternatively, observer method must not be marked @Inject): " + beanTarget.asClass() + "." + initializerMethod.name());
                }
                if (!Annotations.contains(Annotations.getParameterAnnotations(beanDeployment, initializerMethod), DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Initializer method must not have a parameter marked @ObservesAsync (alternatively, async observer method must not be marked @Inject): " + beanTarget.asClass() + "." + initializerMethod.name());
            }
            return injections;
        }
        if (AnnotationTarget.Kind.METHOD.equals((Object)beanTarget.kind())) {
            if (beanTarget.asMethod().parameterTypes().isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new Injection((AnnotationTarget)beanTarget.asMethod(), InjectionPointInfo.fromMethod(beanTarget.asMethod(), declaringBean.getImplClazz(), beanDeployment, transformer)));
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    private static void forClassBean(ClassInfo beanClass, ClassInfo classInfo, BeanDeployment beanDeployment, List<Injection> injections, InjectionPointModifier transformer, boolean skipConstructors) {
        ClassInfo info;
        Object injectTarget;
        List<AnnotationInstance> injectAnnotations = Injection.getAllInjectionPoints(beanDeployment, classInfo, DotNames.INJECT, skipConstructors);
        block4: for (AnnotationInstance injectAnnotation : injectAnnotations) {
            injectTarget = injectAnnotation.target();
            switch (injectAnnotation.target().kind()) {
                case FIELD: {
                    injections.add(new Injection((AnnotationTarget)injectTarget, Collections.singletonList(InjectionPointInfo.fromField(injectTarget.asField(), beanClass, beanDeployment, transformer))));
                    continue block4;
                }
                case METHOD: {
                    injections.add(new Injection((AnnotationTarget)injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanClass, beanDeployment, transformer)));
                    continue block4;
                }
            }
            LOGGER.warn((Object)("Unsupported @Inject target ignored: " + injectAnnotation.target()));
        }
        if (beanClass.equals(classInfo)) {
            boolean isNonStaticInnerClass;
            boolean bl = isNonStaticInnerClass = classInfo.name().isInner() && !Modifier.isStatic(classInfo.flags());
            if (!(isNonStaticInnerClass || Injection.hasConstructorInjection(injections) || beanClass.hasNoArgsConstructor())) {
                ArrayList<MethodInfo> nonNoargConstrs = new ArrayList<MethodInfo>();
                for (MethodInfo constr : classInfo.methods()) {
                    if (!"<init>".equals(constr.name()) || constr.parametersCount() <= 0) continue;
                    nonNoargConstrs.add(constr);
                }
                if (nonNoargConstrs.size() == 1) {
                    injectTarget = (MethodInfo)nonNoargConstrs.get(0);
                    injections.add(new Injection((AnnotationTarget)injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanClass, beanDeployment, transformer)));
                }
            }
        }
        for (DotName resourceAnnotation : beanDeployment.getResourceAnnotations()) {
            List<AnnotationInstance> resourceAnnotations = Injection.getAllInjectionPoints(beanDeployment, classInfo, resourceAnnotation, true);
            for (AnnotationInstance resourceAnnotationInstance : resourceAnnotations) {
                if (AnnotationTarget.Kind.FIELD != resourceAnnotationInstance.target().kind() || !resourceAnnotationInstance.target().asField().annotations().stream().noneMatch(a -> DotNames.INJECT.equals((Object)a.name()))) continue;
                injections.add(new Injection(resourceAnnotationInstance.target(), Collections.singletonList(InjectionPointInfo.fromResourceField(resourceAnnotationInstance.target().asField(), beanClass, beanDeployment, transformer))));
            }
        }
        if (!classInfo.superName().equals((Object)DotNames.OBJECT) && (info = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            Injection.forClassBean(beanClass, info, beanDeployment, injections, transformer, true);
        }
    }

    private static boolean hasConstructorInjection(List<Injection> injections) {
        for (Injection injection : injections) {
            if (!injection.isConstructor()) continue;
            return true;
        }
        return false;
    }

    static Injection forDisposer(MethodInfo disposerMethod, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer, BeanInfo declaringBean) {
        return new Injection((AnnotationTarget)disposerMethod, InjectionPointInfo.fromMethod(disposerMethod, beanClass, beanDeployment, annotations -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.DISPOSES)), transformer));
    }

    static Injection forObserver(MethodInfo observerMethod, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        return new Injection((AnnotationTarget)observerMethod, InjectionPointInfo.fromMethod(observerMethod, beanClass, beanDeployment, annotations -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.OBSERVES) || a.name().equals((Object)DotNames.OBSERVES_ASYNC)), transformer));
    }

    public Injection(AnnotationTarget target, List<InjectionPointInfo> injectionPoints) {
        this.target = target;
        this.injectionPoints = injectionPoints;
    }

    boolean isMethod() {
        return AnnotationTarget.Kind.METHOD == this.target.kind();
    }

    boolean isConstructor() {
        return this.isMethod() && this.target.asMethod().name().equals("<init>");
    }

    boolean isField() {
        return AnnotationTarget.Kind.FIELD == this.target.kind();
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public void init(BeanInfo targetBean) {
        for (InjectionPointInfo injectionPoint : this.injectionPoints) {
            injectionPoint.setTargetBean(targetBean);
        }
    }

    private static List<AnnotationInstance> getAllInjectionPoints(BeanDeployment beanDeployment, ClassInfo beanClass, DotName name, boolean skipConstructors) {
        AnnotationInstance inject;
        ArrayList<AnnotationInstance> injectAnnotations = new ArrayList<AnnotationInstance>();
        for (FieldInfo field : beanClass.fields()) {
            inject = beanDeployment.getAnnotation((AnnotationTarget)field, name);
            if (inject == null) continue;
            if (Modifier.isFinal(field.flags()) || Modifier.isStatic(field.flags())) {
                LOGGER.warn((Object)("An injection field must be non-static and non-final - ignoring: " + field.declaringClass().name() + "#" + field.name()));
                continue;
            }
            injectAnnotations.add(inject);
        }
        for (MethodInfo method : beanClass.methods()) {
            if (skipConstructors && method.name().equals("<init>") || (inject = beanDeployment.getAnnotation((AnnotationTarget)method, name)) == null) continue;
            injectAnnotations.add(inject);
        }
        return injectAnnotations;
    }
}

