/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InterceptorInfo;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

final class Interceptors {
    static final Logger LOGGER = Logger.getLogger(Interceptors.class);

    private Interceptors() {
    }

    static InterceptorInfo createInterceptor(ClassInfo interceptorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer, AnnotationStore store) {
        HashSet<AnnotationInstance> bindings = new HashSet<AnnotationInstance>();
        Integer priority = null;
        for (AnnotationInstance annotation : store.getAnnotations((AnnotationTarget)interceptorClass)) {
            bindings.addAll(beanDeployment.extractInterceptorBindings(annotation));
            Set<AnnotationInstance> transitiveInterceptorBindings = beanDeployment.getTransitiveInterceptorBindings(annotation.name());
            if (transitiveInterceptorBindings != null) {
                bindings.addAll(transitiveInterceptorBindings);
            }
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if (priority != null || !annotation.name().equals((Object)DotNames.ARC_PRIORITY)) continue;
            priority = annotation.value().asInt();
        }
        if (bindings.isEmpty()) {
            throw new DefinitionException("Interceptor has no bindings: " + interceptorClass);
        }
        if (priority == null) {
            LOGGER.info((Object)("The interceptor " + interceptorClass + " does not declare any @Priority. It will be assigned a default priority value of 0."));
            priority = 0;
        }
        return new InterceptorInfo((AnnotationTarget)interceptorClass, beanDeployment, bindings.size() == 1 ? Collections.singleton((AnnotationInstance)bindings.iterator().next()) : Collections.unmodifiableSet(bindings), Injection.forBean((AnnotationTarget)interceptorClass, null, beanDeployment, transformer), priority);
    }
}

