/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AlternativePriorities;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AssignabilityCheck;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BeanResolverImpl;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.Decorators;
import io.quarkus.arc.processor.DelegateInjectionPointResolverImpl;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InterceptorResolver;
import io.quarkus.arc.processor.Interceptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.ObserverTransformer;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.StereotypeRegistrar;
import io.quarkus.arc.processor.Types;
import io.quarkus.arc.processor.UnusedBeans;
import io.quarkus.arc.processor.bcextensions.ExtensionsEntryPoint;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class BeanDeployment {
    private static final Logger LOGGER = Logger.getLogger(BeanDeployment.class);
    private final String name;
    private final BeanProcessor.BuildContextImpl buildContext;
    private final IndexView beanArchiveComputingIndex;
    private final IndexView beanArchiveImmutableIndex;
    private final IndexView applicationIndex;
    private final Map<DotName, ClassInfo> qualifiers;
    private final Map<DotName, ClassInfo> repeatingQualifierAnnotations;
    private final Map<DotName, Set<String>> qualifierNonbindingMembers;
    private final Map<DotName, ClassInfo> interceptorBindings;
    private final Map<DotName, ClassInfo> repeatingInterceptorBindingAnnotations;
    private final Map<DotName, Set<String>> interceptorNonbindingMembers;
    private final Map<DotName, Set<AnnotationInstance>> transitiveInterceptorBindings;
    private final Map<DotName, StereotypeInfo> stereotypes;
    private final List<BeanInfo> beans;
    private volatile Map<DotName, List<BeanInfo>> beansByType;
    private final List<InterceptorInfo> interceptors;
    private final List<DecoratorInfo> decorators;
    private final List<ObserverInfo> observers;
    final BeanResolverImpl beanResolver;
    final DelegateInjectionPointResolverImpl delegateInjectionPointResolver;
    private final AssignabilityCheck assignabilityCheck;
    private final InterceptorResolver interceptorResolver;
    private final AnnotationStore annotationStore;
    private final InjectionPointModifier injectionPointTransformer;
    private final List<ObserverTransformer> observerTransformers;
    private final Set<DotName> resourceAnnotations;
    private final List<InjectionPointInfo> injectionPoints;
    private final boolean removeUnusedBeans;
    private final List<Predicate<BeanInfo>> unusedExclusions;
    private final Set<BeanInfo> removedBeans;
    private final Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts;
    private final Map<DotName, BeanDefiningAnnotation> beanDefiningAnnotations;
    final boolean transformUnproxyableClasses;
    final boolean transformPrivateInjectedFields;
    final boolean failOnInterceptedPrivateMethod;
    private final boolean jtaCapabilities;
    final boolean strictCompatibility;
    private final AlternativePriorities alternativePriorities;
    private final List<Predicate<ClassInfo>> excludeTypes;
    private final ExtensionsEntryPoint buildCompatibleExtensions;

    BeanDeployment(String name, BeanProcessor.BuildContextImpl buildContext, BeanProcessor.Builder builder) {
        DotName dotName;
        this.name = name;
        this.buildCompatibleExtensions = builder.buildCompatibleExtensions;
        this.buildContext = buildContext;
        HashMap<DotName, BeanDefiningAnnotation> beanDefiningAnnotations = new HashMap<DotName, BeanDefiningAnnotation>();
        if (builder.additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation beanDefiningAnnotation : builder.additionalBeanDefiningAnnotations) {
                beanDefiningAnnotations.put(beanDefiningAnnotation.getAnnotation(), beanDefiningAnnotation);
            }
        }
        this.beanDefiningAnnotations = beanDefiningAnnotations;
        this.resourceAnnotations = new HashSet<DotName>(builder.resourceAnnotations);
        this.beanArchiveComputingIndex = builder.beanArchiveComputingIndex;
        this.beanArchiveImmutableIndex = Objects.requireNonNull(builder.beanArchiveImmutableIndex);
        this.applicationIndex = builder.applicationIndex;
        this.annotationStore = new AnnotationStore(BeanProcessor.initAndSort(builder.annotationTransformers, buildContext), buildContext);
        if (buildContext != null) {
            buildContext.putInternal(BuildExtension.Key.ANNOTATION_STORE.asString(), this.annotationStore);
        }
        this.injectionPointTransformer = new InjectionPointModifier(BeanProcessor.initAndSort(builder.injectionPointTransformers, buildContext), buildContext);
        this.observerTransformers = BeanProcessor.initAndSort(builder.observerTransformers, buildContext);
        this.removeUnusedBeans = builder.removeUnusedBeans;
        this.unusedExclusions = this.removeUnusedBeans ? new ArrayList<Predicate<BeanInfo>>(builder.removalExclusions) : null;
        this.removedBeans = this.removeUnusedBeans ? new CopyOnWriteArraySet() : Collections.emptySet();
        this.customContexts = new ConcurrentHashMap<ScopeInfo, Function<MethodCreator, ResultHandle>>();
        this.excludeTypes = builder.excludeTypes != null ? new ArrayList<Predicate<ClassInfo>>(builder.excludeTypes) : Collections.emptyList();
        this.qualifierNonbindingMembers = new HashMap<DotName, Set<String>>();
        this.qualifiers = this.findQualifiers();
        for (QualifierRegistrar qualifierRegistrar : builder.qualifierRegistrars) {
            for (Map.Entry<DotName, Set<String>> entry : qualifierRegistrar.getAdditionalQualifiers().entrySet()) {
                dotName = entry.getKey();
                ClassInfo classInfo = IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), dotName);
                if (classInfo == null) continue;
                Set<String> nonbindingMembers = entry.getValue();
                if (nonbindingMembers == null) {
                    nonbindingMembers = Collections.emptySet();
                }
                this.qualifierNonbindingMembers.put(dotName, nonbindingMembers);
                this.qualifiers.put(dotName, classInfo);
            }
        }
        this.repeatingQualifierAnnotations = this.findContainerAnnotations(this.qualifiers);
        this.buildContextPut(BuildExtension.Key.QUALIFIERS.asString(), Collections.unmodifiableMap(this.qualifiers));
        this.interceptorNonbindingMembers = new HashMap<DotName, Set<String>>();
        this.interceptorBindings = this.findInterceptorBindings();
        for (InterceptorBindingRegistrar interceptorBindingRegistrar : builder.interceptorBindingRegistrars) {
            for (InterceptorBindingRegistrar.InterceptorBinding binding : interceptorBindingRegistrar.getAdditionalBindings()) {
                dotName = binding.getName();
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), dotName);
                if (annotationClass != null) {
                    HashSet<String> nonbinding = new HashSet<String>();
                    for (MethodInfo method : annotationClass.methods()) {
                        if (!binding.isNonbinding(method.name())) continue;
                        nonbinding.add(method.name());
                    }
                    this.interceptorNonbindingMembers.put(dotName, nonbinding);
                }
                this.interceptorBindings.put(dotName, annotationClass);
            }
        }
        this.repeatingInterceptorBindingAnnotations = this.findContainerAnnotations(this.interceptorBindings);
        this.buildContextPut(BuildExtension.Key.INTERCEPTOR_BINDINGS.asString(), Collections.unmodifiableMap(this.interceptorBindings));
        HashSet<DotName> additionalStereotypes = new HashSet<DotName>();
        for (StereotypeRegistrar stereotypeRegistrar : builder.stereotypeRegistrars) {
            additionalStereotypes.addAll(stereotypeRegistrar.getAdditionalStereotypes());
        }
        this.stereotypes = this.findStereotypes(this.interceptorBindings, this.customContexts, additionalStereotypes, this.annotationStore);
        this.buildContextPut(BuildExtension.Key.STEREOTYPES.asString(), Collections.unmodifiableMap(this.stereotypes));
        this.transitiveInterceptorBindings = BeanDeployment.findTransitiveInterceptorBindings(this.interceptorBindings.keySet(), new HashMap<DotName, Set<AnnotationInstance>>(), this.interceptorBindings, this.annotationStore);
        this.injectionPoints = new CopyOnWriteArrayList<InjectionPointInfo>();
        this.interceptors = new CopyOnWriteArrayList<InterceptorInfo>();
        this.decorators = new CopyOnWriteArrayList<DecoratorInfo>();
        this.beans = new CopyOnWriteArrayList<BeanInfo>();
        this.observers = new CopyOnWriteArrayList<ObserverInfo>();
        this.assignabilityCheck = new AssignabilityCheck(this.getBeanArchiveIndex(), this.applicationIndex);
        this.beanResolver = new BeanResolverImpl(this);
        this.delegateInjectionPointResolver = new DelegateInjectionPointResolverImpl(this);
        this.interceptorResolver = new InterceptorResolver(this);
        this.transformUnproxyableClasses = builder.transformUnproxyableClasses;
        this.transformPrivateInjectedFields = builder.transformPrivateInjectedFields;
        this.failOnInterceptedPrivateMethod = builder.failOnInterceptedPrivateMethod;
        this.jtaCapabilities = builder.jtaCapabilities;
        this.strictCompatibility = builder.strictCompatibility;
        this.alternativePriorities = builder.alternativePriorities;
    }

    ContextRegistrar.RegistrationContext registerCustomContexts(List<ContextRegistrar> contextRegistrars) {
        ContextRegistrar.RegistrationContext registrationContext = new ContextRegistrar.RegistrationContext(){

            @Override
            public <V> V put(BuildExtension.Key<V> key, V value) {
                return BeanDeployment.this.buildContext.put(key, value);
            }

            @Override
            public <V> V get(BuildExtension.Key<V> key) {
                return BeanDeployment.this.buildContext.get(key);
            }

            @Override
            public ContextConfigurator configure(Class<? extends Annotation> scopeAnnotation) {
                return new ContextConfigurator(scopeAnnotation, c -> {
                    ScopeInfo scope = new ScopeInfo(c.scopeAnnotation, c.isNormal);
                    BeanDeployment.this.beanDefiningAnnotations.put(scope.getDotName(), new BeanDefiningAnnotation(scope.getDotName(), null));
                    BeanDeployment.this.customContexts.put(scope, c.creator);
                });
            }
        };
        for (ContextRegistrar contextRegistrar : contextRegistrars) {
            contextRegistrar.register(registrationContext);
        }
        return registrationContext;
    }

    void registerScopes() {
        if (this.buildContext != null) {
            List allScopes = Arrays.stream(BuiltinScope.values()).map(i -> i.getInfo()).collect(Collectors.toList());
            allScopes.addAll(this.customContexts.keySet());
            this.buildContext.putInternal(BuildExtension.Key.SCOPES.asString(), Collections.unmodifiableList(allScopes));
        }
    }

    BeanRegistrar.RegistrationContext registerBeans(List<BeanRegistrar> beanRegistrars) {
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        this.beans.addAll(this.findBeans(BeanDeployment.initBeanDefiningAnnotations(this.beanDefiningAnnotations.values(), this.stereotypes.keySet()), this.observers, injectionPoints, this.jtaCapabilities));
        this.buildContextPut(BuildExtension.Key.BEANS.asString(), Collections.unmodifiableList(this.beans));
        this.buildContextPut(BuildExtension.Key.OBSERVERS.asString(), Collections.unmodifiableList(this.observers));
        this.interceptors.addAll(this.findInterceptors(injectionPoints));
        this.buildContextPut(BuildExtension.Key.INTERCEPTORS.asString(), Collections.unmodifiableList(this.interceptors));
        this.decorators.addAll(this.findDecorators(injectionPoints));
        this.buildContextPut(BuildExtension.Key.DECORATORS.asString(), Collections.unmodifiableList(this.decorators));
        this.injectionPoints.addAll(injectionPoints);
        this.buildContextPut(BuildExtension.Key.INJECTION_POINTS.asString(), Collections.unmodifiableList(this.injectionPoints));
        if (this.buildCompatibleExtensions != null) {
            this.buildCompatibleExtensions.runRegistration(this.beanArchiveComputingIndex, this.beans, this.observers);
        }
        return this.registerSyntheticBeans(beanRegistrars, this.buildContext);
    }

    void init(Consumer<BytecodeTransformer> bytecodeTransformerConsumer, List<Predicate<BeanInfo>> additionalUnusedBeanExclusions) {
        long start = System.nanoTime();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (BeanInfo bean : this.beans) {
            bean.init(errors, bytecodeTransformerConsumer, this.transformUnproxyableClasses);
        }
        for (ObserverInfo observer : this.observers) {
            observer.init(errors);
        }
        for (InterceptorInfo interceptor : this.interceptors) {
            interceptor.init(errors, bytecodeTransformerConsumer, this.transformUnproxyableClasses);
        }
        for (DecoratorInfo decorator : this.decorators) {
            decorator.init(errors, bytecodeTransformerConsumer, this.transformUnproxyableClasses);
        }
        BeanDeployment.processErrors(errors);
        ArrayList<Predicate<BeanInfo>> allUnusedExclusions = new ArrayList<Predicate<BeanInfo>>(additionalUnusedBeanExclusions);
        if (this.unusedExclusions != null) {
            allUnusedExclusions.addAll(this.unusedExclusions);
        }
        if (this.removeUnusedBeans) {
            long removalStart = System.nanoTime();
            Set<BeanInfo> declaresObserver = this.observers.stream().map(ObserverInfo::getDeclaringBean).collect(Collectors.toSet());
            HashSet<DecoratorInfo> removedDecorators = new HashSet<DecoratorInfo>();
            HashSet<InterceptorInfo> removedInterceptors = new HashSet<InterceptorInfo>();
            this.removeUnusedComponents(declaresObserver, allUnusedExclusions, removedDecorators, removedInterceptors);
            LOGGER.debugf("Removed %s beans, %s interceptors and %s decorators in %s ms", new Object[]{this.removedBeans.size(), removedInterceptors.size(), removedDecorators.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - removalStart)});
            this.initBeanByTypeMap();
            this.buildContext.putInternal(BuildExtension.Key.REMOVED_INTERCEPTORS.asString(), Collections.unmodifiableSet(removedInterceptors));
            this.buildContext.putInternal(BuildExtension.Key.REMOVED_DECORATORS.asString(), Collections.unmodifiableSet(removedDecorators));
        }
        this.buildContext.putInternal(BuildExtension.Key.REMOVED_BEANS.asString(), Collections.unmodifiableSet(this.removedBeans));
        LOGGER.debugf("Bean deployment initialized in %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void initBeanByTypeMap() {
        HashMap<DotName, List<BeanInfo>> map = new HashMap<DotName, List<BeanInfo>>();
        for (BeanInfo bean : this.beans) {
            bean.types.stream().map(Type::name).distinct().forEach(rawTypeName -> {
                if (DotNames.OBJECT.equals(rawTypeName)) {
                    return;
                }
                List beans = (List)map.get(rawTypeName);
                if (beans == null) {
                    map.put((DotName)rawTypeName, List.of(bean));
                } else if (beans.size() == 1) {
                    map.put((DotName)rawTypeName, List.of((BeanInfo)beans.get(0), bean));
                } else {
                    BeanInfo[] array = new BeanInfo[beans.size() + 1];
                    for (int i = 0; i < beans.size(); ++i) {
                        array[i] = (BeanInfo)beans.get(i);
                    }
                    array[beans.size()] = bean;
                    map.put((DotName)rawTypeName, List.of(array));
                }
            });
        }
        this.beansByType = map;
    }

    private void removeUnusedComponents(Set<BeanInfo> declaresObserver, List<Predicate<BeanInfo>> allUnusedExclusions, Set<DecoratorInfo> removedDecorators, Set<InterceptorInfo> removedInterceptors) {
        do {
            int removed = 0;
            removed += this.removeUnusedBeans(declaresObserver, allUnusedExclusions).size();
            removed += this.removeUnusedInterceptors(removedInterceptors, allUnusedExclusions).size();
        } while ((removed += this.removeUnusedDecorators(removedDecorators, allUnusedExclusions).size()) > 0);
    }

    private Set<InterceptorInfo> removeUnusedInterceptors(Set<InterceptorInfo> removedInterceptors, List<Predicate<BeanInfo>> allUnusedExclusions) {
        HashSet<InterceptorInfo> removableInterceptors = new HashSet<InterceptorInfo>();
        for (InterceptorInfo interceptor : this.interceptors) {
            boolean bl = true;
            for (Predicate<BeanInfo> exclusion : allUnusedExclusions) {
                if (!exclusion.test(interceptor)) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (BeanInfo bean : this.beans) {
                    if (!bean.getBoundInterceptors().contains(interceptor)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            removableInterceptors.add(interceptor);
        }
        if (!removableInterceptors.isEmpty()) {
            removedInterceptors.addAll(removableInterceptors);
            this.interceptors.removeAll(removableInterceptors);
            ArrayList<InjectionPointInfo> removableInjectionPoints = new ArrayList<InjectionPointInfo>();
            for (BeanInfo beanInfo : removableInterceptors) {
                removableInjectionPoints.addAll(beanInfo.getAllInjectionPoints());
            }
            this.injectionPoints.removeAll(removableInjectionPoints);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf(removableInterceptors.stream().map(i -> "Removed unused interceptor " + i).collect(Collectors.joining("\n")), new Object[0]);
            }
        }
        return removableInterceptors;
    }

    private Set<DecoratorInfo> removeUnusedDecorators(Set<DecoratorInfo> removedDecorators, List<Predicate<BeanInfo>> allUnusedExclusions) {
        HashSet<DecoratorInfo> removableDecorators = new HashSet<DecoratorInfo>();
        for (DecoratorInfo decorator : this.decorators) {
            boolean bl = true;
            for (Predicate<BeanInfo> exclusion : allUnusedExclusions) {
                if (!exclusion.test(decorator)) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (BeanInfo bean : this.beans) {
                    if (!bean.getBoundDecorators().contains(decorator)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            removableDecorators.add(decorator);
        }
        if (!removableDecorators.isEmpty()) {
            removedDecorators.addAll(removableDecorators);
            this.decorators.removeAll(removableDecorators);
            ArrayList<InjectionPointInfo> removableInjectionPoints = new ArrayList<InjectionPointInfo>();
            for (BeanInfo beanInfo : removableDecorators) {
                removableInjectionPoints.addAll(beanInfo.getAllInjectionPoints());
            }
            this.injectionPoints.removeAll(removableInjectionPoints);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf(removableDecorators.stream().map(i -> "Removed unused decorator " + i).collect(Collectors.joining("\n")), new Object[0]);
            }
        }
        return removableDecorators;
    }

    private Set<BeanInfo> removeUnusedBeans(Set<BeanInfo> declaresObserver, List<Predicate<BeanInfo>> allUnusedExclusions) {
        Set<BeanInfo> removableBeans = UnusedBeans.findRemovableBeans(this.beans, this.injectionPoints, declaresObserver, allUnusedExclusions);
        if (!removableBeans.isEmpty()) {
            this.beans.removeAll(removableBeans);
            this.removedBeans.addAll(removableBeans);
            ArrayList<InjectionPointInfo> removableInjectionPoints = new ArrayList<InjectionPointInfo>();
            for (BeanInfo bean : removableBeans) {
                removableInjectionPoints.addAll(bean.getAllInjectionPoints());
            }
            this.injectionPoints.removeAll(removableInjectionPoints);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf(this.removedBeans.stream().map(b -> "Removed unused " + b).collect(Collectors.joining("\n")), new Object[0]);
            }
        }
        return removableBeans;
    }

    BeanDeploymentValidator.ValidationContext validate(List<BeanDeploymentValidator> validators, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validateBeans(errors, bytecodeTransformerConsumer);
        this.validateInterceptorsAndDecorators(errors, bytecodeTransformerConsumer);
        ValidationContextImpl validationContext = new ValidationContextImpl(this.buildContext);
        for (Throwable error : errors) {
            validationContext.addDeploymentProblem(error);
        }
        for (BeanDeploymentValidator validator : validators) {
            validator.validate(validationContext);
        }
        return validationContext;
    }

    public Collection<BeanInfo> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    Collection<BeanInfo> getBeansByRawType(DotName typeName) {
        List<BeanInfo> ret = this.beansByType.get(typeName);
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    public Collection<BeanInfo> getRemovedBeans() {
        return Collections.unmodifiableSet(this.removedBeans);
    }

    public Collection<ClassInfo> getQualifiers() {
        return Collections.unmodifiableCollection(this.qualifiers.values());
    }

    Map<DotName, Set<String>> getQualifierNonbindingMembers() {
        return this.qualifierNonbindingMembers;
    }

    public Collection<ClassInfo> getInterceptorBindings() {
        return Collections.unmodifiableCollection(this.interceptorBindings.values());
    }

    public Collection<InjectionPointInfo> getInjectionPoints() {
        return Collections.unmodifiableList(this.injectionPoints);
    }

    public Collection<ObserverInfo> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public Collection<InterceptorInfo> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public Collection<DecoratorInfo> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public Collection<StereotypeInfo> getStereotypes() {
        return Collections.unmodifiableCollection(this.stereotypes.values());
    }

    Map<DotName, StereotypeInfo> getStereotypesMap() {
        return Collections.unmodifiableMap(this.stereotypes);
    }

    public IndexView getBeanArchiveIndex() {
        return this.beanArchiveComputingIndex != null ? this.beanArchiveComputingIndex : this.beanArchiveImmutableIndex;
    }

    public IndexView getApplicationIndex() {
        return this.applicationIndex;
    }

    public BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public BeanResolver getDelegateInjectionPointResolver() {
        return this.delegateInjectionPointResolver;
    }

    public AssignabilityCheck getAssignabilityCheck() {
        return this.assignabilityCheck;
    }

    boolean hasApplicationIndex() {
        return this.applicationIndex != null;
    }

    public InterceptorResolver getInterceptorResolver() {
        return this.interceptorResolver;
    }

    ClassInfo getQualifier(DotName name) {
        return this.qualifiers.get(name);
    }

    boolean isInheritedQualifier(DotName name) {
        return this.getQualifier(name).declaredAnnotation(DotNames.INHERITED) != null;
    }

    Collection<AnnotationInstance> extractQualifiers(AnnotationInstance annotation) {
        return BeanDeployment.extractAnnotations(annotation, this.qualifiers, this.repeatingQualifierAnnotations);
    }

    Collection<AnnotationInstance> extractInterceptorBindings(AnnotationInstance annotation) {
        return BeanDeployment.extractAnnotations(annotation, this.interceptorBindings, this.repeatingInterceptorBindingAnnotations);
    }

    private static Collection<AnnotationInstance> extractAnnotations(AnnotationInstance annotation, Map<DotName, ClassInfo> singulars, Map<DotName, ClassInfo> repeatables) {
        if (!annotation.runtimeVisible()) {
            return Collections.emptyList();
        }
        DotName annotationName = annotation.name();
        if (singulars.get(annotationName) != null) {
            return Collections.singleton(annotation);
        }
        if (repeatables.get(annotationName) != null) {
            return Annotations.onlyRuntimeVisible(Arrays.asList(annotation.value().asNestedArray()));
        }
        return Collections.emptyList();
    }

    ClassInfo getInterceptorBinding(DotName name) {
        return this.interceptorBindings.get(name);
    }

    Set<AnnotationInstance> getTransitiveInterceptorBindings(DotName name) {
        return this.transitiveInterceptorBindings.get(name);
    }

    Map<DotName, Set<AnnotationInstance>> getTransitiveInterceptorBindings() {
        return this.transitiveInterceptorBindings;
    }

    StereotypeInfo getStereotype(DotName name) {
        return this.stereotypes.get(name);
    }

    BeanDefiningAnnotation getBeanDefiningAnnotation(DotName name) {
        return this.beanDefiningAnnotations.get(name);
    }

    Set<DotName> getResourceAnnotations() {
        return this.resourceAnnotations;
    }

    AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    public Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        return this.annotationStore.getAnnotations(target);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return this.annotationStore.getAnnotation(target, name);
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName name) {
        return this.annotationStore.hasAnnotation(target, name);
    }

    Map<ScopeInfo, Function<MethodCreator, ResultHandle>> getCustomContexts() {
        return this.customContexts;
    }

    ScopeInfo getScope(DotName scopeAnnotationName) {
        return BeanDeployment.getScope(scopeAnnotationName, this.customContexts);
    }

    Integer computeAlternativePriority(AnnotationTarget target, List<StereotypeInfo> stereotypes) {
        return this.alternativePriorities != null ? this.alternativePriorities.compute(target, stereotypes) : null;
    }

    Set<MethodInfo> getObserverAndProducerMethods() {
        HashSet<MethodInfo> ret = new HashSet<MethodInfo>();
        for (ObserverInfo observer : this.observers) {
            if (observer.isSynthetic()) continue;
            ret.add(observer.getObserverMethod());
        }
        for (BeanInfo bean : this.beans) {
            if (!bean.isProducerMethod()) continue;
            ret.add(bean.getTarget().get().asMethod());
        }
        return ret;
    }

    private void buildContextPut(String key, Object value) {
        if (this.buildContext != null) {
            this.buildContext.putInternal(key, value);
        }
    }

    private boolean isRuntimeAnnotationType(ClassInfo annotationType) {
        AnnotationInstance retention = annotationType.declaredAnnotation(Retention.class);
        return retention != null && "RUNTIME".equals(retention.value().asEnum());
    }

    private Map<DotName, ClassInfo> findQualifiers() {
        HashMap<DotName, ClassInfo> qualifiers = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance qualifier : this.beanArchiveImmutableIndex.getAnnotations(DotNames.QUALIFIER)) {
            ClassInfo qualifierClass = qualifier.target().asClass();
            if (!this.isRuntimeAnnotationType(qualifierClass) || this.isExcluded(qualifierClass)) continue;
            qualifiers.put(qualifierClass.name(), qualifierClass);
        }
        return qualifiers;
    }

    private Map<DotName, ClassInfo> findContainerAnnotations(Map<DotName, ClassInfo> annotations) {
        HashMap<DotName, ClassInfo> containerAnnotations = new HashMap<DotName, ClassInfo>();
        for (ClassInfo annotation : annotations.values()) {
            AnnotationInstance repeatableMetaAnnotation = annotation.declaredAnnotation(DotNames.REPEATABLE);
            if (repeatableMetaAnnotation == null) continue;
            DotName containerAnnotationName = repeatableMetaAnnotation.value().asClass().name();
            ClassInfo containerClass = IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), containerAnnotationName);
            containerAnnotations.put(containerAnnotationName, containerClass);
        }
        return containerAnnotations;
    }

    private Map<DotName, ClassInfo> findInterceptorBindings() {
        HashMap<DotName, ClassInfo> bindings = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance binding : this.beanArchiveImmutableIndex.getAnnotations(DotNames.INTERCEPTOR_BINDING)) {
            ClassInfo bindingClass = binding.target().asClass();
            if (!this.isRuntimeAnnotationType(bindingClass) || this.isExcluded(bindingClass)) continue;
            bindings.put(bindingClass.name(), bindingClass);
        }
        return bindings;
    }

    private static Map<DotName, Set<AnnotationInstance>> findTransitiveInterceptorBindings(Collection<DotName> initialBindings, Map<DotName, Set<AnnotationInstance>> result, Map<DotName, ClassInfo> interceptorBindings, AnnotationStore annotationStore) {
        for (DotName annotationName : initialBindings) {
            HashSet<AnnotationInstance> transitiveBindings = new HashSet<AnnotationInstance>();
            for (AnnotationInstance bindingCandidate : annotationStore.getAnnotations((AnnotationTarget)interceptorBindings.get(annotationName))) {
                if (interceptorBindings.get(bindingCandidate.name()) == null) continue;
                transitiveBindings.add(bindingCandidate);
            }
            if (transitiveBindings.isEmpty()) continue;
            result.computeIfAbsent(annotationName, k -> new HashSet()).addAll(transitiveBindings);
        }
        for (DotName name : result.keySet()) {
            result.put(name, BeanDeployment.recursiveBuild(name, result));
        }
        return result;
    }

    private static Set<AnnotationInstance> recursiveBuild(DotName name, Map<DotName, Set<AnnotationInstance>> transitiveBindingsMap) {
        Set<AnnotationInstance> result = transitiveBindingsMap.get(name);
        for (AnnotationInstance instance : transitiveBindingsMap.get(name)) {
            if (!transitiveBindingsMap.containsKey(instance.name())) continue;
            result.addAll(BeanDeployment.recursiveBuild(instance.name(), transitiveBindingsMap));
        }
        return result;
    }

    private Map<DotName, StereotypeInfo> findStereotypes(Map<DotName, ClassInfo> interceptorBindings, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts, Set<DotName> additionalStereotypes, AnnotationStore annotationStore) {
        HashMap<DotName, StereotypeInfo> stereotypes = new HashMap<DotName, StereotypeInfo>();
        HashSet<DotName> stereotypeNames = new HashSet<DotName>();
        for (AnnotationInstance annotation : this.beanArchiveImmutableIndex.getAnnotations(DotNames.STEREOTYPE)) {
            stereotypeNames.add(annotation.target().asClass().name());
        }
        stereotypeNames.addAll(additionalStereotypes);
        for (DotName stereotypeName : stereotypeNames) {
            ClassInfo stereotypeClass = IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), stereotypeName);
            if (stereotypeClass == null || this.isExcluded(stereotypeClass) || !this.isRuntimeAnnotationType(stereotypeClass)) continue;
            boolean isAlternative = false;
            Integer alternativePriority = null;
            HashSet<ScopeInfo> scopes = new HashSet<ScopeInfo>();
            ArrayList<AnnotationInstance> bindings = new ArrayList<AnnotationInstance>();
            ArrayList<AnnotationInstance> parentStereotypes = new ArrayList<AnnotationInstance>();
            boolean isNamed = false;
            for (AnnotationInstance annotation : annotationStore.getAnnotations((AnnotationTarget)stereotypeClass)) {
                if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                    isAlternative = true;
                    continue;
                }
                if (interceptorBindings.containsKey(annotation.name())) {
                    bindings.add(annotation);
                    continue;
                }
                if (stereotypeNames.contains(annotation.name())) {
                    parentStereotypes.add(annotation);
                    continue;
                }
                if (DotNames.NAMED.equals((Object)annotation.name())) {
                    if (annotation.value() != null && !annotation.value().asString().isEmpty()) {
                        throw new DefinitionException("Stereotype must not declare @Named with a non-empty value: " + stereotypeClass);
                    }
                    isNamed = true;
                    continue;
                }
                if (DotNames.PRIORITY.equals((Object)annotation.name())) {
                    alternativePriority = annotation.value().asInt();
                    continue;
                }
                if (DotNames.ARC_PRIORITY.equals((Object)annotation.name()) && alternativePriority == null) {
                    alternativePriority = annotation.value().asInt();
                    continue;
                }
                ScopeInfo scope = BeanDeployment.getScope(annotation.name(), customContexts);
                if (scope == null) continue;
                scopes.add(scope);
            }
            boolean isAdditionalStereotype = additionalStereotypes.contains(stereotypeName);
            ScopeInfo scope = BeanDeployment.getValidScope(scopes, (AnnotationTarget)stereotypeClass);
            boolean isInherited = stereotypeClass.declaredAnnotation(DotNames.INHERITED) != null;
            stereotypes.put(stereotypeName, new StereotypeInfo(scope, bindings, isAlternative, alternativePriority, isNamed, isAdditionalStereotype, stereotypeClass, isInherited, parentStereotypes));
        }
        return stereotypes;
    }

    private static ScopeInfo getScope(DotName scopeAnnotationName, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts) {
        BuiltinScope builtin = BuiltinScope.from(scopeAnnotationName);
        if (builtin != null) {
            return builtin.getInfo();
        }
        for (ScopeInfo customScope : customContexts.keySet()) {
            if (!customScope.getDotName().equals((Object)scopeAnnotationName)) continue;
            return customScope;
        }
        return null;
    }

    static ScopeInfo getValidScope(Set<ScopeInfo> scopes, AnnotationTarget target) {
        switch (scopes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return scopes.iterator().next();
            }
        }
        throw new DefinitionException("Different scopes defined for: " + target + "; scopes: " + scopes.stream().map(ScopeInfo::getDotName).map(DotName::toString).collect(Collectors.joining(", ")));
    }

    /*
     * WARNING - void declaration
     */
    private List<BeanInfo> findBeans(Collection<DotName> beanDefiningAnnotations, List<ObserverInfo> observers, List<InjectionPointInfo> injectionPoints, boolean jtaCapabilities) {
        DisposerInfo disposer;
        Set<Type> beanTypes;
        BeanInfo declaringBean;
        HashSet<ClassInfo> beanClasses = new HashSet<ClassInfo>();
        HashSet<MethodInfo> producerMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> disposerMethods = new HashSet<MethodInfo>();
        HashSet<FieldInfo> producerFields = new HashSet<FieldInfo>();
        HashMap<MethodInfo, Set> syncObserverMethods = new HashMap<MethodInfo, Set>();
        HashMap<MethodInfo, Set> asyncObserverMethods = new HashMap<MethodInfo, Set>();
        Set realStereotypes = this.stereotypes.values().stream().filter(StereotypeInfo::isGenuine).map(StereotypeInfo::getName).collect(Collectors.toSet());
        for (ClassInfo beanClass : this.beanArchiveImmutableIndex.getKnownClasses()) {
            if (Modifier.isInterface(beanClass.flags()) || Modifier.isAbstract(beanClass.flags()) || beanClass.isAnnotation() || beanClass.isEnum() || beanClass.nestingType().equals((Object)ClassInfo.NestingType.ANONYMOUS) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.LOCAL) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.INNER) && !Modifier.isStatic(beanClass.flags()) || this.isExcluded(beanClass)) continue;
            if (!beanClass.hasNoArgsConstructor()) {
                int numberOfConstructorsWithoutInject = 0;
                int numberOfConstructorsWithInject = 0;
                for (MethodInfo methodInfo : beanClass.methods()) {
                    if (!methodInfo.name().equals("<init>")) continue;
                    if (this.annotationStore.hasAnnotation((AnnotationTarget)methodInfo, DotNames.INJECT)) {
                        ++numberOfConstructorsWithInject;
                        continue;
                    }
                    ++numberOfConstructorsWithoutInject;
                }
                if (numberOfConstructorsWithInject == 0 && numberOfConstructorsWithoutInject != 1) continue;
            }
            if (this.isVetoed(beanClass) || this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.INTERCEPTOR) || this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.DECORATOR) || beanClass.interfaceNames().contains(DotNames.EXTENSION) || beanClass.interfaceNames().contains(DotNames.BUILD_COMPATIBLE_EXTENSION)) continue;
            boolean hasBeanDefiningAnnotation = false;
            if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)beanClass, beanDefiningAnnotations)) {
                hasBeanDefiningAnnotation = true;
                beanClasses.add(beanClass);
            }
            for (MethodInfo method : beanClass.methods()) {
                if (method.isSynthetic() || this.annotationStore.getAnnotations((AnnotationTarget)method).isEmpty()) continue;
                if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES) && !this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.VETOED_PRODUCER)) {
                    producerMethods.add(method);
                    if (!hasBeanDefiningAnnotation) {
                        LOGGER.debugf("Producer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                        beanClasses.add(beanClass);
                    }
                }
                if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) continue;
                disposerMethods.add(method);
            }
            ClassInfo aClass = beanClass;
            HashSet<Methods.MethodKey> methods = new HashSet<Methods.MethodKey>();
            while (aClass != null) {
                for (MethodInfo method : aClass.methods()) {
                    Methods.MethodKey methodDescriptor = new Methods.MethodKey(method);
                    if (method.isSynthetic() || Methods.isOverriden(methodDescriptor, methods)) continue;
                    methods.add(methodDescriptor);
                    Collection<AnnotationInstance> methodAnnotations = this.annotationStore.getAnnotations((AnnotationTarget)method);
                    if (methodAnnotations.isEmpty()) continue;
                    if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                        for (AnnotationInstance i : methodAnnotations) {
                            if (!realStereotypes.contains(i.name())) continue;
                            throw new DefinitionException("Method " + method + " of class " + beanClass + " is not a producer method, but is annotated with a stereotype: " + i.name().toString());
                        }
                    }
                    if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                        syncObserverMethods.computeIfAbsent(method, ignored -> new HashSet()).add(beanClass);
                        if (Modifier.isAbstract(beanClass.flags())) continue;
                        beanClasses.add(beanClass);
                        if (hasBeanDefiningAnnotation) continue;
                        LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                        continue;
                    }
                    if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                    asyncObserverMethods.computeIfAbsent(method, ignored -> new HashSet()).add(beanClass);
                    if (Modifier.isAbstract(beanClass.flags())) continue;
                    beanClasses.add(beanClass);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                }
                DotName dotName = aClass.superName();
                aClass = dotName != null && !dotName.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), dotName) : null;
            }
            for (FieldInfo field : beanClass.fields()) {
                if (this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES) && !this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.VETOED_PRODUCER)) {
                    if (this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.INJECT)) {
                        throw new DefinitionException("Injected field cannot be annotated with @Produces: " + field);
                    }
                    producerFields.add(field);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Producer field found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                    beanClasses.add(beanClass);
                    continue;
                }
                for (AnnotationInstance i : this.annotationStore.getAnnotations((AnnotationTarget)field)) {
                    if (!realStereotypes.contains(i.name())) continue;
                    throw new DefinitionException("Field " + field + " of class " + beanClass + " is not a producer field, but is annotated with a stereotype: " + i.name().toString());
                }
            }
        }
        ArrayList<BeanInfo> beans = new ArrayList<BeanInfo>();
        HashMap<ClassInfo, BeanInfo> beanClassToBean = new HashMap<ClassInfo, BeanInfo>();
        for (ClassInfo beanClass : beanClasses) {
            void var17_29;
            BeanInfo classBean = Beans.createClassBean(beanClass, this, this.injectionPointTransformer);
            if (classBean == null) continue;
            beans.add(classBean);
            beanClassToBean.put(beanClass, classBean);
            injectionPoints.addAll(classBean.getAllInjectionPoints());
            if (!classBean.getScope().isNormal() || !this.strictCompatibility) continue;
            ClassInfo classInfo = beanClass;
            while (var17_29 != null) {
                for (FieldInfo field : var17_29.fields()) {
                    if (!Modifier.isPublic(field.flags()) || Modifier.isStatic(field.flags())) continue;
                    throw new DefinitionException("Non-static public field " + field + " present on normal scoped bean " + beanClass);
                }
                DotName superClass = var17_29.superName();
                ClassInfo classInfo2 = superClass != null && !superClass.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(this.getBeanArchiveIndex(), superClass) : null;
            }
        }
        ArrayList<DisposerInfo> disposers = new ArrayList<DisposerInfo>();
        for (MethodInfo disposerMethod : disposerMethods) {
            BeanInfo beanInfo = (BeanInfo)beanClassToBean.get(disposerMethod.declaringClass());
            if (beanInfo == null) continue;
            Injection injection = Injection.forDisposer(disposerMethod, beanInfo.getImplClazz(), this, this.injectionPointTransformer, beanInfo);
            injection.init(beanInfo);
            disposers.add(new DisposerInfo(beanInfo, disposerMethod, injection));
            injectionPoints.addAll(injection.injectionPoints);
        }
        HashSet unusedDisposers = new HashSet(disposers);
        for (MethodInfo methodInfo : producerMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(methodInfo.declaringClass());
            if (declaringBean == null) continue;
            beanTypes = Types.getProducerMethodTypeClosure(methodInfo, this);
            disposer = this.findDisposer(beanTypes, declaringBean, (AnnotationTarget)methodInfo, disposers);
            unusedDisposers.remove(disposer);
            BeanInfo producerMethodBean = Beans.createProducerMethod(beanTypes, methodInfo, declaringBean, this, disposer, this.injectionPointTransformer);
            if (producerMethodBean == null) continue;
            beans.add(producerMethodBean);
            injectionPoints.addAll(producerMethodBean.getAllInjectionPoints());
        }
        for (FieldInfo fieldInfo : producerFields) {
            declaringBean = (BeanInfo)beanClassToBean.get(fieldInfo.declaringClass());
            if (declaringBean == null) continue;
            beanTypes = Types.getProducerFieldTypeClosure(fieldInfo, this);
            disposer = this.findDisposer(beanTypes, declaringBean, (AnnotationTarget)fieldInfo, disposers);
            unusedDisposers.remove(disposer);
            BeanInfo producerFieldBean = Beans.createProducerField(fieldInfo, declaringBean, this, disposer);
            if (producerFieldBean == null) continue;
            beans.add(producerFieldBean);
        }
        for (DisposerInfo disposerInfo : unusedDisposers) {
            Type disposedParamType = disposerInfo.getDisposedParameterType();
            boolean matchingProducerBeanExists = false;
            block15: for (BeanInfo bean : beans) {
                if (!bean.isProducerMethod() && !bean.isProducerField() || !bean.getDeclaringBean().equals(disposerInfo.getDeclaringBean())) continue;
                for (Type beanType : bean.getTypes()) {
                    if (!this.beanResolver.matches(disposedParamType, beanType)) continue;
                    matchingProducerBeanExists = true;
                    break block15;
                }
            }
            if (matchingProducerBeanExists) continue;
            throw new DefinitionException("No producer method or field declared by the bean class that is assignable to the disposed parameter of a disposer method: " + disposerInfo.getDisposerMethod());
        }
        for (Map.Entry entry : syncObserverMethods.entrySet()) {
            this.registerObserverMethods((Collection)entry.getValue(), observers, injectionPoints, beanClassToBean, (MethodInfo)entry.getKey(), false, this.observerTransformers, jtaCapabilities);
        }
        for (Map.Entry entry : asyncObserverMethods.entrySet()) {
            this.registerObserverMethods((Collection)entry.getValue(), observers, injectionPoints, beanClassToBean, (MethodInfo)entry.getKey(), true, this.observerTransformers, jtaCapabilities);
        }
        if (LOGGER.isTraceEnabled()) {
            for (BeanInfo beanInfo : beans) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)beanInfo);
            }
        }
        return beans;
    }

    private boolean isVetoed(ClassInfo beanClass) {
        if (this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.VETOED)) {
            return true;
        }
        String packageName = beanClass.name().packagePrefix();
        ClassInfo packageClass = this.beanArchiveImmutableIndex.getClassByName(DotName.createSimple((String)(packageName + ".package-info")));
        return packageClass != null && this.annotationStore.hasAnnotation((AnnotationTarget)packageClass, DotNames.VETOED);
    }

    private boolean isExcluded(ClassInfo beanClass) {
        if (!this.excludeTypes.isEmpty()) {
            for (Predicate<ClassInfo> exclude : this.excludeTypes) {
                if (!exclude.test(beanClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerObserverMethods(Collection<ClassInfo> beanClasses, List<ObserverInfo> observers, List<InjectionPointInfo> injectionPoints, Map<ClassInfo, BeanInfo> beanClassToBean, MethodInfo observerMethod, boolean async, List<ObserverTransformer> observerTransformers, boolean jtaCapabilities) {
        for (ClassInfo beanClass : beanClasses) {
            BeanInfo declaringBean = beanClassToBean.get(beanClass);
            if (declaringBean == null) continue;
            Injection injection = Injection.forObserver(observerMethod, declaringBean.getImplClazz(), this, this.injectionPointTransformer);
            injection.init(declaringBean);
            ObserverInfo observer = ObserverInfo.create(declaringBean, observerMethod, injection, async, observerTransformers, this.buildContext, jtaCapabilities);
            if (observer == null) continue;
            observers.add(observer);
            injectionPoints.addAll(injection.injectionPoints);
        }
    }

    private DisposerInfo findDisposer(Set<Type> beanTypes, BeanInfo declaringBean, AnnotationTarget producer, List<DisposerInfo> disposers) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : Annotations.getAnnotations(producer.kind(), this.getAnnotations(producer))) {
            qualifiers.addAll(this.extractQualifiers(annotation));
        }
        Beans.addImplicitQualifiers(qualifiers);
        ArrayList<DisposerInfo> found = new ArrayList<DisposerInfo>();
        block1: for (DisposerInfo disposer : disposers) {
            if (!disposer.getDeclaringBean().equals(declaringBean)) continue;
            boolean hasQualifier = true;
            for (AnnotationInstance disposerQualifier : disposer.getDisposedParameterQualifiers()) {
                if (Beans.hasQualifier(declaringBean.getDeployment(), disposerQualifier, qualifiers)) continue;
                hasQualifier = false;
            }
            if (!hasQualifier) continue;
            Type disposedParamType = disposer.getDisposedParameterType();
            for (Type beanType : beanTypes) {
                if (!this.beanResolver.matches(disposedParamType, beanType)) continue;
                found.add(disposer);
                continue block1;
            }
        }
        if (found.size() > 1) {
            throw new DefinitionException("Multiple disposer methods found for " + producer);
        }
        return found.isEmpty() ? null : (DisposerInfo)found.get(0);
    }

    public static Set<DotName> initBeanDefiningAnnotations(Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, Set<DotName> stereotypes) {
        HashSet<DotName> beanDefiningAnnotations = new HashSet<DotName>();
        for (BuiltinScope scope : BuiltinScope.values()) {
            beanDefiningAnnotations.add(scope.getInfo().getDotName());
        }
        if (additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation additional : additionalBeanDefiningAnnotations) {
                beanDefiningAnnotations.add(additional.getAnnotation());
            }
        }
        beanDefiningAnnotations.addAll(stereotypes);
        return beanDefiningAnnotations;
    }

    private BeanRegistrar.RegistrationContext registerSyntheticBeans(List<BeanRegistrar> beanRegistrars, BuildExtension.BuildContext buildContext) {
        BeanRegistrationContextImpl context = new BeanRegistrationContextImpl(buildContext, this);
        for (BeanRegistrar registrar : beanRegistrars) {
            registrar.register(context);
        }
        if (this.buildCompatibleExtensions != null) {
            this.buildCompatibleExtensions.runSynthesis(this.beanArchiveComputingIndex);
            this.buildCompatibleExtensions.registerSyntheticBeans(context);
        }
        this.injectionPoints.addAll(context.syntheticInjectionPoints);
        return context;
    }

    ObserverRegistrar.RegistrationContext registerSyntheticObservers(List<ObserverRegistrar> observerRegistrars) {
        ObserverRegistrationContextImpl context = new ObserverRegistrationContextImpl(this.buildContext, this);
        for (ObserverRegistrar registrar : observerRegistrars) {
            context.extension = registrar;
            registrar.register(context);
            context.extension = null;
        }
        if (this.buildCompatibleExtensions != null) {
            this.buildCompatibleExtensions.registerSyntheticObservers(context);
            this.buildCompatibleExtensions.runRegistrationAgain(this.beanArchiveComputingIndex, this.beans, this.observers);
        }
        return context;
    }

    private void addSyntheticBean(BeanInfo bean) {
        for (BeanInfo b : this.beans) {
            if (!b.getIdentifier().equals(bean.getIdentifier())) continue;
            throw new IllegalStateException("A synthetic bean with identifier " + bean.getIdentifier() + " is already registered: " + b);
        }
        this.beans.add(bean);
    }

    private void addSyntheticObserver(ObserverConfigurator configurator) {
        this.observers.add(ObserverInfo.create(configurator.id, this, configurator.beanClass, null, null, null, null, configurator.observedType, configurator.observedQualifiers, Reception.ALWAYS, configurator.transactionPhase, configurator.isAsync, configurator.priority, this.observerTransformers, this.buildContext, this.jtaCapabilities, configurator.notifyConsumer, configurator.params));
    }

    static void processErrors(List<Throwable> errors) {
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                Throwable error = errors.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                if (error instanceof DefinitionException) {
                    throw (DefinitionException)error;
                }
                throw new DeploymentException(errors.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + errors.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable error : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable error : errors) {
                deploymentException.addSuppressed(error);
            }
            throw deploymentException;
        }
    }

    private List<InterceptorInfo> findInterceptors(List<InjectionPointInfo> injectionPoints) {
        HashMap<DotName, ClassInfo> interceptorClasses = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance annotation : this.beanArchiveImmutableIndex.getAnnotations(DotNames.INTERCEPTOR)) {
            if (!AnnotationTarget.Kind.CLASS.equals((Object)annotation.target().kind())) continue;
            interceptorClasses.put(annotation.target().asClass().name(), annotation.target().asClass());
        }
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        for (ClassInfo interceptorClass : interceptorClasses.values()) {
            if (this.isVetoed(interceptorClass) || this.isExcluded(interceptorClass)) continue;
            interceptors.add(Interceptors.createInterceptor(interceptorClass, this, this.injectionPointTransformer));
        }
        if (LOGGER.isTraceEnabled()) {
            for (InterceptorInfo interceptor : interceptors) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)interceptor);
            }
        }
        for (InterceptorInfo interceptor : interceptors) {
            injectionPoints.addAll(interceptor.getAllInjectionPoints());
        }
        return interceptors;
    }

    private List<DecoratorInfo> findDecorators(List<InjectionPointInfo> injectionPoints) {
        HashMap<DotName, ClassInfo> decoratorClasses = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance annotation : this.beanArchiveImmutableIndex.getAnnotations(DotNames.DECORATOR)) {
            if (!AnnotationTarget.Kind.CLASS.equals((Object)annotation.target().kind())) continue;
            decoratorClasses.put(annotation.target().asClass().name(), annotation.target().asClass());
        }
        ArrayList<DecoratorInfo> decorators = new ArrayList<DecoratorInfo>();
        for (ClassInfo decoratorClass : decoratorClasses.values()) {
            if (this.isVetoed(decoratorClass) || this.isExcluded(decoratorClass)) continue;
            decorators.add(Decorators.createDecorator(decoratorClass, this, this.injectionPointTransformer));
        }
        if (LOGGER.isTraceEnabled()) {
            for (DecoratorInfo decorator : decorators) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)decorator);
            }
        }
        for (DecoratorInfo decorator : decorators) {
            injectionPoints.addAll(decorator.getAllInjectionPoints());
        }
        return decorators;
    }

    private void validateInterceptorsAndDecorators(List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        for (InterceptorInfo interceptor : this.interceptors) {
            interceptor.validateInterceptorDecorator(errors, bytecodeTransformerConsumer);
        }
        for (DecoratorInfo decorator : this.decorators) {
            decorator.validateInterceptorDecorator(errors, bytecodeTransformerConsumer);
        }
    }

    private void validateBeans(List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        HashSet<String> namespaces = new HashSet<String>();
        HashMap<String, ArrayList<BeanInfo>> namedBeans = new HashMap<String, ArrayList<BeanInfo>>();
        HashSet<DotName> classesReceivingNoArgsCtor = new HashSet<DotName>();
        for (BeanInfo beanInfo : this.beans) {
            if (beanInfo.getName() != null) {
                ArrayList<BeanInfo> named = (ArrayList<BeanInfo>)namedBeans.get(beanInfo.getName());
                if (named == null) {
                    named = new ArrayList<BeanInfo>();
                    namedBeans.put(beanInfo.getName(), named);
                }
                named.add(beanInfo);
                this.findNamespaces(beanInfo, namespaces);
            }
            beanInfo.validate(errors, bytecodeTransformerConsumer, classesReceivingNoArgsCtor);
        }
        if (!namedBeans.isEmpty()) {
            for (Map.Entry entry : namedBeans.entrySet()) {
                String name = (String)entry.getKey();
                if (((List)entry.getValue()).size() > 1 && Beans.resolveAmbiguity((Collection)entry.getValue()) == null) {
                    errors.add((Throwable)new DeploymentException("Unresolvable ambiguous bean name detected: " + name + "\nBeans:\n" + ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining("\n"))));
                }
                if (!this.strictCompatibility || !namespaces.contains(name)) continue;
                errors.add((Throwable)new DeploymentException("Bean name '" + name + "' is identical to a bean name prefix used elsewhere"));
            }
        }
    }

    private void findNamespaces(BeanInfo bean, Set<String> namespaces) {
        String[] parts;
        if (!this.strictCompatibility) {
            return;
        }
        if (bean.getName() != null && (parts = bean.getName().split("\\.")).length > 1) {
            for (int i = 0; i < parts.length - 1; ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    if (j > 0) {
                        builder.append('.');
                    }
                    builder.append(parts[j]);
                }
                namespaces.add(builder.toString());
            }
        }
    }

    public Set<String> getInterceptorNonbindingMembers(DotName name) {
        return this.interceptorNonbindingMembers.getOrDefault(name, Collections.emptySet());
    }

    public Set<String> getQualifierNonbindingMembers(DotName name) {
        return this.qualifierNonbindingMembers.getOrDefault(name, Collections.emptySet());
    }

    public String toString() {
        return "BeanDeployment [name=" + this.name + "]";
    }

    static abstract class RegistrationContextImpl
    implements BuildExtension.BuildContext {
        protected final BuildExtension.BuildContext parent;
        protected final BeanDeployment beanDeployment;
        protected BuildExtension extension;

        RegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            this.parent = buildContext;
            this.beanDeployment = beanDeployment;
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return this.parent.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return this.parent.put(key, value);
        }

        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }
    }

    private static class ObserverRegistrationContextImpl
    extends RegistrationContextImpl
    implements ObserverRegistrar.RegistrationContext {
        ObserverRegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            super(buildContext, beanDeployment);
        }

        @Override
        public ObserverConfigurator configure() {
            ObserverConfigurator configurator = new ObserverConfigurator(x$0 -> this.beanDeployment.addSyntheticObserver((ObserverConfigurator)x$0));
            if (this.extension != null) {
                configurator.beanClass(DotName.createSimple((String)this.extension.getClass().getName()));
            }
            return configurator;
        }

        @Override
        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }
    }

    private static class BeanRegistrationContextImpl
    extends RegistrationContextImpl
    implements BeanRegistrar.RegistrationContext,
    Consumer<BeanInfo> {
        final List<InjectionPointInfo> syntheticInjectionPoints = new ArrayList<InjectionPointInfo>();

        BeanRegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            super(buildContext, beanDeployment);
        }

        @Override
        public <T> BeanConfigurator<T> configure(DotName beanClassName) {
            return new BeanConfigurator(beanClassName, this.beanDeployment, this);
        }

        @Override
        public void accept(BeanInfo bean) {
            this.beanDeployment.addSyntheticBean(bean);
            this.syntheticInjectionPoints.addAll(bean.getAllInjectionPoints());
        }
    }

    private static class ValidationContextImpl
    implements BeanDeploymentValidator.ValidationContext {
        private final BuildExtension.BuildContext buildContext;
        private final List<Throwable> errors;

        public ValidationContextImpl(BuildExtension.BuildContext buildContext) {
            this.buildContext = buildContext;
            this.errors = new ArrayList<Throwable>();
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return this.buildContext.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return this.buildContext.put(key, value);
        }

        @Override
        public void addDeploymentProblem(Throwable problem) {
            this.errors.add(problem);
        }

        @Override
        public List<Throwable> getDeploymentProblems() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }

        @Override
        public BeanStream removedBeans() {
            return new BeanStream(this.get(BuildExtension.Key.REMOVED_BEANS));
        }
    }
}

