/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ScopeInfo;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

final class Interceptors {
    static final Logger LOGGER = Logger.getLogger(Interceptors.class);

    private Interceptors() {
    }

    static InterceptorInfo createInterceptor(ClassInfo interceptorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        HashSet<AnnotationInstance> bindings = new HashSet<AnnotationInstance>();
        Integer priority = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)interceptorClass)) {
            ScopeInfo scope;
            bindings.addAll(beanDeployment.extractInterceptorBindings(annotation));
            Set<AnnotationInstance> transitiveInterceptorBindings = beanDeployment.getTransitiveInterceptorBindings(annotation.name());
            if (transitiveInterceptorBindings != null) {
                bindings.addAll(transitiveInterceptorBindings);
            }
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if (priority == null && annotation.name().equals((Object)DotNames.ARC_PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if ((scope = beanDeployment.getScope(annotation.name())) == null || BuiltinScope.DEPENDENT.is(scope)) continue;
            throw new DefinitionException("Interceptor declares scope other than @Dependent: " + interceptorClass);
        }
        if (bindings.isEmpty()) {
            throw new DefinitionException("Interceptor has no bindings: " + interceptorClass);
        }
        if (priority == null) {
            LOGGER.info((Object)("The interceptor " + interceptorClass + " does not declare any @Priority. It will be assigned a default priority value of 0."));
            priority = 0;
        }
        Interceptors.checkInterceptorFieldsAndMethods(interceptorClass, beanDeployment);
        return new InterceptorInfo((AnnotationTarget)interceptorClass, beanDeployment, bindings.size() == 1 ? Collections.singleton((AnnotationInstance)bindings.iterator().next()) : Collections.unmodifiableSet(bindings), Injection.forBean((AnnotationTarget)interceptorClass, null, beanDeployment, transformer), priority);
    }

    private static void checkInterceptorFieldsAndMethods(ClassInfo interceptorClass, BeanDeployment beanDeployment) {
        ClassInfo aClass = interceptorClass;
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                    throw new DefinitionException("Interceptor declares a producer method: " + interceptorClass);
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("Interceptor declares a disposer method: " + interceptorClass);
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                    throw new DefinitionException("Interceptor declares an observer method: " + interceptorClass);
                }
                if (!beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Interceptor declares an async observer method: " + interceptorClass);
            }
            for (FieldInfo field : aClass.fields()) {
                if (!beanDeployment.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("Interceptor declares a producer field: " + interceptorClass);
            }
            DotName superClass = aClass.superName();
            aClass = superClass != null && !superClass.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClass) : null;
        }
    }
}

