/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.FieldConfig;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.MetaAnnotations;
import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.build.compatible.spi.ObserverInfo;
import jakarta.enterprise.inject.build.compatible.spi.ScannedClasses;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.inject.build.compatible.spi.Types;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

class ExtensionInvoker {
    private final Map<String, Class<?>> extensionClasses = new ConcurrentHashMap();
    private final Map<Class<?>, Object> extensionClassInstances = new ConcurrentHashMap();
    private final IndexView extensionsIndex;

    ExtensionInvoker(List<BuildCompatibleExtension> extensions) {
        Indexer extensionsIndexer = new Indexer();
        ArrayList<BuildCompatibleExtension> allExtensions = new ArrayList<BuildCompatibleExtension>(extensions);
        for (BuildCompatibleExtension extension : ServiceLoader.load(BuildCompatibleExtension.class)) {
            allExtensions.add(extension);
        }
        for (BuildCompatibleExtension extension : allExtensions) {
            Class<?> extensionClass = extension.getClass();
            this.extensionClasses.put(extensionClass.getName(), extensionClass);
            this.extensionClassInstances.put(extensionClass, extension);
            try {
                InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(extensionClass.getName().replace('.', '/') + ".class");
                try {
                    extensionsIndexer.index(stream);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.extensionsIndex = extensionsIndexer.complete();
    }

    List<ExtensionMethod> findExtensionMethods(DotName annotation) {
        return this.extensionsIndex.getAllKnownImplementors(DotNames.BUILD_COMPATIBLE_EXTENSION).stream().flatMap(it -> it.annotationsMap().getOrDefault(annotation, Collections.emptyList()).stream().filter(ann -> ann.target().kind() == AnnotationTarget.Kind.METHOD).map(ann -> ann.target().asMethod())).sorted((m1, m2) -> {
            int p2;
            if (m1 == m2) {
                return 0;
            }
            int p1 = this.getExtensionMethodPriority((org.jboss.jandex.MethodInfo)m1);
            return p1 < (p2 = this.getExtensionMethodPriority((org.jboss.jandex.MethodInfo)m2)) ? -1 : 1;
        }).map(ExtensionMethod::new).collect(Collectors.toUnmodifiableList());
    }

    private int getExtensionMethodPriority(org.jboss.jandex.MethodInfo method) {
        AnnotationInstance priority = method.declaredAnnotation(DotNames.PRIORITY);
        if (priority != null) {
            return priority.value().asInt();
        }
        return 2500;
    }

    void callExtensionMethod(ExtensionMethod method, List<Object> arguments) throws ReflectiveOperationException {
        Class[] parameterTypes = new Class[arguments.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object argument = arguments.get(i);
            Class<?> argumentClass = argument.getClass();
            if (ClassInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ClassInfo.class;
                continue;
            }
            if (MethodInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MethodInfo.class;
                continue;
            }
            if (FieldInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = FieldInfo.class;
                continue;
            }
            if (ScannedClasses.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ScannedClasses.class;
                continue;
            }
            if (MetaAnnotations.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MetaAnnotations.class;
                continue;
            }
            if (ClassConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ClassConfig.class;
                continue;
            }
            if (MethodConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MethodConfig.class;
                continue;
            }
            if (FieldConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = FieldConfig.class;
                continue;
            }
            if (BeanInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = BeanInfo.class;
                continue;
            }
            if (ObserverInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ObserverInfo.class;
                continue;
            }
            if (SyntheticComponents.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = SyntheticComponents.class;
                continue;
            }
            if (Messages.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = Messages.class;
                continue;
            }
            if (Types.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = Types.class;
                continue;
            }
            throw new IllegalArgumentException("Unexpected extension method argument: " + argument);
        }
        Class<?> extensionClass = this.extensionClasses.get(method.extensionClass.name().toString());
        Object extensionClassInstance = this.extensionClassInstances.get(extensionClass);
        Method methodReflective = extensionClass.getDeclaredMethod(method.name(), parameterTypes);
        methodReflective.setAccessible(true);
        methodReflective.invoke(extensionClassInstance, arguments.toArray());
    }

    void invalidate() {
        this.extensionClasses.clear();
        this.extensionClassInstances.clear();
    }
}

