/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Types;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class Decorators {
    static final Logger LOGGER = Logger.getLogger(Decorators.class);

    private Decorators() {
    }

    static DecoratorInfo createDecorator(ClassInfo decoratorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        LinkedList<InjectionPointInfo> delegateInjectionPoints = new LinkedList<InjectionPointInfo>();
        List<Injection> injections = Injection.forBean((AnnotationTarget)decoratorClass, null, beanDeployment, transformer, Injection.BeanType.DECORATOR);
        for (Injection injection : injections) {
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                if (!injectionPoint.isDelegate()) continue;
                delegateInjectionPoints.add(injectionPoint);
            }
        }
        if (delegateInjectionPoints.isEmpty()) {
            throw new DefinitionException("The decorator " + decoratorClass + " has no @Delegate injection point");
        }
        if (delegateInjectionPoints.size() > 1) {
            throw new DefinitionException("The decorator " + decoratorClass + " has multiple @Delegate injection points: " + delegateInjectionPoints);
        }
        InjectionPointInfo delegateInjectionPoint = (InjectionPointInfo)delegateInjectionPoints.get(0);
        Integer priority = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)decoratorClass)) {
            Object scopeAnnotation;
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if (priority == null && annotation.name().equals((Object)DotNames.ARC_PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if ((scopeAnnotation = beanDeployment.getScope(annotation.name())) == null || BuiltinScope.DEPENDENT.is((ScopeInfo)scopeAnnotation)) continue;
            throw new DefinitionException("A decorator must be @Dependent but " + decoratorClass + " declares " + ((ScopeInfo)scopeAnnotation).getDotName());
        }
        Set<Type> types = Types.getClassBeanTypeClosure(decoratorClass, beanDeployment);
        HashSet<Type> decoratedTypes = new HashSet<Type>();
        for (Type type : types) {
            ClassInfo clazz;
            if (type.name().equals((Object)DotNames.SERIALIZABLE) || !Modifier.isInterface((clazz = beanDeployment.getBeanArchiveIndex().getClassByName(type.name())).flags())) continue;
            decoratedTypes.add(type);
        }
        if (decoratedTypes.isEmpty()) {
            throw new DefinitionException("The decorator " + decoratorClass + " has no decorated type");
        }
        Set<Type> delegateTypes = Types.getDelegateTypeClosure(delegateInjectionPoint, beanDeployment);
        for (Type decoratedType : decoratedTypes) {
            if (!delegateTypes.contains(decoratedType)) {
                throw new DefinitionException("The delegate type " + delegateInjectionPoint.getRequiredType() + " does not implement the decorated type: " + decoratedType);
            }
            for (BuiltinBean bean : BuiltinBean.values()) {
                if (bean.equals((Object)BuiltinBean.RESOURCE) || !bean.hasRawTypeDotName(decoratedType.name())) continue;
                throw new UnsupportedOperationException("Decorating built-in bean types is not supported! Decorator " + decoratorClass + " is attempting to decorate " + decoratedType.name());
            }
        }
        if (priority == null) {
            if (beanDeployment.strictCompatibility) {
                return null;
            }
            LOGGER.info((Object)("The decorator " + decoratorClass + " does not declare any @Priority. It will be assigned a default priority value of 0."));
            priority = 0;
        }
        if (Modifier.isAbstract(decoratorClass.flags())) {
            ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
            for (MethodInfo method : decoratorClass.methods()) {
                if (!Modifier.isAbstract(method.flags())) continue;
                arrayList.add(method);
            }
            if (!arrayList.isEmpty()) {
                throw new DefinitionException("An abstract decorator " + decoratorClass + " declares abstract methods: " + arrayList);
            }
        }
        Decorators.checkDecoratorFieldsAndMethods(decoratorClass, beanDeployment);
        return new DecoratorInfo((AnnotationTarget)decoratorClass, beanDeployment, delegateInjectionPoint, decoratedTypes, injections, priority);
    }

    private static void checkDecoratorFieldsAndMethods(ClassInfo decoratorClass, BeanDeployment beanDeployment) {
        ClassInfo aClass = decoratorClass;
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                    throw new DefinitionException("Decorator declares a producer method: " + decoratorClass);
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("Decorator declares a disposer method: " + decoratorClass);
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                    throw new DefinitionException("Decorator declares an observer method: " + decoratorClass);
                }
                if (!beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Decorator declares an async observer method: " + decoratorClass);
            }
            for (FieldInfo field : aClass.fields()) {
                if (!beanDeployment.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("Decorator declares a producer field: " + decoratorClass);
            }
            DotName superClass = aClass.superName();
            aClass = superClass != null && !superClass.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClass) : null;
        }
    }
}

