/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class UnusedBeans {
    private static final Logger LOG = Logger.getLogger(UnusedBeans.class);

    private UnusedBeans() {
    }

    /*
     * WARNING - void declaration
     */
    static Set<BeanInfo> findRemovableBeans(BeanResolver beanResolver, Collection<BeanInfo> beans, Iterable<InjectionPointInfo> injectionPoints, Set<BeanInfo> declaresObserver, List<Predicate<BeanInfo>> allUnusedExclusions) {
        HashSet<BeanInfo> removableBeans = new HashSet<BeanInfo>();
        HashSet<BeanInfo> unusedProducers = new HashSet<BeanInfo>();
        HashSet<BeanInfo> unusedButDeclaresProducer = new HashSet<BeanInfo>();
        List producers = beans.stream().filter(b -> b.isProducerMethod() || b.isProducerField()).collect(Collectors.toList());
        HashSet<BeanInfo> injected = new HashSet<BeanInfo>();
        ArrayList<InjectionPointInfo> instanceInjectionPoints = new ArrayList<InjectionPointInfo>();
        ArrayList<InjectionPointInfo.TypeAndQualifiers> listAllInjectionPoints = new ArrayList<InjectionPointInfo.TypeAndQualifiers>();
        for (InjectionPointInfo injectionPointInfo : injectionPoints) {
            void var16_18;
            if (injectionPointInfo.isProgrammaticLookup()) {
                instanceInjectionPoints.add(injectionPointInfo);
                continue;
            }
            if (injectionPointInfo.isDelegate()) continue;
            BeanInfo resolved = injectionPointInfo.getResolvedBean();
            if (resolved != null) {
                injected.add(resolved);
                continue;
            }
            Object builtin = BuiltinBean.resolve(injectionPointInfo);
            if (builtin != BuiltinBean.LIST) continue;
            Type type = (Type)injectionPointInfo.getType().asParameterizedType().arguments().get(0);
            if (type.name().equals((Object)DotNames.INSTANCE_HANDLE)) {
                Type type2 = (Type)type.asParameterizedType().arguments().get(0);
            }
            HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>(injectionPointInfo.getRequiredQualifiers());
            Iterator it = qualifiers.iterator();
            while (it.hasNext()) {
                AnnotationInstance qualifier = (AnnotationInstance)it.next();
                if (!qualifier.name().equals((Object)DotNames.ALL)) continue;
                it.remove();
            }
            listAllInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers((Type)var16_18, qualifiers));
        }
        Set declaresProducer = producers.stream().map(BeanInfo::getDeclaringBean).collect(Collectors.toSet());
        block2: for (BeanInfo bean : beans) {
            if (bean.getName() != null) {
                LOG.debugf("Unremovable - named: %s", (Object)bean);
                continue;
            }
            if (!bean.isRemovable()) {
                LOG.debugf("Unremovable - unremovable synthetic: %s", (Object)bean);
                continue;
            }
            for (Predicate predicate : allUnusedExclusions) {
                if (!predicate.test(bean)) continue;
                LOG.debugf("Unremovable - excluded by %s: %s", (Object)predicate.toString(), (Object)bean);
                continue block2;
            }
            if (injected.contains(bean)) {
                LOG.debugf("Unremovable - injected: %s", (Object)bean);
                continue;
            }
            if (declaresObserver.contains(bean)) {
                LOG.debugf("Unremovable - declares observer: %s", (Object)bean);
                continue;
            }
            for (InjectionPointInfo injectionPointInfo : instanceInjectionPoints) {
                if (!Beans.hasQualifiers(bean, injectionPointInfo.getRequiredQualifiers()) || !beanResolver.matchesType(bean, (Type)injectionPointInfo.getType().asParameterizedType().arguments().get(0))) continue;
                LOG.debugf("Unremovable - programmatic lookup: %s", (Object)bean);
                continue block2;
            }
            for (InjectionPointInfo.TypeAndQualifiers typeAndQualifiers : listAllInjectionPoints) {
                if (!Beans.hasQualifiers(bean, typeAndQualifiers.qualifiers) || !beanResolver.matchesType(bean, typeAndQualifiers.type)) continue;
                LOG.debugf("Unremovable - @All List: %s", (Object)bean);
                continue block2;
            }
            if (declaresProducer.contains(bean)) {
                unusedButDeclaresProducer.add(bean);
                continue;
            }
            if (bean.isProducerField() || bean.isProducerMethod()) {
                unusedProducers.add(bean);
            }
            removableBeans.add(bean);
        }
        if (!unusedProducers.isEmpty()) {
            Map<BeanInfo, List<BeanInfo>> map = producers.stream().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
            for (Map.Entry<BeanInfo, List<BeanInfo>> entry : map.entrySet()) {
                BeanInfo beanInfo = entry.getKey();
                if (unusedButDeclaresProducer.contains(beanInfo) && unusedProducers.containsAll((Collection)entry.getValue())) {
                    removableBeans.add(beanInfo);
                    continue;
                }
                LOG.debugf("Unremovable - declares producer: %s", (Object)beanInfo);
            }
        }
        return removableBeans;
    }
}

