/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InterceptionProxy;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InterceptionProxyInfo;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Types;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public final class BeanConfigurator<T>
extends BeanConfiguratorBase<BeanConfigurator<T>, T> {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final Consumer<BeanInfo> beanConsumer;
    private final BeanDeployment beanDeployment;

    BeanConfigurator(DotName implClassName, BeanDeployment beanDeployment, Consumer<BeanInfo> beanConsumer) {
        super(implClassName);
        this.beanDeployment = beanDeployment;
        this.beanConsumer = beanConsumer;
    }

    public void done() {
        if (this.consumed.compareAndSet(false, true)) {
            InterceptionProxyInfo interceptionProxy;
            Integer priority;
            Boolean alternative;
            String name;
            ClassInfo implClass = IndexClassLookupUtils.getClassByName(this.beanDeployment.getBeanArchiveIndex(), Objects.requireNonNull(this.implClazz));
            if (implClass == null) {
                throw new IllegalStateException("Unable to find the bean class in the index: " + this.implClazz);
            }
            ScopeInfo scope = this.scope;
            if (scope == null) {
                scope = Beans.initStereotypeScope(this.stereotypes, (AnnotationTarget)implClass, this.beanDeployment);
            }
            if (scope == null) {
                scope = BuiltinScope.DEPENDENT.getInfo();
            }
            if ((name = this.name) == null) {
                name = Beans.initStereotypeName(this.stereotypes, (AnnotationTarget)implClass, this.beanDeployment);
            }
            if ((alternative = this.alternative) == null) {
                alternative = Beans.initStereotypeAlternative(this.stereotypes, this.beanDeployment);
            }
            if ((priority = this.priority) == null) {
                priority = Beans.initStereotypeAlternativePriority(this.stereotypes, (AnnotationTarget)implClass, this.beanDeployment);
            }
            if ((interceptionProxy = this.interceptionProxy) != null) {
                Object providerType = this.providerType;
                if (providerType == null) {
                    providerType = BeanInfo.initProviderType(null, implClass);
                }
                interceptionProxy = new InterceptionProxyInfo(providerType.name(), interceptionProxy.getBindingsSourceClass());
                this.addInjectionPoint((Type)ParameterizedType.builder(InterceptionProxy.class).addArgument((Type)providerType).build(), new AnnotationInstance[0]);
            }
            for (Type jandexType : this.registeredTypeClosures) {
                this.types.addAll(Types.getTypeClosureFromJandexType(jandexType, this.beanDeployment).unrestrictedTypes());
            }
            this.types.removeAll(this.typesToRemove);
            BeanInfo.Builder builder = new BeanInfo.Builder().implClazz(implClass).identifier(this.identifier).providerType(this.providerType).beanDeployment(this.beanDeployment).scope(scope).types(this.types).qualifiers(this.qualifiers).alternative(alternative).priority(priority).stereotypes(this.stereotypes).name(name).creator(this.creatorConsumer).destroyer(this.destroyerConsumer).params(this.params).defaultBean(this.defaultBean).removable(this.removable).forceApplicationClass(this.forceApplicationClass).targetPackageName(this.targetPackageName).startupPriority(this.startupPriority).interceptionProxy(interceptionProxy).checkActive(this.checkActiveConsumer);
            if (!this.injectionPoints.isEmpty()) {
                builder.injections(Collections.singletonList(Injection.forSyntheticBean(this.injectionPoints)));
            }
            this.beanConsumer.accept(builder.build());
        }
    }
}

