/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.WithCaching;
import io.quarkus.arc.impl.BeanManagerProvider;
import io.quarkus.arc.impl.BeanMetadataProvider;
import io.quarkus.arc.impl.EventProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceProvider;
import io.quarkus.arc.impl.InterceptedDecoratedBeanMetadataProvider;
import io.quarkus.arc.impl.ListProvider;
import io.quarkus.arc.impl.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptionProxyGenerator;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public enum BuiltinBean {
    INSTANCE(BuiltinBean::generateInstanceBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInstance, DotNames.INSTANCE, DotNames.PROVIDER, DotNames.INJECTABLE_INSTANCE),
    INJECTION_POINT(BuiltinBean::generateInjectionPointBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInjectionPoint, DotNames.INJECTION_POINT),
    BEAN(BuiltinBean::generateBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && ip.hasDefaultedQualifier(), BuiltinBean::validateBean, DotNames.BEAN),
    INTERCEPTED_BEAN(BuiltinBean::generateInterceptedDecoratedBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.INTERCEPTED), BuiltinBean::validateInterceptedBean, DotNames.BEAN),
    DECORATED_BEAN(BuiltinBean::generateInterceptedDecoratedBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.DECORATED), BuiltinBean::validateDecoratedBean, DotNames.BEAN),
    BEAN_MANAGER(BuiltinBean::generateBeanManagerBytecode, DotNames.BEAN_MANAGER, DotNames.BEAN_CONTAINER),
    EVENT(BuiltinBean::generateEventBytecode, DotNames.EVENT),
    RESOURCE(BuiltinBean::generateResourceBytecode, (ip, names) -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE, DotNames.OBJECT),
    EVENT_METADATA(Generator.NOOP, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateEventMetadata, DotNames.EVENT_METADATA),
    LIST(BuiltinBean::generateListBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.LIST) && ip.getRequiredQualifier(DotNames.ALL) != null, BuiltinBean::validateList, DotNames.LIST),
    INTERCEPTION_PROXY(BuiltinBean::generateInterceptionProxyBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInterceptionProxy, DotNames.INTERCEPTION_PROXY);

    private final DotName[] rawTypeDotNames;
    private final Generator generator;
    private final BiPredicate<InjectionPointInfo, DotName[]> matcher;
    private final Validator validator;

    private BuiltinBean(Generator generator, DotName ... rawTypeDotNames) {
        this(generator, BuiltinBean::cdiAndRawTypeMatches, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, DotName ... rawTypeDotNames) {
        this(generator, matcher, Validator.NOOP, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, Validator validator, DotName ... rawTypeDotNames) {
        this.rawTypeDotNames = rawTypeDotNames;
        this.generator = generator;
        this.matcher = matcher;
        this.validator = validator;
    }

    public boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint, this.rawTypeDotNames);
    }

    DotName[] getRawTypeDotNames() {
        return this.rawTypeDotNames;
    }

    boolean hasRawTypeDotName(DotName name) {
        for (DotName rawTypeDotName : this.rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    Generator getGenerator() {
        return this.generator;
    }

    Validator getValidator() {
        return this.validator;
    }

    public static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    public static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean cdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName ... rawTypeDotNames) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        for (DotName rawTypeDotName : rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)injectionPoint.getType().name())) continue;
            return true;
        }
        return false;
    }

    private static void generateInstanceBytecode(GeneratorContext ctx) {
        ResultHandle beanHandle;
        ResultHandle javaMemberHandle;
        ResultHandle annotationsHandle;
        ResultHandle parameterizedType;
        ResultHandle qualifiers;
        block6: {
            block5: {
                qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
                parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
                Set<BeanInfo> beans = ctx.beanDeployment.beanResolver.resolveBeans(ctx.injectionPoint.getRequiredType(), ctx.injectionPoint.getRequiredQualifiers());
                boolean collectMetadata = beans.stream().anyMatch(b -> BuiltinScope.DEPENDENT.isDeclaredBy((BeanInfo)b) && b.requiresInjectionPointMetadata());
                if (!collectMetadata) break block5;
                annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
                javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
                switch (ctx.targetInfo.kind()) {
                    case OBSERVER: {
                        beanHandle = ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
                        break block6;
                    }
                    case BEAN: {
                        beanHandle = ctx.constructor.getThis();
                        break block6;
                    }
                    case INVOKER: {
                        beanHandle = BuiltinBean.loadInvokerTargetBean(ctx.targetInfo.asInvoker(), (BytecodeCreator)ctx.constructor);
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
                    }
                }
            }
            annotationsHandle = BuiltinBean.collectWithCaching(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint);
            javaMemberHandle = ctx.constructor.loadNull();
            beanHandle = ctx.constructor.loadNull();
        }
        ResultHandle instanceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE}), new ResultHandle[]{parameterizedType, qualifiers, beanHandle, annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient())});
        ResultHandle instanceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{instanceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), instanceProviderSupplier);
    }

    private static void generateEventBytecode(GeneratorContext ctx) {
        ResultHandle qualifiers = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance qualifierAnnotation : ctx.injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)ctx.constructor)});
                    continue;
                }
                ClassInfo qualifierClass = ctx.beanDeployment.getQualifier(qualifierAnnotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{ctx.annotationLiterals.create((BytecodeCreator)ctx.constructor, qualifierClass, qualifierAnnotation)});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
        ResultHandle annotations = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
        ResultHandle javaMember = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        ResultHandle injectionPoint = ctx.constructor.newInstance(MethodDescriptors.INJECTION_POINT_IMPL_CONSTRUCTOR, new ResultHandle[]{parameterizedType, parameterizedType, qualifiers, switch (ctx.targetInfo.kind()) {
            case InjectionTargetInfo.TargetKind.OBSERVER -> ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
            case InjectionTargetInfo.TargetKind.BEAN -> ctx.constructor.getThis();
            case InjectionTargetInfo.TargetKind.INVOKER -> BuiltinBean.loadInvokerTargetBean(ctx.targetInfo.asInvoker(), (BytecodeCreator)ctx.constructor);
            default -> throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
        }, annotations, javaMember, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient())});
        ResultHandle eventProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(EventProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectionPoint.class}), new ResultHandle[]{parameterizedType, qualifiers, injectionPoint});
        ResultHandle eventProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{eventProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), eventProviderSupplier);
    }

    private static void generateInjectionPointBytecode(GeneratorContext ctx) {
        ResultHandle injectionPointProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InjectionPointProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{injectionPointProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }

    private static void generateBeanBytecode(GeneratorContext ctx) {
        ResultHandle beanProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanMetadataProvider.class, (Class[])new Class[]{String.class}), new ResultHandle[]{ctx.constructor.load(ctx.targetInfo.asBean().getIdentifier())});
        ResultHandle beanProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), beanProviderSupplier);
    }

    private static void generateInterceptedDecoratedBeanBytecode(GeneratorContext ctx) {
        ResultHandle interceptedBeanMetadataProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InterceptedDecoratedBeanMetadataProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle interceptedBeanMetadataProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{interceptedBeanMetadataProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), interceptedBeanMetadataProviderSupplier);
    }

    private static void generateBeanManagerBytecode(GeneratorContext ctx) {
        ResultHandle beanManagerProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanManagerProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanManagerProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }

    private static void generateResourceBytecode(GeneratorContext ctx) {
        ResultHandle annotations = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance annotation : ctx.injectionPoint.getRequiredQualifiers()) {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getBeanArchiveIndex(), annotation.name());
                if (annotationClass == null) continue;
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotations, new ResultHandle[]{ctx.annotationLiterals.create((BytecodeCreator)ctx.constructor, annotationClass, annotation)});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
        ResultHandle resourceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, annotations});
        ResultHandle resourceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{resourceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), resourceProviderSupplier);
    }

    private static void generateListBytecode(GeneratorContext ctx) {
        ResultHandle beanHandle;
        ResultHandle javaMemberHandle;
        ResultHandle annotationsHandle;
        ResultHandle qualifiers;
        ResultHandle usesInstanceHandle;
        ResultHandle requiredType;
        ResultHandle injectionPointType;
        block11: {
            block10: {
                InjectionPointInfo injectionPoint = ctx.injectionPoint;
                if (injectionPoint.isField()) {
                    ctx.reflectionRegistration.registerField(injectionPoint.getAnnotationTarget().asField());
                } else if (injectionPoint.isParam()) {
                    ctx.reflectionRegistration.registerMethod(injectionPoint.getAnnotationTarget().asMethodParameter().method());
                }
                MethodCreator mc = ctx.constructor;
                injectionPointType = Types.getTypeHandle((BytecodeCreator)mc, ctx.injectionPoint.getType());
                org.jboss.jandex.Type type = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0);
                if (type.name().equals((Object)DotNames.INSTANCE_HANDLE)) {
                    requiredType = Types.getTypeHandle((BytecodeCreator)mc, (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0));
                    usesInstanceHandle = mc.load(true);
                } else {
                    requiredType = Types.getTypeHandle((BytecodeCreator)mc, type);
                    usesInstanceHandle = mc.load(false);
                }
                qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
                Set<BeanInfo> beans = ctx.beanDeployment.beanResolver.resolveBeans(type.name().equals((Object)DotNames.INSTANCE_HANDLE) ? (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0) : type, ctx.injectionPoint.getRequiredQualifiers().stream().filter(a -> !a.name().equals((Object)DotNames.ALL)).collect(Collectors.toSet()));
                boolean collectMetadata = beans.stream().anyMatch(b -> BuiltinScope.DEPENDENT.isDeclaredBy((BeanInfo)b) && b.requiresInjectionPointMetadata());
                if (!collectMetadata) break block10;
                annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
                javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
                switch (ctx.targetInfo.kind()) {
                    case OBSERVER: {
                        beanHandle = ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
                        break block11;
                    }
                    case BEAN: {
                        beanHandle = ctx.constructor.getThis();
                        break block11;
                    }
                    case INVOKER: {
                        beanHandle = BuiltinBean.loadInvokerTargetBean(ctx.targetInfo.asInvoker(), (BytecodeCreator)ctx.constructor);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
                    }
                }
            }
            annotationsHandle = ctx.constructor.loadNull();
            javaMemberHandle = ctx.constructor.loadNull();
            beanHandle = ctx.constructor.loadNull();
        }
        ResultHandle listProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ListProvider.class, (Class[])new Class[]{Type.class, Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{requiredType, injectionPointType, qualifiers, beanHandle, annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient()), usesInstanceHandle});
        ResultHandle listProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{listProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), listProviderSupplier);
    }

    private static void generateInterceptionProxyBytecode(GeneratorContext ctx) {
        BeanInfo bean = ctx.targetInfo.asBean();
        String name = InterceptionProxyGenerator.interceptionProxyProviderName(bean);
        ResultHandle supplier = ctx.constructor.newInstance(MethodDescriptor.ofConstructor((String)name, (String[])new String[0]), new ResultHandle[0]);
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), supplier);
    }

    private static ResultHandle loadInvokerTargetBean(InvokerInfo invoker, BytecodeCreator bytecode) {
        ResultHandle arc = bytecode.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
        return bytecode.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_BEAN, arc, new ResultHandle[]{bytecode.load(invoker.targetBean.getIdentifier())});
    }

    private static void validateInstance(ValidatorContext ctx) {
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("An injection point of raw type jakarta.enterprise.inject.Instance is defined: " + ctx.injectionPoint.getTargetInfo()));
        } else if (ctx.injectionPoint.getRequiredType().kind() == Type.Kind.WILDCARD_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for jakarta.enterprise.inject.Instance: " + ctx.injectionPoint.getTargetInfo()));
        } else if (ctx.injectionPoint.getRequiredType().kind() == Type.Kind.TYPE_VARIABLE) {
            ctx.errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for jakarta.enterprise.inject.Instance: " + ctx.injectionPoint.getTargetInfo()));
        }
    }

    private static void validateList(ValidatorContext ctx) {
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("An injection point of raw type is defined: " + ctx.injectionPoint.getTargetInfo()));
        } else {
            org.jboss.jandex.Type typeParam = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0);
            if (typeParam.kind() == Type.Kind.WILDCARD_TYPE) {
                if (ctx.injectionPoint.isSynthetic()) {
                    ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for a synthetic @All List<?> injection point used in: " + ctx.injectionTarget.toString()));
                    return;
                }
                ClassInfo declaringClass = ctx.injectionPoint.isField() ? ctx.injectionPoint.getAnnotationTarget().asField().declaringClass() : ctx.injectionPoint.getAnnotationTarget().asMethodParameter().method().declaringClass();
                if (KotlinUtils.isKotlinClass(declaringClass)) {
                    ctx.errors.accept((Throwable)new DefinitionException("kotlin.collections.List cannot be used together with the @All qualifier, please use MutableList or java.util.List instead: " + ctx.injectionPoint.getTargetInfo()));
                } else {
                    ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for: " + ctx.injectionPoint.getTargetInfo()));
                }
            } else if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
                ctx.errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for: " + ctx.injectionPoint.getTargetInfo()));
            }
        }
    }

    private static void validateInjectionPoint(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !BuiltinScope.DEPENDENT.is(ctx.injectionTarget.asBean().getScope())) {
            String msg = ctx.injectionPoint.getTargetInfo();
            if (msg.isBlank()) {
                msg = ctx.injectionTarget.toString();
            }
            ctx.errors.accept((Throwable)new DefinitionException("Only @Dependent beans can access metadata about an injection point: " + msg));
        }
    }

    private static void validateBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN) {
            ctx.errors.accept((Throwable)new DefinitionException("Only beans can access bean metadata"));
        }
    }

    private static void validateInterceptedBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isInterceptor()) {
            ctx.errors.accept((Throwable)new DefinitionException("Only interceptors can access intercepted bean metadata"));
        }
    }

    private static void validateDecoratedBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isDecorator()) {
            ctx.errors.accept((Throwable)new DefinitionException("Only decorators can access decorated bean metadata"));
        }
    }

    private static void validateEventMetadata(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.OBSERVER) {
            ctx.errors.accept((Throwable)new DefinitionException("EventMetadata can be only injected into an observer method: " + ctx.injectionPoint.getTargetInfo()));
        }
    }

    private static void validateInterceptionProxy(ValidatorContext ctx) {
        ClassInfo clazz;
        org.jboss.jandex.Type interceptionProxyType;
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isProducerMethod() && !ctx.injectionTarget.asBean().isSynthetic() || ctx.injectionTarget.asBean().getInterceptionProxy() == null) {
            ctx.errors.accept((Throwable)new DefinitionException("InterceptionProxy can only be injected into a producer method or a synthetic bean"));
        }
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("InterceptionProxy must be a parameterized type"));
        }
        if ((interceptionProxyType = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0)).kind() != Type.Kind.CLASS && interceptionProxyType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("Type argument of InterceptionProxy may only be a class or parameterized type"));
        }
        if (!ctx.injectionTarget.asBean().getProviderType().equals((Object)interceptionProxyType)) {
            String msg = ctx.injectionTarget.asBean().isProducerMethod() ? "Type argument of InterceptionProxy must be equal to the return type of the producer method" : "Type argument of InterceptionProxy must be equal to the bean provider type";
            ctx.errors.accept((Throwable)new DefinitionException(msg));
        }
        if ((clazz = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getBeanArchiveIndex(), interceptionProxyType.name())) != null) {
            if (clazz.isRecord()) {
                ctx.errors.accept((Throwable)new DefinitionException("Cannot build InterceptionProxy for a record"));
            }
            if (clazz.isSealed()) {
                ctx.errors.accept((Throwable)new DefinitionException("Cannot build InterceptionProxy for a sealed type"));
            }
        }
    }

    private static ResultHandle collectWithCaching(BeanDeployment beanDeployment, MethodCreator bytecode, InjectionPointInfo injectionPoint) {
        AnnotationTarget annotationTarget = injectionPoint.isParam() ? injectionPoint.getAnnotationTarget().asMethodParameter().method() : injectionPoint.getAnnotationTarget();
        ResultHandle annotationsHandle = !injectionPoint.isSynthetic() && Annotations.contains(beanDeployment.getAnnotations(annotationTarget), DotNames.WITH_CACHING) ? Gizmo.setOperations((BytecodeCreator)bytecode).of(bytecode.readStaticField(FieldDescriptor.of(WithCaching.Literal.class, (String)"INSTANCE", WithCaching.Literal.class))) : Gizmo.setOperations((BytecodeCreator)bytecode).of();
        return annotationsHandle;
    }

    @FunctionalInterface
    static interface Generator {
        public static final Generator NOOP = ctx -> {};

        public void generate(GeneratorContext var1);
    }

    @FunctionalInterface
    static interface Validator {
        public static final Validator NOOP = ctx -> {};

        public void validate(ValidatorContext var1);
    }

    public record GeneratorContext(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals, InjectionTargetInfo targetInfo, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate) {
    }

    public record ValidatorContext(BeanDeployment beanDeployment, InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
    }
}

