/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

class AnnotationSet {
    private final Map<DotName, AnnotationInstance> data;
    private final Map<DotName, Integer> inheritanceDistances;

    private static Map<DotName, Integer> zeroDistances(Collection<AnnotationInstance> jandexAnnotations) {
        ConcurrentHashMap<DotName, Integer> distances = new ConcurrentHashMap<DotName, Integer>();
        for (AnnotationInstance jandexAnnotation : jandexAnnotations) {
            distances.put(jandexAnnotation.name(), 0);
        }
        return distances;
    }

    AnnotationSet(Collection<AnnotationInstance> jandexAnnotations) {
        this(jandexAnnotations, AnnotationSet.zeroDistances(jandexAnnotations));
    }

    AnnotationSet(Collection<AnnotationInstance> jandexAnnotations, Map<DotName, Integer> inheritanceDistances) {
        ConcurrentHashMap<DotName, AnnotationInstance> data = new ConcurrentHashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance jandexAnnotation : jandexAnnotations) {
            data.put(jandexAnnotation.name(), jandexAnnotation);
        }
        this.data = data;
        this.inheritanceDistances = inheritanceDistances;
    }

    boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        DotName name = DotName.createSimple((String)annotationType.getName());
        return this.hasAnnotation(name);
    }

    boolean hasAnnotation(DotName annotationName) {
        return this.data.containsKey(annotationName);
    }

    AnnotationInstance annotation(Class<? extends Annotation> annotationType) {
        DotName name = DotName.createSimple((String)annotationType.getName());
        return this.data.get(name);
    }

    Collection<AnnotationInstance> annotationsWithRepeatable(Class<? extends Annotation> annotationType) {
        DotName containerName;
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        DotName name = DotName.createSimple((String)annotationType.getName());
        DotName dotName = containerName = repeatable != null ? DotName.createSimple((String)repeatable.value().getName()) : DotName.OBJECT_NAME;
        if (this.data.containsKey(name) && this.data.containsKey(containerName)) {
            int containerAnnDistance;
            int annDistance = this.inheritanceDistances.get(name);
            if (annDistance < (containerAnnDistance = this.inheritanceDistances.get(containerName).intValue())) {
                return List.of(this.data.get(name));
            }
            if (annDistance == containerAnnDistance) {
                ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
                result.add(this.data.get(name));
                AnnotationInstance container = this.data.get(containerName);
                AnnotationInstance[] values = container.value().asNestedArray();
                result.addAll(Arrays.asList(values));
                return result;
            }
            AnnotationInstance container = this.data.get(containerName);
            AnnotationInstance[] values = container.value().asNestedArray();
            return List.of(values);
        }
        if (this.data.containsKey(name)) {
            return List.of(this.data.get(name));
        }
        if (this.data.containsKey(containerName)) {
            AnnotationInstance container = this.data.get(containerName);
            AnnotationInstance[] values = container.value().asNestedArray();
            return List.of(values);
        }
        return List.of();
    }

    Collection<AnnotationInstance> annotations() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    void add(AnnotationInstance jandexAnnotation) {
        this.data.put(jandexAnnotation.name(), jandexAnnotation);
        this.inheritanceDistances.put(jandexAnnotation.name(), 0);
    }

    void removeIf(Predicate<AnnotationInstance> predicate) {
        HashSet<DotName> toRemove = new HashSet<DotName>();
        for (AnnotationInstance jandexAnnotation : this.data.values()) {
            if (!predicate.test(jandexAnnotation)) continue;
            toRemove.add(jandexAnnotation.name());
        }
        for (DotName name : toRemove) {
            this.data.remove(name);
            this.inheritanceDistances.remove(name);
        }
    }
}

