/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ApplicationContext;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcCDIProvider;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.BeanManagerImpl;
import io.quarkus.arc.BeanTypeAssignabilityRules;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.ComputingCache;
import io.quarkus.arc.CreationalContextImpl;
import io.quarkus.arc.CurrentInjectionPointProvider;
import io.quarkus.arc.EventImpl;
import io.quarkus.arc.EventTypeAssignabilityRules;
import io.quarkus.arc.HierarchyDiscovery;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.InjectionPointProvider;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.InstanceHandleImpl;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.Qualifiers;
import io.quarkus.arc.RequestContext;
import io.quarkus.arc.ResourceReferenceProvider;
import io.quarkus.arc.SingletonContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

class ArcContainerImpl
implements ArcContainer {
    private static final Logger LOGGER = Logger.getLogger((String)ArcContainerImpl.class.getPackage().getName());
    private final String id = UUID.randomUUID().toString();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final List<InjectableBean<?>> beans = new ArrayList();
    private final List<InjectableInterceptor<?>> interceptors = new ArrayList();
    private final List<InjectableObserverMethod<?>> observers = new ArrayList();
    private final List<InjectableContext> contexts;
    private final ManagedContext requestContext;
    private final InjectableContext applicationContext = new ApplicationContext();
    private final InjectableContext singletonContext = new SingletonContext();
    private final ComputingCache<Resolvable, Set<InjectableBean<?>>> resolved;
    private final ComputingCache<String, InjectableBean<?>> beansById;
    private final ComputingCache<String, Set<InjectableBean<?>>> beansByName;
    private final List<ResourceReferenceProvider> resourceProviders;

    public ArcContainerImpl() {
        this.requestContext = new RequestContext();
        this.contexts = new ArrayList<InjectableContext>();
        this.contexts.add(this.requestContext);
        for (ComponentsProvider componentsProvider : ServiceLoader.load(ComponentsProvider.class)) {
            Components components = componentsProvider.getComponents();
            for (InjectableBean<?> bean : components.getBeans()) {
                if (bean instanceof InjectableInterceptor) {
                    this.interceptors.add((InjectableInterceptor)bean);
                    continue;
                }
                this.beans.add(bean);
            }
            this.observers.addAll(components.getObservers());
            for (InjectableContext context : components.getContexts()) {
                if (ApplicationScoped.class.equals((Object)context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in application context is always active: " + context);
                }
                if (Singleton.class.equals((Object)context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in singleton context is always active: " + context);
                }
                this.contexts.add(context);
            }
        }
        Collections.sort(this.interceptors, (i1, i2) -> Integer.compare(i2.getPriority(), i1.getPriority()));
        this.resolved = new ComputingCache<Resolvable, Set>(this::resolve);
        this.beansById = new ComputingCache<String, InjectableBean>(this::findById);
        this.beansByName = new ComputingCache<String, Set>(this::resolve);
        this.resourceProviders = new ArrayList<ResourceReferenceProvider>();
        for (ResourceReferenceProvider resourceProvider : ServiceLoader.load(ResourceReferenceProvider.class)) {
            this.resourceProviders.add(resourceProvider);
        }
    }

    void init() {
        this.requireRunning();
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(4);
        qualifiers.add((Annotation)Initialized.Literal.APPLICATION);
        qualifiers.add((Annotation)Any.Literal.INSTANCE);
        EventImpl.createNotifier(Object.class, Object.class, qualifiers, this).notify(this.toString());
        CDI.setCDIProvider((CDIProvider)new ArcCDIProvider());
        LOGGER.debugf("ArC DI container initialized [beans=%s, observers=%s]", this.beans.size(), this.observers.size());
    }

    @Override
    public InjectableContext getActiveContext(Class<? extends Annotation> scopeType) {
        this.requireRunning();
        if (ApplicationScoped.class.equals(scopeType)) {
            return this.applicationContext;
        }
        if (Singleton.class.equals(scopeType)) {
            return this.singletonContext;
        }
        ArrayList<InjectableContext> active = new ArrayList<InjectableContext>();
        for (InjectableContext context : this.contexts) {
            if (!scopeType.equals(context.getScope()) || !context.isActive()) continue;
            active.add(context);
        }
        if (active.isEmpty()) {
            return null;
        }
        if (active.size() == 1) {
            return (InjectableContext)active.get(0);
        }
        throw new IllegalArgumentException("More than one context object for the given scope: " + active);
    }

    @Override
    public Set<Class<? extends Annotation>> getScopes() {
        Set<Class<? extends Annotation>> scopes = this.contexts.stream().map(Context::getScope).collect(Collectors.toSet());
        scopes.add(ApplicationScoped.class);
        scopes.add(Singleton.class);
        return scopes;
    }

    @Override
    public <T> InstanceHandle<T> instance(Class<T> type, Annotation ... qualifiers) {
        this.requireRunning();
        return this.instanceHandle(type, qualifiers);
    }

    @Override
    public <T> InstanceHandle<T> instance(TypeLiteral<T> type, Annotation ... qualifiers) {
        this.requireRunning();
        return this.instanceHandle(type.getType(), qualifiers);
    }

    @Override
    public <T> Supplier<InstanceHandle<T>> instanceSupplier(Class<T> type, Annotation ... qualifiers) {
        this.requireRunning();
        final InjectableBean<T> bean = this.getBean(type, qualifiers);
        if (bean == null) {
            return null;
        }
        return new Supplier<InstanceHandle<T>>(){

            @Override
            public InstanceHandle<T> get() {
                return ArcContainerImpl.this.beanInstanceHandle(bean, null);
            }
        };
    }

    @Override
    public <T> InstanceHandle<T> instance(InjectableBean<T> bean) {
        Objects.requireNonNull(bean);
        this.requireRunning();
        return bean != null ? this.beanInstanceHandle(bean, null) : InstanceHandleImpl.unavailable();
    }

    @Override
    public <T> InjectableBean<T> bean(String beanIdentifier) {
        Objects.requireNonNull(beanIdentifier);
        this.requireRunning();
        return this.beansById.getValue(beanIdentifier);
    }

    @Override
    public <T> InstanceHandle<T> instance(String name) {
        Objects.requireNonNull(name);
        this.requireRunning();
        Set<InjectableBean<?>> resolvedBeans = this.beansByName.getValue(name);
        return resolvedBeans.isEmpty() || resolvedBeans.size() > 1 ? InstanceHandleImpl.unavailable() : this.beanInstanceHandle(resolvedBeans.iterator().next(), null);
    }

    @Override
    public ManagedContext requestContext() {
        this.requireRunning();
        return this.requestContext;
    }

    @Override
    public BeanManager beanManager() {
        return BeanManagerImpl.INSTANCE.get();
    }

    public String toString() {
        return "ArcContainerImpl [id=" + this.id + ", running=" + this.running + ", beans=" + this.beans.size() + ", observers=" + this.observers.size() + ", scopes=" + this.getScopes() + "]";
    }

    synchronized void shutdown() {
        if (this.running.get()) {
            CDI cdi = CDI.current();
            if (cdi instanceof ArcCDIProvider.ArcCDI) {
                ArcCDIProvider.ArcCDI arcCdi = (ArcCDIProvider.ArcCDI)cdi;
                arcCdi.destroy();
            }
            HashSet<Annotation> beforeDestroyQualifiers = new HashSet<Annotation>(4);
            beforeDestroyQualifiers.add((Annotation)BeforeDestroyed.Literal.APPLICATION);
            beforeDestroyQualifiers.add((Annotation)Any.Literal.INSTANCE);
            EventImpl.createNotifier(Object.class, Object.class, beforeDestroyQualifiers, this).notify(this.toString());
            this.applicationContext.destroy();
            HashSet<Annotation> destroyQualifiers = new HashSet<Annotation>(4);
            destroyQualifiers.add((Annotation)Destroyed.Literal.APPLICATION);
            destroyQualifiers.add((Annotation)Any.Literal.INSTANCE);
            EventImpl.createNotifier(Object.class, Object.class, destroyQualifiers, this).notify(this.toString());
            this.singletonContext.destroy();
            this.requestContext.terminate();
            this.contexts.clear();
            this.beans.clear();
            this.resolved.clear();
            this.observers.clear();
            this.running.set(false);
            LOGGER.debugf("ArC DI container shut down", new Object[0]);
        }
    }

    InstanceHandle<Object> getResource(Type type, Set<Annotation> annotations) {
        for (ResourceReferenceProvider resourceProvider : this.resourceProviders) {
            InstanceHandle<Object> ret = resourceProvider.get(type, annotations);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private <T> InstanceHandle<T> instanceHandle(Type type, Annotation ... qualifiers) {
        return this.beanInstanceHandle(this.getBean(type, qualifiers), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext) {
        if (bean != null) {
            if (parentContext == null && Dependent.class.equals(bean.getScope())) {
                parentContext = new CreationalContextImpl();
            }
            CreationalContextImpl creationalContext = parentContext != null ? parentContext.child() : new CreationalContextImpl();
            InjectionPoint prev = InjectionPointProvider.CURRENT.get();
            InjectionPointProvider.CURRENT.set(CurrentInjectionPointProvider.EMPTY);
            try {
                InstanceHandleImpl<Object> instanceHandleImpl = new InstanceHandleImpl<Object>(bean, bean.get(creationalContext), creationalContext, parentContext);
                return instanceHandleImpl;
            }
            finally {
                if (prev != null) {
                    InjectionPointProvider.CURRENT.set(prev);
                } else {
                    InjectionPointProvider.CURRENT.remove();
                }
            }
        }
        return InstanceHandleImpl.unavailable();
    }

    private <T> InjectableBean<T> getBean(Type requiredType, Annotation ... qualifiers) {
        Set<InjectableBean<?>> resolvedBeans;
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        return (resolvedBeans = this.resolved.getValue(new Resolvable(requiredType, qualifiers))).isEmpty() || resolvedBeans.size() > 1 ? null : resolvedBeans.iterator().next();
    }

    Set<Bean<?>> getBeans(Type requiredType, Annotation ... qualifiers) {
        return new HashSet(this.getMatchingBeans(new Resolvable(requiredType, qualifiers)));
    }

    Set<Bean<?>> getBeans(String name) {
        return new HashSet(this.getMatchingBeans(name));
    }

    private Set<InjectableBean<?>> resolve(Resolvable resolvable) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(resolvable));
    }

    private Set<InjectableBean<?>> resolve(String name) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(name));
    }

    private InjectableBean<?> findById(String identifier) {
        for (InjectableBean<?> bean : this.beans) {
            if (!bean.getIdentifier().equals(identifier)) continue;
            return bean;
        }
        return null;
    }

    static <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() == 1) {
            return beans.iterator().next();
        }
        if (beans.stream().allMatch(b -> b instanceof InjectableBean)) {
            ArrayList matching = new ArrayList();
            for (Bean<X> bean : beans) {
                matching.add((InjectableBean)bean);
            }
            Set<InjectableBean<?>> resolved = ArcContainerImpl.resolve(matching);
            if (resolved.size() != 1) {
                throw new AmbiguousResolutionException(resolved.toString());
            }
            return resolved.iterator().next();
        }
        HashSet<Bean<X>> resolved = new HashSet<Bean<X>>(beans);
        Iterator iterator = resolved.iterator();
        while (iterator.hasNext()) {
            if (((Bean)iterator.next()).isAlternative()) continue;
            iterator.remove();
        }
        if (resolved.size() != 1) {
            throw new AmbiguousResolutionException(((Object)resolved).toString());
        }
        return (Bean)resolved.iterator().next();
    }

    private static Set<InjectableBean<?>> resolve(List<InjectableBean<?>> matching) {
        if (matching.isEmpty()) {
            return Collections.emptySet();
        }
        if (matching.size() == 1) {
            return Collections.singleton(matching.get(0));
        }
        ArrayList resolved = new ArrayList(matching);
        Iterator iterator = resolved.iterator();
        while (iterator.hasNext()) {
            InjectableBean bean = (InjectableBean)iterator.next();
            if (bean.getAlternativePriority() != null || bean.getDeclaringBean() != null && bean.getDeclaringBean().getAlternativePriority() != null) continue;
            iterator.remove();
        }
        if (resolved.size() == 1) {
            return Collections.singleton(resolved.get(0));
        }
        if (resolved.size() > 1) {
            resolved.sort(ArcContainerImpl::compareAlternativeBeans);
            Integer highest = ArcContainerImpl.getAlternativePriority((InjectableBean)resolved.get(0));
            Iterator iterator2 = resolved.iterator();
            while (iterator2.hasNext()) {
                if (highest.equals(ArcContainerImpl.getAlternativePriority((InjectableBean)iterator2.next()))) continue;
                iterator2.remove();
            }
            if (resolved.size() == 1) {
                return Collections.singleton(resolved.get(0));
            }
        }
        return new HashSet(matching);
    }

    private static Integer getAlternativePriority(InjectableBean<?> bean) {
        return bean.getDeclaringBean() != null ? bean.getDeclaringBean().getAlternativePriority() : bean.getAlternativePriority();
    }

    List<InjectableBean<?>> getMatchingBeans(Resolvable resolvable) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.beans) {
            if (!this.matches(bean, resolvable.requiredType, resolvable.qualifiers)) continue;
            matching.add(bean);
        }
        return matching;
    }

    List<InjectableBean<?>> getMatchingBeans(String name) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.beans) {
            if (!name.equals(bean.getName())) continue;
            matching.add(bean);
        }
        return matching;
    }

    private static int compareAlternativeBeans(InjectableBean<?> bean1, InjectableBean<?> bean2) {
        Integer priority2 = bean2.getDeclaringBean() != null ? bean2.getDeclaringBean().getAlternativePriority() : bean2.getAlternativePriority();
        Integer priority1 = bean1.getDeclaringBean() != null ? bean1.getDeclaringBean().getAlternativePriority() : bean1.getAlternativePriority();
        return priority2.compareTo(priority1);
    }

    <T> List<InjectableObserverMethod<? super T>> resolveObservers(Type eventType, Set<Annotation> eventQualifiers) {
        if (this.observers.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Type> eventTypes = new HierarchyDiscovery(eventType).getTypeClosure();
        ArrayList<InjectableObserverMethod<T>> resolvedObservers = new ArrayList<InjectableObserverMethod<T>>();
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!EventTypeAssignabilityRules.matches(observer.getObservedType(), eventTypes) || !observer.getObservedQualifiers().isEmpty() && !Qualifiers.isSubset(observer.getObservedQualifiers(), eventQualifiers)) continue;
            resolvedObservers.add(observer);
        }
        Collections.sort(resolvedObservers, InjectableObserverMethod::compare);
        return resolvedObservers;
    }

    List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (this.interceptors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList interceptors = new ArrayList();
        for (InjectableInterceptor<?> interceptor : this.interceptors) {
            if (!interceptor.intercepts(type) || !this.hasAllInterceptionBindings(interceptor, interceptorBindings)) continue;
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private boolean hasAllInterceptionBindings(InjectableInterceptor<?> interceptor, Annotation[] interceptorBindings) {
        for (Annotation binding : interceptorBindings) {
            if (Qualifiers.hasQualifier(interceptor.getInterceptorBindings(), binding)) continue;
            return false;
        }
        return true;
    }

    Set<InjectableBean<?>> getResolvedBeans(Type requiredType, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        return this.resolved.getValue(new Resolvable(requiredType, qualifiers));
    }

    private boolean matches(InjectableBean<?> bean, Type requiredType, Annotation ... qualifiers) {
        if (!BeanTypeAssignabilityRules.matches(requiredType, bean.getTypes())) {
            return false;
        }
        return Qualifiers.hasQualifiers(bean, qualifiers);
    }

    static ArcContainerImpl unwrap(ArcContainer container) {
        if (container instanceof ArcContainerImpl) {
            return (ArcContainerImpl)container;
        }
        throw new IllegalArgumentException();
    }

    static ArcContainerImpl instance() {
        return ArcContainerImpl.unwrap(Arc.container());
    }

    private void requireRunning() {
        if (!this.running.get()) {
            throw new IllegalStateException("Container not running: " + this.toString());
        }
    }

    private static final class Resolvable {
        final Type requiredType;
        final Annotation[] qualifiers;

        Resolvable(Type requiredType, Annotation[] qualifiers) {
            this.requiredType = requiredType;
            this.qualifiers = qualifiers;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.qualifiers);
            result = 31 * result + (this.requiredType == null ? 0 : this.requiredType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Resolvable)) {
                return false;
            }
            Resolvable other = (Resolvable)obj;
            if (this.requiredType == null ? other.requiredType != null : !this.requiredType.equals(other.requiredType)) {
                return false;
            }
            return Arrays.equals(this.qualifiers, other.qualifiers);
        }
    }
}

