/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.InstanceHandleImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;

public class CreationalContextImpl<T>
implements CreationalContext<T> {
    private final CreationalContextImpl<?> parent;
    private final List<InstanceHandle<?>> dependentInstances;

    public CreationalContextImpl() {
        this(null);
    }

    public CreationalContextImpl(CreationalContextImpl<?> parent) {
        this.parent = parent;
        this.dependentInstances = Collections.synchronizedList(new ArrayList());
    }

    public <I> void addDependentInstance(InjectableBean<I> bean, I instance, CreationalContext<I> ctx) {
        this.addDependentInstance(new InstanceHandleImpl<I>(bean, instance, ctx));
    }

    public <I> void addDependentInstance(InstanceHandle<I> instanceHandle) {
        this.dependentInstances.add(instanceHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyDependentInstance(Object dependentInstance) {
        List<InstanceHandle<?>> list = this.dependentInstances;
        synchronized (list) {
            Iterator<InstanceHandle<?>> iterator = this.dependentInstances.iterator();
            while (iterator.hasNext()) {
                InstanceHandle<?> instanceHandle = iterator.next();
                if (instanceHandle.get() != dependentInstance) continue;
                instanceHandle.destroy();
                iterator.remove();
                break;
            }
        }
    }

    public void push(T incompleteInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List<InstanceHandle<?>> list = this.dependentInstances;
        synchronized (list) {
            for (InstanceHandle<?> instance : this.dependentInstances) {
                instance.destroy();
            }
        }
    }

    public CreationalContextImpl<?> getParent() {
        return this.parent;
    }

    public <C> CreationalContextImpl<C> child() {
        return new CreationalContextImpl<T>(this);
    }

    public static <T> CreationalContextImpl<T> unwrap(CreationalContext<T> ctx) {
        if (ctx instanceof CreationalContextImpl) {
            return (CreationalContextImpl)ctx;
        }
        throw new IllegalArgumentException("Failed to unwrap CreationalContextImpl: " + ctx);
    }

    public static <C> CreationalContextImpl<C> child(CreationalContext<?> creationalContext) {
        return CreationalContextImpl.unwrap(creationalContext).child();
    }

    public static <I> void addDependencyToParent(InjectableBean<I> bean, I instance, CreationalContext<I> ctx) {
        CreationalContextImpl<?> parent = CreationalContextImpl.unwrap(ctx).getParent();
        if (parent != null) {
            parent.addDependentInstance(bean, instance, ctx);
        }
    }
}

