/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.BeanTypeAssignabilityRules;
import io.quarkus.arc.CovariantTypes;
import io.quarkus.arc.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

final class EventTypeAssignabilityRules {
    private EventTypeAssignabilityRules() {
    }

    static boolean matches(Type observedType, Set<? extends Type> eventTypes) {
        for (Type type : eventTypes) {
            if (!EventTypeAssignabilityRules.matches(observedType, type)) continue;
            return true;
        }
        return false;
    }

    static boolean matches(Type observedType, Type eventType) {
        return EventTypeAssignabilityRules.matchesNoBoxing(Types.boxedType(observedType), Types.boxedType(eventType));
    }

    static boolean matchesNoBoxing(Type observedType, Type eventType) {
        if (observedType instanceof TypeVariable) {
            return EventTypeAssignabilityRules.matches((TypeVariable)observedType, eventType);
        }
        if (observedType instanceof Class && eventType instanceof ParameterizedType) {
            return observedType.equals(Types.getRawType(eventType));
        }
        if (observedType instanceof ParameterizedType && eventType instanceof ParameterizedType) {
            return EventTypeAssignabilityRules.matches((ParameterizedType)observedType, (ParameterizedType)eventType);
        }
        if (observedType instanceof Class && eventType instanceof Class) {
            return observedType.equals(eventType);
        }
        return false;
    }

    private static boolean matches(TypeVariable<?> observedType, Type eventType) {
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(observedType)) {
            if (CovariantTypes.isAssignableFrom(bound, eventType)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(ParameterizedType observedType, ParameterizedType eventType) {
        if (!observedType.getRawType().equals(eventType.getRawType())) {
            return false;
        }
        if (observedType.getActualTypeArguments().length != eventType.getActualTypeArguments().length) {
            throw new IllegalArgumentException("Invalid argument combination " + observedType + "; " + eventType);
        }
        for (int i = 0; i < observedType.getActualTypeArguments().length; ++i) {
            if (EventTypeAssignabilityRules.parametersMatch(observedType.getActualTypeArguments()[i], eventType.getActualTypeArguments()[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersMatch(Type observedParameter, Type eventParameter) {
        if (Types.isActualType(observedParameter) && Types.isActualType(eventParameter)) {
            return EventTypeAssignabilityRules.matches(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType && eventParameter instanceof WildcardType) {
            return CovariantTypes.isAssignableFrom(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType) {
            return EventTypeAssignabilityRules.parametersMatch((WildcardType)observedParameter, eventParameter);
        }
        if (observedParameter instanceof TypeVariable) {
            return EventTypeAssignabilityRules.parametersMatch((TypeVariable)observedParameter, eventParameter);
        }
        return false;
    }

    private static boolean parametersMatch(TypeVariable<?> observedParameter, Type eventParameter) {
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(observedParameter)) {
            if (CovariantTypes.isAssignableFrom(bound, eventParameter)) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersMatch(WildcardType observedParameter, Type eventParameter) {
        return BeanTypeAssignabilityRules.lowerBoundsOfWildcardMatch(eventParameter, observedParameter) && BeanTypeAssignabilityRules.upperBoundsOfWildcardMatch(observedParameter, eventParameter);
    }
}

