/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.GenericArrayTypeImpl;
import io.quarkus.arc.ParameterizedTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

final class Types {
    private Types() {
    }

    static Type boxedType(Type type) {
        if (type instanceof Class) {
            return Types.boxedClass((Class)type);
        }
        return type;
    }

    static Class<?> boxedClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        throw new IllegalArgumentException();
    }

    static boolean isActualType(Type type) {
        return type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType;
    }

    static boolean isArray(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    static boolean isArrayOfUnboundedTypeVariablesOrObjects(Type[] types) {
        for (Type type : types) {
            Type[] bounds;
            if (Object.class.equals((Object)type) || type instanceof TypeVariable && ((bounds = ((TypeVariable)type).getBounds()) == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) continue;
            return false;
        }
        return true;
    }

    static <T> Class<T> getRawType(Type type) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            Type[] bounds = variable.getBounds();
            return Types.getBound(bounds);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return Types.getBound(wildcard.getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = Types.getRawType((genericArrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    static Type getCanonicalType(Class<?> clazz) {
        Type resolvedComponentType;
        Class<?> componentType;
        if (clazz.isArray() && (componentType = clazz.getComponentType()) != (resolvedComponentType = Types.getCanonicalType(componentType))) {
            return new GenericArrayTypeImpl(resolvedComponentType);
        }
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            return new ParameterizedTypeImpl((Type)clazz, actualTypeParameters, (Type)clazz.getDeclaringClass());
        }
        return clazz;
    }

    public static Type getCanonicalType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Types.getCanonicalType(clazz);
        }
        return type;
    }

    static boolean isRawGenericType(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return Types.isRawGenericType(componentType);
        }
        return clazz.getTypeParameters().length > 0;
    }

    static boolean containsTypeVariable(Type type) {
        if ((type = Types.getCanonicalType(type)) instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsTypeVariable(t)) continue;
                return true;
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.containsTypeVariable(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Types.getRawType(bounds[0]);
    }
}

