/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import java.io.IOException;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHWorkflowRun;

public class WorkflowContext {
    public final String repository;
    public final String type;
    public final String logContext;
    public final String htmlUrl;

    public WorkflowContext(GHIssue issue) {
        this.repository = issue.getRepository().getFullName();
        this.type = "Issue";
        this.logContext = this.type + " #" + issue.getNumber();
        this.htmlUrl = issue.getHtmlUrl().toString();
    }

    public WorkflowContext(GHPullRequest pullRequest) {
        this.repository = pullRequest.getRepository().getFullName();
        this.type = "Pull request";
        this.logContext = this.type + " #" + pullRequest.getNumber();
        this.htmlUrl = pullRequest.getHtmlUrl().toString();
    }

    public WorkflowContext(GHWorkflowRun workflowRun) {
        String htmlUrl;
        this.repository = workflowRun.getRepository().getFullName();
        this.type = "GitHub Actions";
        this.logContext = this.type + " #" + workflowRun.getId();
        try {
            htmlUrl = workflowRun.getHtmlUrl().toString();
        }
        catch (IOException e) {
            htmlUrl = null;
        }
        this.htmlUrl = htmlUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getType() {
        return this.type;
    }

    public String getLogContext() {
        return this.logContext;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }
}

