/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.WorkflowConstants;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

class BuildReports {
    private static final Path MAVEN_SUREFIRE_REPORTS_PATH = Path.of("target", "surefire-reports");
    private static final Path MAVEN_FAILSAFE_REPORTS_PATH = Path.of("target", "failsafe-reports");
    private static final Path GRADLE_REPORTS_PATH = Path.of("build", "test-results", "test");
    private final Path jobDirectory;
    private final Path buildReportPath;
    private final Set<TestResultsPath> testResultsPaths;

    private BuildReports(Path jobDirectory, Path buildReportPath, Set<TestResultsPath> testResultsPaths) {
        this.jobDirectory = jobDirectory;
        this.buildReportPath = buildReportPath;
        this.testResultsPaths = Collections.unmodifiableSet(testResultsPaths);
    }

    public Path getJobDirectory() {
        return this.jobDirectory;
    }

    public Path getBuildReportPath() {
        return this.buildReportPath;
    }

    public Set<TestResultsPath> getTestResultsPaths() {
        return this.testResultsPaths;
    }

    static class GradleTestResultsPath
    implements TestResultsPath {
        private final Path path;

        GradleTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().getParent().toString();
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }
    }

    static class FailsafeTestResultsPath
    implements TestResultsPath {
        private final Path path;

        FailsafeTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().toString();
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }
    }

    private static class SurefireTestResultsPath
    implements TestResultsPath {
        private final Path path;

        SurefireTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().toString();
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }
    }

    static class Builder {
        private final Path jobDirectory;
        private Path buildReportPath;
        private Set<TestResultsPath> testResultsPaths = new TreeSet<TestResultsPath>();

        Builder(Path jobDirectory) {
            this.jobDirectory = jobDirectory;
        }

        void addPath(Path path) {
            if (path.endsWith(WorkflowConstants.BUILD_REPORT_PATH)) {
                this.buildReportPath = path;
            } else if (path.endsWith(MAVEN_SUREFIRE_REPORTS_PATH)) {
                this.testResultsPaths.add(new SurefireTestResultsPath(path));
            } else if (path.endsWith(MAVEN_FAILSAFE_REPORTS_PATH)) {
                this.testResultsPaths.add(new FailsafeTestResultsPath(path));
            } else if (path.endsWith(GRADLE_REPORTS_PATH)) {
                this.testResultsPaths.add(new GradleTestResultsPath(path));
            }
        }

        BuildReports build() {
            return new BuildReports(this.jobDirectory, this.buildReportPath, this.testResultsPaths);
        }
    }

    static interface TestResultsPath
    extends Comparable<TestResultsPath> {
        public Path getPath();

        public String getModuleName(Path var1);
    }
}

