/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReporter;
import io.quarkus.bot.buildreporter.githubactions.BuildReporterConfig;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.WorkflowRunAnalyzer;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;

@Singleton
public class BuildReporterActionHandler {
    private static final Logger LOG = Logger.getLogger(BuildReporterActionHandler.class);
    @Inject
    WorkflowRunAnalyzer workflowRunAnalyzer;
    @Inject
    BuildReporter buildReporter;

    public Optional<String> generateReport(String workflowName, GHWorkflowRun workflowRun, Path buildReportsArtifactsPath, BuildReporterConfig buildReporterConfig) throws IOException {
        Map<String, Optional<BuildReports>> buildReportsMap = this.prepareBuildReportMap(buildReportsArtifactsPath);
        WorkflowContext workflowContext = new WorkflowContext(workflowRun);
        List<GHWorkflowJob> jobs = workflowRun.listJobs().toList().stream().filter(j -> j.getConclusion() != GHWorkflowRun.Conclusion.UNKNOWN && j.getConclusion() != GHWorkflowRun.Conclusion.ACTION_REQUIRED).sorted(buildReporterConfig.getJobNameComparator()).collect(Collectors.toList());
        Optional<WorkflowReport> workflowReportOptional = this.workflowRunAnalyzer.getReport(workflowName, workflowRun, workflowContext, jobs, buildReportsMap);
        if (workflowReportOptional.isEmpty()) {
            return Optional.empty();
        }
        return this.buildReporter.generateReportComment(workflowName, workflowRun, buildReporterConfig, workflowContext, workflowReportOptional.get(), true, false, false);
    }

    private Map<String, Optional<BuildReports>> prepareBuildReportMap(Path buildReportsArtifactsPath) {
        HashMap<String, Optional<BuildReports>> hashMap;
        block9: {
            if (!Files.exists(buildReportsArtifactsPath, new LinkOption[0]) || !Files.isDirectory(buildReportsArtifactsPath, new LinkOption[0])) {
                return Map.of();
            }
            HashMap<String, Optional<BuildReports>> buildReportsMap = new HashMap<String, Optional<BuildReports>>();
            Stream<Path> jobBuildReportsDirectoriesStream = Files.list(buildReportsArtifactsPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(d -> d.getFileName().toString().startsWith("build-reports-"));
            try {
                jobBuildReportsDirectoriesStream.forEach(jobBuildReportsDirectory -> {
                    String jobName = jobBuildReportsDirectory.getFileName().toString().replace("build-reports-", "");
                    BuildReports.Builder buildReportsBuilder = new BuildReports.Builder((Path)jobBuildReportsDirectory);
                    try (Stream<Path> jobBuildReportsFilesStream = Files.walk(jobBuildReportsDirectory, new FileVisitOption[0]);){
                        jobBuildReportsFilesStream.forEach(p -> buildReportsBuilder.addPath((Path)p));
                        buildReportsMap.put(jobName, Optional.of(buildReportsBuilder.build()));
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to extract build reports from subdirectory " + jobBuildReportsDirectory), (Throwable)e);
                        buildReportsMap.put(jobName, Optional.empty());
                    }
                });
                hashMap = buildReportsMap;
                if (jobBuildReportsDirectoriesStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jobBuildReportsDirectoriesStream != null) {
                        try {
                            jobBuildReportsDirectoriesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to extract build reports from directory " + buildReportsArtifactsPath), (Throwable)e);
                    return Map.of();
                }
            }
            jobBuildReportsDirectoriesStream.close();
        }
        return hashMap;
    }
}

