/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.bot.build.reporting.model.BuildReport;
import io.quarkus.bot.build.reporting.model.ProjectReport;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.BuildReportsUnarchiver;
import io.quarkus.bot.buildreporter.githubactions.StackTraceShortener;
import io.quarkus.bot.buildreporter.githubactions.WorkflowConstants;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.WorkflowJobLabeller;
import io.quarkus.bot.buildreporter.githubactions.WorkflowUtils;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportFlakyTestCase;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJob;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportModule;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportTestCase;
import io.quarkus.bot.buildreporter.githubactions.urlshortener.UrlShortener;
import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.NullConsoleLogger;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;

@ApplicationScoped
@RegisterForReflection(targets={BuildReport.class, ProjectReport.class})
public class WorkflowRunAnalyzer {
    private static final Logger LOG = Logger.getLogger(WorkflowRunAnalyzer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final BuildReport EMPTY_BUILD_REPORT = new BuildReport();
    @Inject
    BuildReportsUnarchiver buildReportsUnarchiver;
    @Inject
    WorkflowJobLabeller workflowJobLabeller;
    @Inject
    StackTraceShortener stackTraceShortener;
    @Inject
    UrlShortener urlShortener;

    public Optional<WorkflowReport> getReport(String workflowName, GHWorkflowRun workflowRun, WorkflowContext workflowContext, List<GHWorkflowJob> jobs, Map<String, Optional<BuildReports>> buildReportsMap) throws IOException {
        if (jobs.isEmpty()) {
            LOG.error((Object)(workflowContext.getLogContext() + " - No jobs found"));
            return Optional.empty();
        }
        GHRepository workflowRunRepository = workflowRun.getRepository();
        String sha = workflowRun.getHeadSha();
        ArrayList<WorkflowReportJob> workflowReportJobs = new ArrayList<WorkflowReportJob>();
        for (GHWorkflowJob job : jobs) {
            if (job.getConclusion() != GHWorkflowRun.Conclusion.FAILURE && job.getConclusion() != GHWorkflowRun.Conclusion.CANCELLED && job.getConclusion() != GHWorkflowRun.Conclusion.SUCCESS) {
                workflowReportJobs.add(new WorkflowReportJob(job.getName(), this.workflowJobLabeller.label(job.getName()), null, job.getConclusion(), null, null, null, null, EMPTY_BUILD_REPORT, Collections.emptyList(), false));
                continue;
            }
            Optional<BuildReports> buildReportsOptional = buildReportsMap.get(job.getName());
            BuildReport buildReport = EMPTY_BUILD_REPORT;
            String gradleBuildScanUrl = null;
            List<WorkflowReportModule> modules = Collections.emptyList();
            boolean errorDownloadingBuildReports = false;
            if (buildReportsOptional != null) {
                if (buildReportsOptional.isPresent()) {
                    BuildReports buildReports = buildReportsOptional.get();
                    if (buildReports.getBuildReportPath() != null) {
                        buildReport = WorkflowRunAnalyzer.getBuildReport(workflowContext, buildReports.getBuildReportPath());
                    }
                    if (buildReports.getGradleBuildScanUrlPath() != null) {
                        try {
                            gradleBuildScanUrl = Files.readString(buildReports.getGradleBuildScanUrlPath()).trim();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Unable to read file containing Gradle Build Scan URL", (Throwable)e);
                        }
                    }
                    modules = this.getModules(workflowContext, buildReport, buildReports.getJobDirectory(), buildReports.getTestResultsPaths(), sha);
                } else {
                    errorDownloadingBuildReports = true;
                    LOG.error((Object)(workflowContext.getLogContext() + " - Unable to analyze build report for job " + job.getName() + " - see exceptions above"));
                }
            }
            workflowReportJobs.add(new WorkflowReportJob(job.getName(), this.workflowJobLabeller.label(job.getName()), WorkflowRunAnalyzer.getFailuresAnchor(job.getId()), job.getConclusion(), WorkflowRunAnalyzer.getFailingStep(job.getSteps()), this.getJobUrl(job), this.getRawLogsUrl(job, workflowRun.getHeadSha()), gradleBuildScanUrl, buildReport, modules, errorDownloadingBuildReports));
        }
        if (workflowReportJobs.isEmpty()) {
            LOG.warn((Object)(workflowContext.getLogContext() + " - Report jobs empty"));
            return Optional.empty();
        }
        WorkflowReport report = new WorkflowReport(workflowName, sha, workflowReportJobs, workflowRunRepository.getFullName().equals(workflowContext.getRepository()), workflowRun.getConclusion(), workflowRun.getHtmlUrl().toString());
        return Optional.of(report);
    }

    private static BuildReport getBuildReport(WorkflowContext workflowContext, Path buildReportPath) {
        if (buildReportPath == null) {
            return new BuildReport();
        }
        try {
            return (BuildReport)OBJECT_MAPPER.readValue(buildReportPath.toFile(), BuildReport.class);
        }
        catch (Exception e) {
            LOG.error((Object)(workflowContext.getLogContext() + " - Unable to deserialize " + WorkflowConstants.BUILD_REPORT_PATH), (Throwable)e);
            return new BuildReport();
        }
    }

    private List<WorkflowReportModule> getModules(WorkflowContext workflowContext, BuildReport buildReport, Path jobDirectory, Set<BuildReports.TestResultsPath> testResultsPaths, String sha) {
        ArrayList<WorkflowReportModule> modules = new ArrayList<WorkflowReportModule>();
        Map<String, ModuleReports> moduleReportsMap = WorkflowRunAnalyzer.mapModuleReports(buildReport, testResultsPaths, jobDirectory);
        for (Map.Entry<String, ModuleReports> moduleReportsEntry : moduleReportsMap.entrySet()) {
            String moduleName = moduleReportsEntry.getKey();
            ModuleReports moduleReports = moduleReportsEntry.getValue();
            ArrayList<ReportTestSuite> reportTestSuites = new ArrayList<ReportTestSuite>();
            ArrayList<WorkflowReportTestCase> workflowReportTestCases = new ArrayList<WorkflowReportTestCase>();
            ArrayList<WorkflowReportFlakyTestCase> workflowReportFlakyTestCases = new ArrayList<WorkflowReportFlakyTestCase>();
            for (BuildReports.TestResultsPath testResultPath : moduleReports.getTestResultsPaths()) {
                try {
                    SurefireReportParser surefireReportsParser = new SurefireReportParser(Collections.singletonList(testResultPath.getPath().toFile()), (ConsoleLogger)new NullConsoleLogger());
                    reportTestSuites.addAll(surefireReportsParser.parseXMLReportFiles());
                    workflowReportTestCases.addAll(surefireReportsParser.getFailureDetails(reportTestSuites).stream().filter(rtc -> !rtc.hasSkipped()).map(rtc -> new WorkflowReportTestCase(WorkflowUtils.getFilePath(moduleName, rtc.getFullClassName()), (ReportTestCase)rtc, this.stackTraceShortener.shorten(rtc.getFailureDetail(), 1000, 8), WorkflowRunAnalyzer.getFailureUrl(workflowContext.getRepository(), sha, moduleName, rtc), this.urlShortener.shorten(WorkflowRunAnalyzer.getFailureUrl(workflowContext.getRepository(), sha, moduleName, rtc)))).collect(Collectors.toList()));
                    workflowReportFlakyTestCases.addAll(WorkflowRunAnalyzer.getFlakeDetails(reportTestSuites).stream().filter(rtc -> !rtc.hasSkipped()).map(rtc -> new WorkflowReportFlakyTestCase(WorkflowUtils.getFilePath(moduleName, rtc.getFullClassName()), (ReportTestCase)rtc, Stream.concat(rtc.getFlakyErrors().stream().map(fe -> new WorkflowReportFlakyTestCase.Flake(fe.getMessage(), fe.getType(), fe.getStackTrace(), this.stackTraceShortener.shorten(fe.getStackTrace(), 1000, 8))), rtc.getFlakyFailures().stream().map(fe -> new WorkflowReportFlakyTestCase.Flake(fe.getMessage(), fe.getType(), fe.getStackTrace(), this.stackTraceShortener.shorten(fe.getStackTrace(), 1000, 8)))).collect(Collectors.toList()))).collect(Collectors.toList()));
                }
                catch (Exception e) {
                    LOG.error((Object)(workflowContext.getLogContext() + " - Unable to parse test results for file " + testResultPath.getPath()), (Throwable)e);
                }
            }
            Collections.sort(workflowReportTestCases);
            Collections.sort(workflowReportFlakyTestCases);
            WorkflowReportModule module = new WorkflowReportModule(moduleName, moduleReports.getProjectReport(), moduleReports.getProjectReport() != null ? WorkflowRunAnalyzer.firstLines(moduleReports.getProjectReport().getError(), 5) : null, reportTestSuites, workflowReportTestCases, workflowReportFlakyTestCases);
            if (!module.hasReportedFailures() && !module.hasFlakyTests()) continue;
            modules.add(module);
        }
        return modules;
    }

    private static Map<String, ModuleReports> mapModuleReports(BuildReport buildReport, Set<BuildReports.TestResultsPath> testResultsPaths, Path jobDirectory) {
        TreeSet modules = new TreeSet();
        modules.addAll(buildReport.getProjectReports().stream().map(pr -> WorkflowRunAnalyzer.normalizeModuleName(pr.getBasedir())).collect(Collectors.toList()));
        modules.addAll(testResultsPaths.stream().map(trp -> WorkflowRunAnalyzer.normalizeModuleName(trp.getModuleName(jobDirectory))).collect(Collectors.toList()));
        TreeMap<String, ModuleReports> moduleReports = new TreeMap<String, ModuleReports>();
        for (String module : modules) {
            moduleReports.put(module, new ModuleReports(buildReport.getProjectReports().stream().filter(pr -> WorkflowRunAnalyzer.normalizeModuleName(pr.getBasedir()).equals(module)).findFirst().orElse(null), testResultsPaths.stream().filter(trp -> WorkflowRunAnalyzer.normalizeModuleName(trp.getModuleName(jobDirectory)).equals(module)).collect(Collectors.toCollection(TreeSet::new))));
        }
        return moduleReports;
    }

    private static String normalizeModuleName(String moduleName) {
        return moduleName.replace('\\', '/');
    }

    private static String getFailuresAnchor(Long jobId) {
        return "test-failures-job-" + jobId;
    }

    private static String getFailingStep(List<GHWorkflowJob.Step> steps) {
        for (GHWorkflowJob.Step step : steps) {
            if (step.getConclusion() == GHWorkflowRun.Conclusion.SUCCESS || step.getConclusion() == GHWorkflowRun.Conclusion.SKIPPED || step.getConclusion() == GHWorkflowRun.Conclusion.NEUTRAL) continue;
            return step.getName();
        }
        return null;
    }

    private String getJobUrl(GHWorkflowJob job) {
        return this.urlShortener.shorten(job.getHtmlUrl().toString());
    }

    private String getRawLogsUrl(GHWorkflowJob job, String sha) {
        return this.urlShortener.shorten(job.getRepository().getHtmlUrl().toString() + "/commit/" + sha + "/checks/" + job.getId() + "/logs");
    }

    private static String getFailureUrl(String repository, String sha, String moduleName, ReportTestCase reportTestCase) {
        Object classPath = reportTestCase.getFullClassName().replace(".", "/");
        int dollarIndex = reportTestCase.getFullClassName().indexOf(36);
        if (dollarIndex > 0) {
            classPath = ((String)classPath).substring(0, dollarIndex);
        }
        classPath = "src/test/java/" + (String)classPath + ".java";
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/").append(repository).append("/blob/").append(sha).append("/").append(WorkflowUtils.getFilePath(moduleName, reportTestCase.getFullClassName()));
        if (StringUtils.isNotBlank((CharSequence)reportTestCase.getFailureErrorLine())) {
            sb.append("#L").append(reportTestCase.getFailureErrorLine());
        }
        return sb.toString();
    }

    private static List<ReportTestCase> getFlakeDetails(List<ReportTestSuite> testSuites) {
        ArrayList<ReportTestCase> flakeDetails = new ArrayList<ReportTestCase>();
        for (ReportTestSuite suite : testSuites) {
            for (ReportTestCase tCase : suite.getTestCases()) {
                if (!tCase.hasFlakes()) continue;
                flakeDetails.add(tCase);
            }
        }
        return flakeDetails;
    }

    private static String firstLines(String string, int numberOfLines) {
        if (string == null || string.isBlank()) {
            return null;
        }
        return string.lines().limit(numberOfLines).collect(Collectors.joining("\n"));
    }

    private static class ModuleReports {
        private final ProjectReport projectReport;
        private final Set<BuildReports.TestResultsPath> testResultsPaths;

        private ModuleReports(ProjectReport projectReport, Set<BuildReports.TestResultsPath> testResultsPaths) {
            this.projectReport = projectReport;
            this.testResultsPaths = testResultsPaths;
        }

        public ProjectReport getProjectReport() {
            return this.projectReport;
        }

        public Set<BuildReports.TestResultsPath> getTestResultsPaths() {
            return this.testResultsPaths;
        }
    }
}

