/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions.report;

import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJob;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.github.GHWorkflowRun;

@RegisterForReflection
public class WorkflowReport {
    private final String workflowName;
    private final String sha;
    private final List<WorkflowReportJob> jobs;
    private final boolean sameRepository;
    private final GHWorkflowRun.Conclusion conclusion;
    private final String workflowRunUrl;

    public WorkflowReport(String workflowName, String sha, List<WorkflowReportJob> jobs, boolean sameRepository, GHWorkflowRun.Conclusion conclusion, String workflowRunUrl) {
        this.workflowName = workflowName;
        this.sha = sha;
        this.jobs = jobs;
        this.sameRepository = sameRepository;
        this.conclusion = conclusion;
        this.workflowRunUrl = workflowRunUrl;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public String getSha() {
        return this.sha;
    }

    public void addJob(WorkflowReportJob job) {
        this.jobs.add(job);
    }

    public List<WorkflowReportJob> getJobs() {
        return this.jobs;
    }

    public boolean hasJobsFailing() {
        for (WorkflowReportJob job : this.jobs) {
            if (!job.isFailing()) continue;
            return true;
        }
        return false;
    }

    public List<WorkflowReportJob> getJobsWithReportedFailures() {
        return this.jobs.stream().filter(j -> j.hasReportedFailures()).collect(Collectors.toList());
    }

    public List<WorkflowReportJob> getJobsWithFlakyTests() {
        return this.jobs.stream().filter(j -> j.hasFlakyTests()).collect(Collectors.toList());
    }

    public boolean hasReportedFailures() {
        return this.hasBuildReportFailures() || this.hasTestFailures();
    }

    public boolean hasBuildReportFailures() {
        for (WorkflowReportJob job : this.jobs) {
            if (!job.hasBuildReportFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTestFailures() {
        for (WorkflowReportJob job : this.jobs) {
            if (!job.hasTestFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFlakyTests() {
        for (WorkflowReportJob job : this.jobs) {
            if (!job.hasFlakyTests()) continue;
            return true;
        }
        return false;
    }

    public boolean isSameRepository() {
        return this.sameRepository;
    }

    public boolean isCancelled() {
        if (GHWorkflowRun.Conclusion.CANCELLED.equals((Object)this.conclusion)) {
            return true;
        }
        return this.jobs.stream().noneMatch(j -> GHWorkflowRun.Conclusion.CANCELLED != j.getConclusion() && GHWorkflowRun.Conclusion.SKIPPED != j.getConclusion() && GHWorkflowRun.Conclusion.NEUTRAL != j.getConclusion());
    }

    public boolean isFailure() {
        return GHWorkflowRun.Conclusion.FAILURE.equals((Object)this.conclusion);
    }

    public String getWorkflowRunUrl() {
        return this.workflowRunUrl;
    }

    public boolean hasErrorDownloadingBuildReports() {
        for (WorkflowReportJob job : this.jobs) {
            if (!job.hasErrorDownloadingBuildReports()) continue;
            return true;
        }
        return false;
    }
}

