/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions.report;

import io.quarkus.bot.build.reporting.model.BuildReport;
import io.quarkus.bot.build.reporting.model.BuildStatus;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportModule;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.github.GHWorkflowRun;

@RegisterForReflection
public class WorkflowReportJob {
    private static final int MODULES_LIMIT = 3;
    private final String name;
    private final String label;
    private final String failuresAnchor;
    private final GHWorkflowRun.Conclusion conclusion;
    private final String failingStep;
    private final String url;
    private final String rawLogsUrl;
    private final String gradleBuildScanUrl;
    private final List<String> failingModules;
    private final List<String> skippedModules;
    private final List<WorkflowReportModule> modules;
    private final boolean errorDownloadingSurefireReports;

    public WorkflowReportJob(String name, String label, String failuresAnchor, GHWorkflowRun.Conclusion conclusion, String failingStep, String url, String rawLogsUrl, String gradleBuildScanUrl, BuildReport buildReport, List<WorkflowReportModule> modules, boolean errorDownloadingSurefireReports) {
        this.name = name;
        this.label = label;
        this.failuresAnchor = failuresAnchor;
        this.conclusion = conclusion;
        this.failingStep = failingStep;
        this.url = url;
        this.rawLogsUrl = rawLogsUrl;
        this.gradleBuildScanUrl = gradleBuildScanUrl;
        this.failingModules = buildReport.getProjectReports().stream().filter(pr -> pr.getStatus() == BuildStatus.FAILURE).map(pr -> pr.getBasedir()).sorted().collect(Collectors.toList());
        this.skippedModules = buildReport.getProjectReports().stream().filter(pr -> pr.getStatus() == BuildStatus.SKIPPED).map(pr -> pr.getBasedir()).sorted().collect(Collectors.toList());
        this.modules = modules;
        this.errorDownloadingSurefireReports = errorDownloadingSurefireReports;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFailuresAnchor() {
        return this.failuresAnchor;
    }

    public GHWorkflowRun.Conclusion getConclusion() {
        return this.conclusion;
    }

    public String getConclusionEmoji() {
        if (this.conclusion == null) {
            return ":question:";
        }
        switch (this.conclusion) {
            case SUCCESS: {
                return ":heavy_check_mark:";
            }
            case FAILURE: {
                return "\u2716";
            }
            case CANCELLED: {
                return ":hourglass:";
            }
            case SKIPPED: {
                return ":no_entry_sign:";
            }
        }
        return ":question:";
    }

    public boolean isFailing() {
        return !GHWorkflowRun.Conclusion.SUCCESS.equals((Object)this.conclusion) && !GHWorkflowRun.Conclusion.SKIPPED.equals((Object)this.conclusion);
    }

    public boolean isSkipped() {
        return GHWorkflowRun.Conclusion.SKIPPED.equals((Object)this.conclusion);
    }

    public String getFailingStep() {
        return this.failingStep;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRawLogsUrl() {
        return this.rawLogsUrl;
    }

    public String getGradleBuildScanUrl() {
        return this.gradleBuildScanUrl;
    }

    public List<WorkflowReportModule> getModules() {
        return this.modules;
    }

    public List<WorkflowReportModule> getModulesWithReportedFailures() {
        return this.modules.stream().filter(m -> m.hasReportedFailures()).collect(Collectors.toList());
    }

    public List<WorkflowReportModule> getModulesWithFlakyTests() {
        return this.modules.stream().filter(m -> m.hasFlakyTests()).collect(Collectors.toList());
    }

    public boolean hasReportedFailures() {
        return this.hasBuildReportFailures() || this.hasTestFailures();
    }

    public boolean hasBuildReportFailures() {
        for (WorkflowReportModule module : this.modules) {
            if (!module.hasBuildReportFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTestFailures() {
        for (WorkflowReportModule module : this.modules) {
            if (!module.hasTestFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFlakyTests() {
        for (WorkflowReportModule module : this.modules) {
            if (!module.hasFlakyTests()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrorDownloadingBuildReports() {
        return this.errorDownloadingSurefireReports;
    }

    public List<String> getFailingModules() {
        return this.failingModules;
    }

    public List<String> getFirstFailingModules() {
        if (this.failingModules.size() <= 3) {
            return this.failingModules;
        }
        return this.failingModules.subList(0, 3);
    }

    public int getMoreFailingModulesCount() {
        if (this.failingModules.size() <= 3) {
            return 0;
        }
        return this.failingModules.size() - 3;
    }

    public List<String> getSkippedModules() {
        return this.skippedModules;
    }

    public List<String> getFirstSkippedModules() {
        if (this.skippedModules.size() <= 3) {
            return this.skippedModules;
        }
        return this.skippedModules.subList(0, 3);
    }

    public int getMoreSkippedModulesCount() {
        if (this.skippedModules.size() <= 3) {
            return 0;
        }
        return this.skippedModules.size() - 3;
    }
}

