/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReporter;
import io.quarkus.bot.buildreporter.githubactions.BuildReporterConfig;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.WorkflowRunAnalyzer;
import io.quarkus.bot.buildreporter.githubactions.WorkflowUtils;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;

@Singleton
public class BuildReporterActionHandler {
    private static final Logger LOG = Logger.getLogger(BuildReporterActionHandler.class);
    @Inject
    WorkflowRunAnalyzer workflowRunAnalyzer;
    @Inject
    BuildReporter buildReporter;

    public Optional<String> generateReport(String workflowName, GHWorkflowRun workflowRun, Path buildReportsArtifactsPath, BuildReporterConfig buildReporterConfig) throws IOException {
        Map<String, Optional<BuildReports>> buildReportsMap = this.prepareBuildReportMap(buildReportsArtifactsPath, workflowRun.getRunAttempt());
        WorkflowContext workflowContext = new WorkflowContext(workflowRun);
        List<GHWorkflowJob> jobs = workflowRun.listJobs().toList().stream().filter(j -> j.getConclusion() != GHWorkflowRun.Conclusion.UNKNOWN && j.getConclusion() != GHWorkflowRun.Conclusion.ACTION_REQUIRED && j.getConclusion() != GHWorkflowRun.Conclusion.NEUTRAL && j.getConclusion() != GHWorkflowRun.Conclusion.STALE).sorted(buildReporterConfig.getJobNameComparator()).collect(Collectors.toList());
        Optional<WorkflowReport> workflowReportOptional = this.workflowRunAnalyzer.getReport(workflowName, workflowRun, workflowContext, jobs, buildReportsMap);
        if (workflowReportOptional.isEmpty()) {
            return Optional.empty();
        }
        return this.buildReporter.generateReportComment(workflowName, workflowRun, buildReporterConfig, workflowContext, workflowReportOptional.get(), true, false, false);
    }

    private Map<String, Optional<BuildReports>> prepareBuildReportMap(Path buildReportsArtifactsPath, long runAttempt) {
        HashMap<String, Optional<BuildReports>> hashMap;
        block18: {
            if (!Files.exists(buildReportsArtifactsPath, new LinkOption[0]) || !Files.isDirectory(buildReportsArtifactsPath, new LinkOption[0])) {
                return Map.of();
            }
            boolean useNewBuildReportsArtifactNamePattern = false;
            try (Stream<Path> jobBuildReportsDirectoriesStream = Files.list(buildReportsArtifactsPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                useNewBuildReportsArtifactNamePattern = jobBuildReportsDirectoriesStream.anyMatch(d -> WorkflowUtils.matchesNewBuildReportsArtifactNamePattern(d.getFileName().toString()));
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to extract build reports from directory " + buildReportsArtifactsPath), (Throwable)e);
                return Map.of();
            }
            HashMap<String, Optional<BuildReports>> buildReportsMap = new HashMap<String, Optional<BuildReports>>();
            Object buildReportsArtifactPrefix = useNewBuildReportsArtifactNamePattern ? "build-reports-" + runAttempt + "-" : "build-reports-";
            Stream<Path> jobBuildReportsDirectoriesStream = Files.list(buildReportsArtifactsPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(arg_0 -> BuildReporterActionHandler.lambda$prepareBuildReportMap$4((String)buildReportsArtifactPrefix, arg_0));
            try {
                jobBuildReportsDirectoriesStream.forEach(arg_0 -> this.lambda$prepareBuildReportMap$6((String)buildReportsArtifactPrefix, buildReportsMap, arg_0));
                hashMap = buildReportsMap;
                if (jobBuildReportsDirectoriesStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (jobBuildReportsDirectoriesStream != null) {
                        try {
                            jobBuildReportsDirectoriesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to extract build reports from directory " + buildReportsArtifactsPath), (Throwable)e);
                    return Map.of();
                }
            }
            jobBuildReportsDirectoriesStream.close();
        }
        return hashMap;
    }

    private BuildReports unzip(InputStream inputStream, Path jobDirectory) throws IOException {
        BuildReports.Builder buildReportsBuilder = new BuildReports.Builder(jobDirectory);
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            byte[] buffer = new byte[1024];
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path newPath = BuildReporterActionHandler.getZipEntryPath(jobDirectory, zipEntry);
                File newFile = newPath.toFile();
                buildReportsBuilder.addPath(newPath);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        return buildReportsBuilder.build();
    }

    private static Path getZipEntryPath(Path destinationDirectory, ZipEntry zipEntry) throws IOException {
        Path destinationFile = destinationDirectory.resolve(zipEntry.getName());
        if (!destinationFile.toAbsolutePath().startsWith(destinationDirectory.toAbsolutePath())) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destinationFile;
    }

    private /* synthetic */ void lambda$prepareBuildReportMap$6(String buildReportsArtifactPrefix, Map buildReportsMap, Path jobBuildReportsDirectory) {
        String jobName = jobBuildReportsDirectory.getFileName().toString().replace(buildReportsArtifactPrefix, "");
        BuildReports.Builder buildReportsBuilder = new BuildReports.Builder(jobBuildReportsDirectory);
        Path buildReportsArchive = jobBuildReportsDirectory.resolve("build-reports.zip");
        if (Files.isReadable(buildReportsArchive)) {
            try (InputStream buildReportsZipIs = Files.newInputStream(buildReportsArchive, new OpenOption[0]);){
                buildReportsMap.put(jobName, Optional.of(this.unzip(buildReportsZipIs, Files.createTempDirectory("build-reports-analyzer-action-" + jobName, new FileAttribute[0]))));
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to extract build reports from archive " + buildReportsArchive), (Throwable)e);
            }
        } else {
            try (Stream<Path> jobBuildReportsFilesStream = Files.walk(jobBuildReportsDirectory, new FileVisitOption[0]);){
                jobBuildReportsFilesStream.forEach(p -> buildReportsBuilder.addPath((Path)p));
                buildReportsMap.put(jobName, Optional.of(buildReportsBuilder.build()));
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to extract build reports from subdirectory " + jobBuildReportsDirectory), (Throwable)e);
                buildReportsMap.put(jobName, Optional.empty());
            }
        }
    }

    private static /* synthetic */ boolean lambda$prepareBuildReportMap$4(String buildReportsArtifactPrefix, Path d) {
        return d.getFileName().toString().startsWith(buildReportsArtifactPrefix);
    }
}

