/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJobIncludeStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.kohsuke.github.GHWorkflowJob;

public class BuildReporterConfig {
    private final boolean dryRun;
    private final WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy;
    private final Comparator<GHWorkflowJob> workflowJobComparator;
    private final Set<String> monitoredWorkflows;
    private final boolean createCheckRun;
    private final boolean develocityEnabled;
    private final String develocityUrl;

    private BuildReporterConfig(boolean dryRun, WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy, Comparator<GHWorkflowJob> workflowJobComparator, Set<String> monitoredWorkflows, boolean createCheckRun, boolean develocityEnabled, String develocityUrl) {
        this.dryRun = dryRun;
        this.workflowReportJobIncludeStrategy = workflowReportJobIncludeStrategy;
        this.workflowJobComparator = workflowJobComparator;
        this.monitoredWorkflows = monitoredWorkflows;
        this.createCheckRun = createCheckRun;
        this.develocityEnabled = develocityEnabled;
        this.develocityUrl = develocityUrl;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public WorkflowReportJobIncludeStrategy getWorkflowReportJobIncludeStrategy() {
        return this.workflowReportJobIncludeStrategy;
    }

    public Comparator<GHWorkflowJob> getJobNameComparator() {
        return this.workflowJobComparator;
    }

    public Set<String> getMonitoredWorkflows() {
        return this.monitoredWorkflows;
    }

    public boolean isCreateCheckRun() {
        return this.createCheckRun;
    }

    public boolean isDevelocityEnabled() {
        return this.develocityEnabled;
    }

    public String getDevelocityUrl() {
        return this.develocityUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean dryRun = false;
        private boolean createCheckRun = true;
        private WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy;
        private Comparator<GHWorkflowJob> workflowJobComparator;
        private Set<String> monitoredWorkflows = Collections.emptySet();
        private boolean develocityEnabled;
        private String develocityUrl;

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder workflowReportJobIncludeStrategy(WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy) {
            this.workflowReportJobIncludeStrategy = workflowReportJobIncludeStrategy;
            return this;
        }

        public Builder workflowJobComparator(Comparator<GHWorkflowJob> workflowJobComparator) {
            this.workflowJobComparator = workflowJobComparator;
            return this;
        }

        public Builder monitoredWorkflows(Set<String> monitoredWorkflows) {
            this.monitoredWorkflows = monitoredWorkflows;
            return this;
        }

        public Builder createCheckRun(boolean createCheckRun) {
            this.createCheckRun = createCheckRun;
            return this;
        }

        public Builder enableDevelocity(boolean develocityEnabled) {
            this.develocityEnabled = develocityEnabled;
            return this;
        }

        public Builder develocityUrl(String develocityUrl) {
            this.develocityUrl = develocityUrl;
            return this;
        }

        public BuildReporterConfig build() {
            return new BuildReporterConfig(this.dryRun, this.workflowReportJobIncludeStrategy, (Comparator<GHWorkflowJob>)(this.workflowJobComparator != null ? this.workflowJobComparator : DefaultJobNameComparator.INSTANCE), this.monitoredWorkflows, this.createCheckRun, this.develocityEnabled, this.develocityUrl);
        }
    }

    private static class DefaultJobNameComparator
    implements Comparator<GHWorkflowJob> {
        private static final DefaultJobNameComparator INSTANCE = new DefaultJobNameComparator();

        private DefaultJobNameComparator() {
        }

        @Override
        public int compare(GHWorkflowJob o1, GHWorkflowJob o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

