/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.WorkflowConstants;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

class BuildReports {
    private static final Path MAVEN_SUREFIRE_REPORTS_PATH = Path.of("target", "surefire-reports");
    private static final Path MAVEN_FAILSAFE_REPORTS_PATH = Path.of("target", "failsafe-reports");
    private static final Path GRADLE_REPORTS_PATH = Path.of("build", "test-results", "test");
    private final Path jobDirectory;
    private final Path buildReportPath;
    private final Path gradleBuildScanUrlPath;
    private final Set<TestResultsPath> testResultsPaths;

    private BuildReports(Path jobDirectory, Path buildReportPath, Path gradleBuildScanUrlPath, Set<TestResultsPath> testResultsPaths) {
        this.jobDirectory = jobDirectory;
        this.buildReportPath = buildReportPath;
        this.gradleBuildScanUrlPath = gradleBuildScanUrlPath;
        this.testResultsPaths = Collections.unmodifiableSet(testResultsPaths);
    }

    public Path getJobDirectory() {
        return this.jobDirectory;
    }

    public Path getBuildReportPath() {
        return this.buildReportPath;
    }

    public Path getGradleBuildScanUrlPath() {
        return this.gradleBuildScanUrlPath;
    }

    public Set<TestResultsPath> getTestResultsPaths() {
        return this.testResultsPaths;
    }

    public String toString() {
        return "BuildReports[\n    jobDirectory=" + this.jobDirectory + "\n    buildReportPath=" + this.buildReportPath + "\n    gradleBuildScanUrlPath=" + this.gradleBuildScanUrlPath + "\n    testResultsPaths=" + this.testResultsPaths + "\n]";
    }

    static class GradleTestResultsPath
    implements TestResultsPath {
        private final Path path;

        GradleTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().getParent().toString();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.path + "]";
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GradleTestResultsPath other = (GradleTestResultsPath)obj;
            return Objects.equals(this.path, other.path);
        }
    }

    static class FailsafeTestResultsPath
    implements TestResultsPath {
        private final Path path;

        FailsafeTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().toString();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.path + "]";
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FailsafeTestResultsPath other = (FailsafeTestResultsPath)obj;
            return Objects.equals(this.path, other.path);
        }
    }

    private static class SurefireTestResultsPath
    implements TestResultsPath {
        private final Path path;

        SurefireTestResultsPath(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getModuleName(Path jobDirectory) {
            return jobDirectory.relativize(this.path).getParent().getParent().toString();
        }

        @Override
        public int compareTo(TestResultsPath o) {
            return this.path.compareTo(o.getPath());
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.path + "]";
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SurefireTestResultsPath other = (SurefireTestResultsPath)obj;
            return Objects.equals(this.path, other.path);
        }
    }

    static class Builder {
        private final Path jobDirectory;
        private Path buildReportPath;
        private Path gradleBuildScanUrlPath;
        private Set<TestResultsPath> testResultsPaths = new TreeSet<TestResultsPath>();
        private Set<Path> alreadyTreatedPaths = new HashSet<Path>();

        Builder(Path jobDirectory) {
            this.jobDirectory = jobDirectory;
        }

        void addPath(Path path) {
            if (path.endsWith(WorkflowConstants.BUILD_REPORT_PATH)) {
                this.buildReportPath = path;
                return;
            }
            if (path.endsWith(WorkflowConstants.GRADLE_BUILD_SCAN_URL_PATH)) {
                this.gradleBuildScanUrlPath = path;
                return;
            }
            if (this.addTestPath(path)) {
                return;
            }
            this.addTestPath(path.getParent());
        }

        private boolean addTestPath(Path path) {
            if (path == null || this.alreadyTreatedPaths.contains(path)) {
                return true;
            }
            if (path.endsWith(MAVEN_SUREFIRE_REPORTS_PATH)) {
                this.testResultsPaths.add(new SurefireTestResultsPath(path));
                return true;
            }
            if (path.endsWith(MAVEN_FAILSAFE_REPORTS_PATH)) {
                this.testResultsPaths.add(new FailsafeTestResultsPath(path));
                return true;
            }
            if (path.endsWith(GRADLE_REPORTS_PATH)) {
                this.testResultsPaths.add(new GradleTestResultsPath(path));
                return true;
            }
            return false;
        }

        BuildReports build() {
            return new BuildReports(this.jobDirectory, this.buildReportPath, this.gradleBuildScanUrlPath, this.testResultsPaths);
        }
    }

    static interface TestResultsPath
    extends Comparable<TestResultsPath> {
        public Path getPath();

        public String getModuleName(Path var1);
    }
}

