/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions.report;

import io.quarkus.runtime.annotations.RegisterForReflection;
import org.apache.maven.plugins.surefire.report.ReportTestCase;

@RegisterForReflection
public class WorkflowReportTestCase
implements Comparable<WorkflowReportTestCase> {
    private final String classPath;
    private final String fullName;
    private final String fullClassName;
    private final String name;
    private final String failureType;
    private final String failureErrorLine;
    private final String abbreviatedFailureDetail;
    private final String failureDetail;
    private final String failureUrl;
    private final String shortenedFailureUrl;

    public WorkflowReportTestCase(String classPath, ReportTestCase reportTestCase, String abbreviatedFailureDetail, String failureUrl, String shortenedFailureUrl) {
        this.classPath = classPath;
        this.fullName = reportTestCase.getFullName();
        this.fullClassName = reportTestCase.getFullClassName();
        this.name = reportTestCase.getName();
        this.failureType = reportTestCase.getFailureType();
        this.failureErrorLine = reportTestCase.getFailureErrorLine();
        this.abbreviatedFailureDetail = abbreviatedFailureDetail;
        this.failureDetail = reportTestCase.getFailureDetail();
        this.failureUrl = failureUrl;
        this.shortenedFailureUrl = shortenedFailureUrl;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getFailureType() {
        return this.failureType;
    }

    public String getFailureErrorLine() {
        return this.failureErrorLine;
    }

    public String getAbbreviatedFailureDetail() {
        return this.abbreviatedFailureDetail;
    }

    public String getFailureDetail() {
        return this.failureDetail;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public String getShortenedFailureUrl() {
        return this.shortenedFailureUrl;
    }

    @Override
    public int compareTo(WorkflowReportTestCase o) {
        int compare = this.fullName.compareTo(o.fullName);
        if (compare != 0 || this.failureErrorLine == null || this.failureErrorLine.isBlank() || o.failureErrorLine == null || o.failureErrorLine.isBlank()) {
            return compare;
        }
        try {
            Integer thisLine = Integer.valueOf(this.failureErrorLine);
            Integer otherLine = Integer.valueOf(o.failureErrorLine);
            return thisLine.compareTo(otherLine);
        }
        catch (NumberFormatException e) {
            return compare;
        }
    }
}

