/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.build.reporting.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.bot.build.reporting.model.BuildReport;
import io.quarkus.bot.build.reporting.model.ProjectReport;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="quarkus-build-report")
public class ReportingMavenExtension
extends AbstractMavenLifecycleParticipant {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final String BUILD_REPORT_JSON_FILENAME = "build-report.json";
    private static final Pattern REMOVE_COLORS = Pattern.compile("\u001b\\[[;\\d]*m");
    @Requirement
    private Logger logger;

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        MavenExecutionResult result = session.getResult();
        List projects = result.getTopologicallySortedProjects();
        BuildReport buildReport = new BuildReport();
        Path rootPath = Path.of("", new String[0]).toAbsolutePath();
        for (MavenProject project : projects) {
            BuildSummary buildSummary = result.getBuildSummary(project);
            Path projectPath = rootPath.relativize(project.getBasedir().toPath());
            if (buildSummary == null) {
                buildReport.addProjectReport(ProjectReport.skipped((String)project.getName(), (Path)projectPath, (String)project.getGroupId(), (String)project.getArtifactId()));
                continue;
            }
            if (buildSummary instanceof BuildFailure) {
                buildReport.addProjectReport(ProjectReport.failure((String)project.getName(), (Path)projectPath, (String)REMOVE_COLORS.matcher(((BuildFailure)buildSummary).getCause().getMessage()).replaceAll(""), (String)project.getGroupId(), (String)project.getArtifactId()));
                continue;
            }
            if (!(buildSummary instanceof BuildSuccess)) continue;
            buildReport.addProjectReport(ProjectReport.success((String)project.getName(), (Path)projectPath, (String)project.getGroupId(), (String)project.getArtifactId()));
        }
        Path targetDirectory = Path.of("target", new String[0]);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        catch (Exception e) {
            this.logger.error("Unable to create the target directory", (Throwable)e);
            return;
        }
        try (FileOutputStream file = new FileOutputStream(targetDirectory.resolve(BUILD_REPORT_JSON_FILENAME).toFile());){
            OBJECT_MAPPER.writeValue((OutputStream)file, (Object)buildReport);
        }
        catch (Exception e) {
            this.logger.error("Unable to create the build-report.json file", (Throwable)e);
        }
    }
}

