/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project;

import com.gradle.maven.extension.api.GradleEnterpriseApi;
import com.gradle.maven.extension.api.cache.MojoMetadataProvider;
import com.gradle.maven.extension.api.cache.NormalizationProvider;
import io.quarkus.develocity.project.ConfiguredPlugin;
import io.quarkus.develocity.project.Log;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public abstract class SimpleQuarkusConfiguredPlugin
implements ConfiguredPlugin {
    @Override
    public void configureBuildCache(GradleEnterpriseApi gradleEnterpriseApi, MavenSession mavenSession) {
        NormalizationProvider normalizationProvider = this.getNormalizationProvider();
        if (normalizationProvider != null) {
            gradleEnterpriseApi.getBuildCache().registerNormalizationProvider(context -> {
                if (!this.isBuildCacheEnabled(context.getProject())) {
                    Log.debug(this.getPluginName(), "Build cache is disabled.");
                    return;
                }
                Log.debug(this.getPluginName(), "Build cache is enabled. Configuring normalization provider.");
                normalizationProvider.configureNormalization(context);
            });
        }
        gradleEnterpriseApi.getBuildCache().registerMojoMetadataProvider(context -> context.withPlugin(this.getPluginName(), () -> {
            if (!this.isBuildCacheEnabled(context.getProject())) {
                Log.debug(this.getPluginName(), "Build cache is disabled.");
                return;
            }
            Map<String, GoalMetadataProvider> goalMetadataProviders = Collections.unmodifiableMap(this.getGoalMetadataProviders());
            Log.debug(this.getPluginName(), "Build cache is enabled. Configuring metadata providers.");
            Log.debug(this.getPluginName(), "Configuring metadata for goals: " + goalMetadataProviders.keySet());
            for (Map.Entry<String, GoalMetadataProvider> goalMetadataProviderEntry : goalMetadataProviders.entrySet()) {
                if (!goalMetadataProviderEntry.getKey().equalsIgnoreCase(context.getMojoExecution().getGoal())) continue;
                goalMetadataProviderEntry.getValue().configure(context);
            }
        }));
    }

    protected abstract String getPluginName();

    protected boolean isBuildCacheEnabled(MavenProject project) {
        return true;
    }

    protected NormalizationProvider getNormalizationProvider() {
        return null;
    }

    protected abstract Map<String, GoalMetadataProvider> getGoalMetadataProviders();

    protected static void dependsOnGav(MojoMetadataProvider.Context.Inputs inputs, MojoMetadataProvider.Context context) {
        inputs.property("_internal_gav", (Object)(context.getProject().getGroupId() + ":" + context.getProject().getArtifactId() + ":" + context.getProject().getVersion()));
    }

    protected static void dependsOnOs(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("_internal_osName", (Object)System.getProperty("os.name")).property("_internal_osVersion", (Object)System.getProperty("os.version")).property("_internal_osArch", (Object)System.getProperty("os.arch"));
    }

    protected static void dependsOnJavaVersion(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("_internal_javaVersion", (Object)System.getProperty("java.version"));
    }

    protected void addClasspathInput(MojoMetadataProvider.Context context, MojoMetadataProvider.Context.Inputs inputs) {
        try {
            List compileClasspathElements = context.getProject().getCompileClasspathElements();
            inputs.fileSet("quarkusCompileClasspath", (Object)compileClasspathElements, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Classpath can't be resolved");
        }
    }

    @FunctionalInterface
    public static interface GoalMetadataProvider {
        public void configure(MojoMetadataProvider.Context var1);
    }

    @FunctionalInterface
    public static interface PluginNormalizationProvider {
        public void configure(NormalizationProvider.Context var1);
    }
}

