/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.goals;

import com.gradle.maven.extension.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;
import java.util.stream.Collectors;

public class SourceConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-source-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("jar-no-fork", SourceConfiguredPlugin::jarNoFork);
    }

    private static void jarNoFork(MojoMetadataProvider.Context context) {
        context.inputs(inputs -> {
            SourceConfiguredPlugin.dependsOnGav(inputs, context);
            inputs.properties(new String[]{"classifier", "includes", "excludes", "useDefaultExcludes", "useDefaultManifestFile", "attach", "excludeResources", "includePom", "finalName", "forceCreation", "skipSource", "outputTimestamp"});
            inputs.fileSet("defaultManifestFile", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("resources", context.getProject().getResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("sources", (Object)context.getProject().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.ignore(new String[]{"project", "jarArchiver", "archive", "outputDirectory", "reactorProjects", "session"});
        });
        context.outputs(outputs -> {
            outputs.cacheable("If the inputs are identical, we should have the same output");
            outputs.file("source-jar", (Object)(context.getProject().getBuild().getDirectory() + "/" + context.getProject().getBuild().getFinalName() + "-sources.jar"));
        });
    }
}

