/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.maven.extension.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;

public class QuarkusExtensionConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "quarkus-extension-maven-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("extension-descriptor", QuarkusExtensionConfiguredPlugin::configureExtensionDescriptor);
    }

    private static void configureExtensionDescriptor(MojoMetadataProvider.Context context) {
        if ("false".equals(context.getProject().getProperties().getProperty("skipExtensionValidation", "false")) || "false".equals(context.getProject().getProperties().getProperty("skipCodestartValidation", "false"))) {
            return;
        }
        context.inputs(inputs -> {
            QuarkusExtensionConfiguredPlugin.dependsOnGav(inputs, context);
            inputs.properties(new String[]{"deployment", "excludedArtifacts", "parentFirstArtifacts", "runnerParentFirstArtifacts", "lesserPriorityArtifacts", "skipExtensionValidation", "ignoreNotDetectedQuarkusCoreVersion", "conditionalDependencies", "dependencyCondition", "skipCodestartValidation", "minimumJavaVersion"});
            inputs.fileSet("extensionFile", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.ignore(new String[]{"session", "repoSession", "outputDirectory", "project"});
        });
        context.nested("repos", c -> c.inputs(inputs -> inputs.properties(new String[]{"id", "url"})));
        context.nested("removedResources", c -> c.inputs(inputs -> inputs.properties(new String[]{"key", "resources"})));
        context.nested("capabilities", c -> {
            c.nested("requires", cc -> cc.inputs(inputs -> inputs.properties(new String[]{"name", "onlyIf", "onlyIfNot"})));
            c.nested("provides", cc -> cc.inputs(inputs -> inputs.properties(new String[]{"name", "onlyIf", "onlyIfNot"})));
        });
        context.outputs(outputs -> {
            outputs.cacheable("If the inputs and dependencies are identical, we should have the same output");
            outputs.file("quarkus-extension.yaml", (Object)(context.getProject().getBuild().getOutputDirectory() + "/META-INF/quarkus-extension.yaml"));
            outputs.file("quarkus-extension.properties", (Object)(context.getProject().getBuild().getOutputDirectory() + "/META-INF/quarkus-extension.properties"));
        });
    }
}

