/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.maven.extension.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;

public class KotlinConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "kotlin-maven-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("compile", KotlinConfiguredPlugin::compile, "test-compile", KotlinConfiguredPlugin::testCompile, "kapt", KotlinConfiguredPlugin::kapt);
    }

    private static void kapt(MojoMetadataProvider.Context context) {
        context.inputs(inputs -> {
            KotlinConfiguredPlugin.dependsOnGav(inputs, context);
            inputs.properties(new String[]{"annotationProcessors", "aptMode", "useLightAnalysis", "correctErrorTypes", "mapDiagnosticLocations", "annotationProcessorArgs", "javacOptions", "moduleName", "testModuleName", "jvmTarget", "scriptTemplates", "myIncremental", "javaParameters", "compilerPlugins", "pluginOptions", "multiPlatform", "apiVersion", "args", "experimentalCoroutines", "languageVersion", "module", "testModule"});
            inputs.fileSet("classpath", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
            inputs.fileSet("testClasspath", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.fileSet("sourceDirs", (Object)context.getProject().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH).lineEndingHandling(MojoMetadataProvider.Context.FileSet.LineEndingHandling.NORMALIZE).emptyDirectoryHandling(MojoMetadataProvider.Context.FileSet.EmptyDirectoryHandling.IGNORE));
            inputs.ignore(new String[]{"jdkHome", "session", "mojoExecution", "nowarn", "project", "output", "testOutput"});
        });
        context.nested("annotationProcessorPaths", c -> c.inputs(cc -> cc.properties(new String[]{"groupId", "artifactId", "version", "classifier", "type"})));
        context.localState(l -> l.files("incrementalCachesRoot"));
        context.outputs(outputs -> {
            outputs.cacheable("If the inputs are identical, we should have the same output");
            outputs.directory("kapt", (Object)(context.getProject().getBuild().getDirectory() + "/generated-sources/kapt/compile"));
            outputs.directory("kaptKotlin", (Object)(context.getProject().getBuild().getDirectory() + "/generated-sources/kaptKotlin/compile"));
            outputs.directory("kaptStubs", (Object)(context.getProject().getBuild().getDirectory() + "/kaptStubs"));
        });
        context.getProject().addCompileSourceRoot(context.getProject().getBuild().getDirectory() + "/generated-sources/kapt/compile");
        context.getProject().addCompileSourceRoot(context.getProject().getBuild().getDirectory() + "/generated-sources/kaptKotlin/compile");
    }

    private static void compile(MojoMetadataProvider.Context context) {
        KotlinConfiguredPlugin.compileCommon(context, false);
    }

    private static void testCompile(MojoMetadataProvider.Context context) {
        KotlinConfiguredPlugin.compileCommon(context, true);
    }

    private static void compileCommon(MojoMetadataProvider.Context context, boolean test) {
        context.inputs(inputs -> {
            KotlinConfiguredPlugin.dependsOnGav(inputs, context);
            inputs.properties(new String[]{"compilerPlugins", "pluginOptions", "multiPlatform", "languageVersion", "apiVersion", "experimentalCoroutines", "args", "jvmTarget", "moduleName", "testModuleName", "scriptTemplates", "javaParameters", "myIncremental"});
            if (test) {
                inputs.properties(new String[]{"skip"});
            }
            inputs.fileSet("classpath", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
            inputs.fileSet("testClasspath", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
            inputs.fileSet("sourceDirs", (Object)context.getProject().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH).lineEndingHandling(MojoMetadataProvider.Context.FileSet.LineEndingHandling.NORMALIZE).emptyDirectoryHandling(MojoMetadataProvider.Context.FileSet.EmptyDirectoryHandling.IGNORE));
            if (test) {
                inputs.fileSet("defaultSourceDir", (Object)context.getProject().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH).lineEndingHandling(MojoMetadataProvider.Context.FileSet.LineEndingHandling.NORMALIZE).emptyDirectoryHandling(MojoMetadataProvider.Context.FileSet.EmptyDirectoryHandling.IGNORE));
                inputs.fileSet("defaultSourceDirs", (Object)context.getProject().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH).lineEndingHandling(MojoMetadataProvider.Context.FileSet.LineEndingHandling.NORMALIZE).emptyDirectoryHandling(MojoMetadataProvider.Context.FileSet.EmptyDirectoryHandling.IGNORE));
            }
            inputs.ignore(new String[]{"module", "testModule", "mojoExecution", "nowarn", "project", "jdkHome", "session"});
        });
        context.localState(l -> l.files("incrementalCachesRoot"));
        context.outputs(outputs -> {
            outputs.cacheable("If the inputs are identical, we should have the same output");
            outputs.directory("output");
            outputs.directory("testOutput");
        });
    }
}

