/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.maven.extension.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;
import java.util.Map;

public class SurefireConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-surefire-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("test", SurefireConfiguredPlugin::configureTest);
    }

    private static void configureTest(MojoMetadataProvider.Context context) {
        context.inputs(inputs -> inputs.fileSet("dependency-checksums", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH)));
        context.outputs(outputs -> {
            if (Matchers.directory(context, Path.of("integration-tests", "devtools")) || Matchers.directory(context, Path.of("integration-tests", "gradle")) || Matchers.directory(context, Path.of("integration-tests", "maven"))) {
                outputs.notCacheableBecause("It is too hard to figure out the dependency tree of these modules");
            }
        });
    }
}

