/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.scan;

import com.gradle.maven.extension.api.scan.BuildScanApi;
import io.quarkus.develocity.project.Log;
import io.quarkus.develocity.project.util.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public final class BuildScanMetadata {
    private BuildScanMetadata() {
    }

    public static void addMetadataToBuildScan(BuildScanApi buildScanApi) {
        String mavenCommandLine;
        String string = mavenCommandLine = System.getenv("MAVEN_CMD_LINE_ARGS") != null ? "mvn " + System.getenv("MAVEN_CMD_LINE_ARGS") : "";
        if (!Strings.isBlank(mavenCommandLine)) {
            buildScanApi.value("Maven command line", mavenCommandLine);
        }
        if (System.getenv("GITHUB_ACTIONS") != null) {
            String jobId = System.getenv("GITHUB_JOB");
            buildScanApi.value("gh-job-id", jobId);
            buildScanApi.value("gh-event-name", System.getenv("GITHUB_EVENT_NAME"));
            buildScanApi.value("gh-ref-name", System.getenv("GITHUB_REF_NAME"));
            buildScanApi.value("gh-actor", System.getenv("GITHUB_ACTOR"));
            buildScanApi.value("gh-workflow", System.getenv("GITHUB_WORKFLOW"));
            String jobCustomValues = System.getenv("GE_CUSTOM_VALUES");
            if (!Strings.isBlank(jobCustomValues)) {
                for (String jobCustomValue : jobCustomValues.split(",")) {
                    int index = jobCustomValue.indexOf(61);
                    if (index <= 0) continue;
                    buildScanApi.value(jobCustomValue.substring(0, index).trim(), jobCustomValue.substring(index + 1).trim());
                }
            }
            ArrayList<Object> similarBuildsTags = new ArrayList<Object>();
            buildScanApi.tag(jobId);
            similarBuildsTags.add(jobId);
            buildScanApi.tag(System.getenv("GITHUB_EVENT_NAME"));
            similarBuildsTags.add(System.getenv("GITHUB_EVENT_NAME"));
            buildScanApi.tag(System.getenv("GITHUB_WORKFLOW"));
            similarBuildsTags.add(System.getenv("GITHUB_WORKFLOW"));
            String jobTags = System.getenv("GE_TAGS");
            if (!Strings.isBlank(jobTags)) {
                for (String tag : jobTags.split(",")) {
                    buildScanApi.tag(tag.trim());
                    similarBuildsTags.add(tag.trim());
                }
            }
            buildScanApi.link("Workflow run", System.getenv("GITHUB_SERVER_URL") + "/" + System.getenv("GITHUB_REPOSITORY") + "/actions/runs/" + System.getenv("GITHUB_RUN_ID"));
            String prNumber = System.getenv("PULL_REQUEST_NUMBER");
            if (!Strings.isBlank(prNumber)) {
                buildScanApi.value("gh-pr", prNumber);
                buildScanApi.tag("pr-" + prNumber);
                similarBuildsTags.add("pr-" + prNumber);
                buildScanApi.link("Pull request", System.getenv("GITHUB_SERVER_URL") + "/" + System.getenv("GITHUB_REPOSITORY") + "/pull/" + prNumber);
                if (!Strings.isBlank(System.getenv("GITHUB_BASE_REF"))) {
                    buildScanApi.tag(System.getenv("GITHUB_BASE_REF"));
                }
            }
            similarBuildsTags.add(System.getenv("RUNNER_OS"));
            buildScanApi.link("Similar builds", "https://ge.quarkus.io/scans?search.tags=" + URLEncoder.encode(String.join((CharSequence)",", similarBuildsTags), StandardCharsets.UTF_8).replace("+", "%20"));
            buildScanApi.buildScanPublished(publishedBuildScan -> {
                File target = new File("target");
                if (!target.exists()) {
                    target.mkdir();
                }
                try {
                    Path gradleBuildScanUrlFile = Path.of("target/gradle-build-scan-url.txt", new String[0]);
                    if (!Files.exists(gradleBuildScanUrlFile, new LinkOption[0])) {
                        Files.writeString(gradleBuildScanUrlFile, (CharSequence)publishedBuildScan.getBuildScanUri().toString(), new OpenOption[0]);
                    }
                    Files.writeString(Path.of(System.getenv("GITHUB_STEP_SUMMARY"), new String[0]), (CharSequence)("\n[Build scan](" + publishedBuildScan.getBuildScanUri() + ")\n<sup>`" + mavenCommandLine + "`</sup>\n\n"), StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    Log.warn("Unable to write build scan information to files", e);
                }
            });
        }
    }
}

