/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.normalization;

import com.gradle.develocity.agent.maven.api.cache.BuildCacheApi;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;

public final class Normalization {
    private Normalization() {
    }

    public static void configureNormalization(BuildCacheApi buildCacheApi) {
        buildCacheApi.registerNormalizationProvider(context -> context.configureSystemPropertiesNormalization(s -> {
            s.addIgnoredKeys(new String[]{"maven.repo.local", "maven.settings"});
            if (Matchers.directory(context, Path.of("docs", new String[0]))) {
                s.addIgnoredKeys(new String[]{"vale.dir", "git.dir"});
            }
            if (Matchers.directory(context, Path.of("independent-projects", "arc", "tcks", "cdi-tck-runner"))) {
                s.addIgnoredKeys(new String[]{"org.jboss.cdi.tck.libraryDirectory"});
            }
            if (Matchers.directory(context, Path.of("integration-tests", new String[0]))) {
                s.addIgnoredKeys(new String[]{"native.image.path", "quarkus.kubernetes-service-binding.root"});
            }
            if (Matchers.module(context, "quarkus-integration-test-rest-client")) {
                s.addIgnoredKeys(new String[]{"javax.net.ssl.trustStore", "rest-client.trustStore"});
            }
            if (Matchers.module(context, "quarkus-integration-test-test-extension")) {
                s.addIgnoredKeys(new String[]{"classpathEntriesRecordingFile"});
            }
        }));
        buildCacheApi.registerNormalizationProvider(context -> context.configureRuntimeClasspathNormalization(c -> {
            c.addIgnoredFiles(new String[]{"META-INF/ide-deps/**"});
            if (Matchers.module(context, "quarkus-integration-test-rest-client-reactive")) {
                c.addPropertiesNormalization("application.properties", new String[]{"quarkus.rest-client.self-signed.trust-store", "quarkus.rest-client.wrong-host.trust-store", "quarkus.rest-client.wrong-host-rejected.trust-store"});
            }
            if (Matchers.module(context, "quarkus-integration-test-oidc-client-reactive")) {
                c.addPropertiesNormalization("application.properties", new String[]{"quarkus.keycloak.devservices.realm-path"});
            }
            if (Matchers.module(context, "quarkus-integration-test-test-extension")) {
                c.addPropertiesNormalization("application.properties", new String[]{"quarkus.bt.classpath-recording.record-file", "%test.quarkus.bt.classpath-recording.record-file"});
            }
            if (Matchers.module(context, "quarkus-integration-test-gradle-plugin")) {
                c.addIgnoredFiles(new String[]{".quarkus/config.yml"});
            }
        }));
    }
}

