/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;
import java.util.stream.Collectors;

public class QuarkusConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "quarkus-maven-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("build", QuarkusConfiguredPlugin::configureBuild, "generate-code", QuarkusConfiguredPlugin::configureGenerateCode, "generate-code-tests", QuarkusConfiguredPlugin::configureGenerateCodeTests);
    }

    private static void configureBuild(MojoMetadataProvider.Context context) {
        context.inputs(inputs -> {
            inputs.fileSet("quarkus-dependencies", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependencies.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
        });
    }

    private static void configureGenerateCode(MojoMetadataProvider.Context context) {
        QuarkusConfiguredPlugin.configureCommonGeneratedCode(context, false);
    }

    private static void configureGenerateCodeTests(MojoMetadataProvider.Context context) {
        QuarkusConfiguredPlugin.configureCommonGeneratedCode(context, true);
    }

    private static void configureCommonGeneratedCode(MojoMetadataProvider.Context context, boolean test) {
        context.inputs(inputs -> {
            QuarkusConfiguredPlugin.dependsOnGav(inputs, context);
            QuarkusConfiguredPlugin.dependsOnOs(inputs);
            QuarkusConfiguredPlugin.dependsOnJavaVersion(inputs);
            inputs.properties(new String[]{"skipSourceGeneration", "mode", "properties", "bootstrapId"});
            inputs.fileSet("quarkus-dependencies", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependencies.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("resources", context.getProject().getResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            if (test) {
                inputs.fileSet("testResources", context.getProject().getTestResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
            try {
                if (test) {
                    inputs.fileSet("testClassPath", (Object)context.getProject().getTestClasspathElements(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
                } else {
                    inputs.fileSet("compileClassPath", (Object)context.getProject().getCompileClasspathElements(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to resolve classpath");
            }
            inputs.ignore(new String[]{"repoSession", "session", "project", "mojoExecution", "buildDir", "finalName", "manifestEntries", "manifestSections", "ignoredEntries", "appArtifact", "closeBootstrappedApp"});
        });
        context.nested("repos", c -> c.inputs(inputs -> inputs.properties(new String[]{"id", "url"})));
        context.outputs(outputs -> {
            outputs.cacheable("If the inputs and dependencies are identical, we should have the same output");
            if (test) {
                outputs.directory("generated-test-sources", (Object)(context.getProject().getBuild().getDirectory() + "/generated-test-sources"));
            } else {
                outputs.directory("generated-sources", (Object)(context.getProject().getBuild().getDirectory() + "/generated-sources"));
            }
        });
        if (test) {
            context.getProject().addTestCompileSourceRoot(context.getProject().getBuild().getDirectory() + "/generated-test-sources");
        } else {
            context.getProject().addCompileSourceRoot(context.getProject().getBuild().getDirectory() + "/generated-sources");
        }
    }
}

