/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;
import java.util.Map;

public class FailsafeConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-failsafe-plugin";
    }

    @Override
    protected Map<String, SimpleQuarkusConfiguredPlugin.GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("integration-test", FailsafeConfiguredPlugin::configureIntegrationTest);
    }

    private static void configureIntegrationTest(MojoMetadataProvider.Context context) {
        context.inputs(inputs -> {
            inputs.fileSet("quarkus-dependencies", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependencies.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            if (Matchers.directory(context, Path.of("integration-tests", new String[0]))) {
                inputs.fileSet("native-runner", (Object)context.getProject().getBuild().getDirectory(), fs -> fs.include(new String[]{"*-runner"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
        });
        context.outputs(outputs -> {
            if (Matchers.directory(context, Path.of("integration-tests", "devtools")) || Matchers.directory(context, Path.of("integration-tests", "gradle")) || Matchers.directory(context, Path.of("integration-tests", "maven"))) {
                outputs.notCacheableBecause("It is too hard to figure out the dependency tree of these modules");
            }
        });
    }
}

