/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;
import java.util.Map;

public class CompilerConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-compiler-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("compile", CompilerConfiguredPlugin::configureCompile);
    }

    private static void configureCompile(GoalMetadataProvider.Context context) {
        if (Matchers.directory(context.metadata(), Path.of("integration-tests", new String[0]))) {
            context.metadata().inputs(inputs -> inputs.fileSet("specs", (Object)(context.project().getBasedir() + "/disable-unbind-executions"), fs -> fs.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH)));
        }
        if (Matchers.directory(context.metadata(), Path.of("extensions", new String[0])) || Matchers.directory(context.metadata(), Path.of("test-framework", "jacoco")) || Matchers.directory(context.metadata(), Path.of("core", "runtime")) || Matchers.directory(context.metadata(), Path.of("core", "deployment"))) {
            context.metadata().inputs(inputs -> {
                boolean skipDocs = context.properties().getBoolean("skipDocs") != false || context.properties().getBoolean("quickly") != false;
                inputs.property("skipDocs", (Object)skipDocs);
            });
        }
        context.metadata().outputs(outputs -> outputs.directory("quarkusConfigDoc", (Object)(context.project().getBuild().getDirectory() + "/quarkus-config-doc")));
    }
}

