/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;
import java.util.Map;

public class SurefireConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-surefire-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("test", SurefireConfiguredPlugin::configureTest);
    }

    private static void configureTest(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            inputs.fileSet("quarkus-dependencies", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependencies.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
        });
        context.metadata().outputs(outputs -> {
            if (Matchers.directory(context.metadata(), Path.of("integration-tests", "devtools")) || Matchers.directory(context.metadata(), Path.of("integration-tests", "gradle")) || Matchers.directory(context.metadata(), Path.of("integration-tests", "maven"))) {
                outputs.notCacheableBecause("It is too hard to figure out the dependency tree of these modules");
            }
        });
    }
}

