/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;

public class QuarkusConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "quarkus-maven-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("build", QuarkusConfiguredPlugin::configureBuild, "generate-code", QuarkusConfiguredPlugin::configureGenerateCode, "generate-code-tests", QuarkusConfiguredPlugin::configureGenerateCodeTests);
    }

    private static void configureBuild(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            QuarkusConfiguredPlugin.addClasspathInput(inputs, Path.of(context.project().getBuild().getDirectory(), "quarkus-prod-dependencies.txt"));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
        });
    }

    private static void configureGenerateCode(GoalMetadataProvider.Context context) {
        QuarkusConfiguredPlugin.configureCommonGeneratedCode(context, false);
    }

    private static void configureGenerateCodeTests(GoalMetadataProvider.Context context) {
        QuarkusConfiguredPlugin.configureCommonGeneratedCode(context, true);
    }

    private static void configureCommonGeneratedCode(GoalMetadataProvider.Context context, boolean test) {
        context.metadata().inputs(inputs -> {
            QuarkusConfiguredPlugin.dependsOnGav(inputs, context.metadata());
            QuarkusConfiguredPlugin.dependsOnOs(inputs);
            QuarkusConfiguredPlugin.dependsOnJavaVersion(inputs);
            inputs.properties(new String[]{"skipSourceGeneration", "mode", "properties", "bootstrapId"});
            QuarkusConfiguredPlugin.addClasspathInput(inputs, Path.of(context.project().getBuild().getDirectory(), "quarkus-prod-dependencies.txt"));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("resources", context.project().getResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            if (test) {
                inputs.fileSet("testResources", context.project().getTestResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
            try {
                if (test) {
                    inputs.fileSet("testClassPath", (Object)context.project().getTestClasspathElements(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
                } else {
                    inputs.fileSet("compileClassPath", (Object)context.project().getCompileClasspathElements(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to resolve classpath");
            }
            inputs.ignore(new String[]{"repoSession", "session", "project", "mojoExecution", "buildDir", "finalName", "manifestEntries", "manifestSections", "ignoredEntries", "appArtifact", "closeBootstrappedApp"});
        });
        context.metadata().nested("repos", c -> c.inputs(inputs -> inputs.properties(new String[]{"id", "url"})));
        context.metadata().outputs(outputs -> {
            outputs.cacheable("If the inputs and dependencies are identical, we should have the same output");
            if (test) {
                outputs.directory("generated-test-sources", (Object)(context.project().getBuild().getDirectory() + "/generated-test-sources"));
            } else {
                outputs.directory("generated-sources", (Object)(context.project().getBuild().getDirectory() + "/generated-sources"));
            }
            outputs.directory("proto", (Object)(context.project().getBuild().getDirectory() + "/proto"));
        });
        if (test) {
            context.project().addTestCompileSourceRoot(context.project().getBuild().getDirectory() + "/generated-test-sources");
        } else {
            context.project().addCompileSourceRoot(context.project().getBuild().getDirectory() + "/generated-sources");
        }
    }
}

