/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import io.quarkus.develocity.project.util.Matchers;
import java.nio.file.Path;
import java.util.Map;

public class FailsafeConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-failsafe-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("integration-test", FailsafeConfiguredPlugin::configureIntegrationTest);
    }

    private static void configureIntegrationTest(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            FailsafeConfiguredPlugin.addClasspathInput(inputs, Path.of(context.project().getBuild().getDirectory(), "quarkus-prod-dependencies.txt"));
            inputs.fileSet("quarkus-dependency-checksums", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"quarkus-*-dependency-checksums.txt"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            if (Matchers.directory(context.metadata(), Path.of("integration-tests", new String[0]))) {
                inputs.fileSet("native-runner", (Object)context.project().getBuild().getDirectory(), fs -> fs.include(new String[]{"*-runner"}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            }
        });
        context.metadata().outputs(outputs -> {
            if (Matchers.directory(context.metadata(), Path.of("integration-tests", "devtools")) || Matchers.directory(context.metadata(), Path.of("integration-tests", "gradle")) || Matchers.directory(context.metadata(), Path.of("integration-tests", "maven"))) {
                outputs.notCacheableBecause("It is too hard to figure out the dependency tree of these modules");
            }
        });
    }
}

