/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.github.dmlloyd.classfile.ClassHierarchyResolver;
import io.quarkus.gizmo2.impl.ClassHierarchyLocatorCachedImpl;
import io.quarkus.gizmo2.impl.ClassHierarchyLocatorResultImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.Map;
import java.util.function.Supplier;

@FunctionalInterface
public interface ClassHierarchyLocator {
    public Result locate(ClassDesc var1);

    default public ClassHierarchyLocator orElse(final ClassHierarchyLocator other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return new ClassHierarchyLocator(){

            @Override
            public Result locate(ClassDesc clazz) {
                Result result = ClassHierarchyLocator.this.locate(clazz);
                return result != null ? result : other.locate(clazz);
            }
        };
    }

    default public ClassHierarchyLocator cached(Supplier<Map<ClassDesc, Result>> cacheFactory) {
        Assert.checkNotNullParam((String)"cacheFactory", cacheFactory);
        return new ClassHierarchyLocatorCachedImpl(this, cacheFactory);
    }

    public static ClassHierarchyLocator forClassParsing(ClassLoader cl) {
        Assert.checkNotNullParam((String)"cl", (Object)cl);
        final ClassHierarchyResolver resolver = ClassHierarchyResolver.ofResourceParsing((ClassLoader)cl);
        return new ClassHierarchyLocator(){

            @Override
            public Result locate(ClassDesc clazz) {
                ClassHierarchyResolver.ClassHierarchyInfo info = resolver.getClassInfo(clazz);
                return info != null ? new ClassHierarchyLocatorResultImpl(info) : null;
            }
        };
    }

    public static ClassHierarchyLocator forClassLoading(ClassLoader cl) {
        Assert.checkNotNullParam((String)"cl", (Object)cl);
        final ClassHierarchyResolver resolver = ClassHierarchyResolver.ofClassLoading((ClassLoader)cl);
        return new ClassHierarchyLocator(){

            @Override
            public Result locate(ClassDesc clazz) {
                ClassHierarchyResolver.ClassHierarchyInfo info = resolver.getClassInfo(clazz);
                return info != null ? new ClassHierarchyLocatorResultImpl(info) : null;
            }
        };
    }

    public static ClassHierarchyLocator forResourceParsing(ResourceLoader rl) {
        Assert.checkNotNullParam((String)"rl", (Object)rl);
        final ClassHierarchyResolver resolver = ClassHierarchyResolver.ofResourceParsing(clazz -> {
            try {
                Resource resource = rl.findResource(Util.internalName(clazz) + ".class");
                return resource != null ? resource.openStream() : null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return new ClassHierarchyLocator(){

            @Override
            public Result locate(ClassDesc clazz) {
                ClassHierarchyResolver.ClassHierarchyInfo info = resolver.getClassInfo(clazz);
                return info != null ? new ClassHierarchyLocatorResultImpl(info) : null;
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result {
        public static Result ofInterface() {
            return ClassHierarchyLocatorResultImpl.OF_INTERFACE;
        }

        public static Result ofClass(ClassDesc superClass) {
            if (superClass == null) {
                return ClassHierarchyLocatorResultImpl.OF_JAVA_LANG_OBJECT;
            }
            return new ClassHierarchyLocatorResultImpl(ClassHierarchyResolver.ClassHierarchyInfo.ofClass((ClassDesc)superClass));
        }

        public static Result forClass(Class<?> clazz) {
            if (clazz == null) {
                return null;
            }
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException("Primitive class " + String.valueOf(clazz));
            }
            if (clazz.isArray()) {
                throw new IllegalArgumentException("Array class " + String.valueOf(clazz));
            }
            if (clazz.isHidden()) {
                throw new IllegalArgumentException("Hidden class " + String.valueOf(clazz));
            }
            if (clazz.isInterface()) {
                return Result.ofInterface();
            }
            Class<?> superclass = clazz.getSuperclass();
            return superclass == null ? Result.ofClass(null) : Result.ofClass(superclass.describeConstable().orElseThrow(IllegalArgumentException::new));
        }

        public static Result forInputStream(InputStream inputStream) {
            if (inputStream == null) {
                return null;
            }
            return new ClassHierarchyLocatorResultImpl(ClassHierarchyResolver.ofResourceParsing(ignored -> inputStream).getClassInfo(ConstantDescs.CD_Object));
        }

        public static Result forBytes(byte[] bytes) {
            return Result.forInputStream(new ByteArrayInputStream(bytes));
        }
    }
}

