/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.ModifierLocation;
import io.quarkus.gizmo2.creator.TypeParameterCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.ExecutableCreatorImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.TypeParameterCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import java.lang.annotation.ElementType;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Consumer;

public final class ConstructorCreatorImpl
extends ExecutableCreatorImpl
implements ConstructorCreator {
    private final List<Consumer<BlockCreator>> preInits;
    private final List<Consumer<BlockCreator>> postInits;
    private ConstructorDesc desc;

    ConstructorCreatorImpl(TypeCreatorImpl owner, List<Consumer<BlockCreator>> preInits, List<Consumer<BlockCreator>> postInits) {
        super(owner);
        this.preInits = preInits;
        this.postInits = postInits;
    }

    @Override
    public ModifierLocation modifierLocation() {
        return ModifierLocation.CLASS_CONSTRUCTOR;
    }

    @Override
    public ConstructorDesc desc() {
        ConstructorDesc desc = this.desc;
        if (desc == null) {
            this.desc = desc = ConstructorDesc.of(this.owner(), this.type());
        }
        return desc;
    }

    @Override
    public void setType(MethodTypeDesc desc) {
        if (!Util.isVoid(desc.returnType())) {
            throw new IllegalArgumentException("Constructors must return void");
        }
        super.setType(desc);
    }

    @Override
    public String name() {
        return ConstructorCreator.super.name();
    }

    @Override
    public void body(Consumer<BlockCreator> builder) {
        super.body(b0 -> {
            for (Consumer<BlockCreator> preInit : this.preInits) {
                preInit.accept((BlockCreator)b0);
            }
            ((BlockCreatorImpl)b0).postInit(this.postInits);
            builder.accept((BlockCreator)b0);
        });
    }

    void accept(Consumer<? super ConstructorCreatorImpl> builder) {
        builder.accept(this);
    }

    @Override
    void clearType() {
        this.desc = null;
        super.clearType();
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.CONSTRUCTOR;
    }

    @Override
    public GenericType.OfTypeVariable typeParameter(String name, Consumer<TypeParameterCreator> builder) {
        TypeParameterCreatorImpl creator = new TypeParameterCreatorImpl(name);
        builder.accept(creator);
        return this.addTypeParameter(creator.forConstructor(this.desc)).genericType();
    }
}

