/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class InstanceOf
extends Item {
    private final Item input;
    private final ClassDesc checkType;
    private final GenericType checkGenericType;
    private Label label;

    InstanceOf(Expr input, ClassDesc checkType, GenericType checkGenericType) {
        super(ConstantDescs.CD_boolean);
        this.input = (Item)input;
        this.checkGenericType = checkGenericType;
        this.checkType = checkType == null ? checkGenericType.desc() : checkType;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.input.process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        this.label = cb.newBoundLabel();
        cb.instanceOf(this.checkType);
        smb.pop();
        smb.push(ConstantDescs.CD_boolean);
        smb.wroteCode();
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        if (this.checkGenericType != null && this.checkGenericType.hasAnnotations(retention)) {
            Util.computeAnnotations(this.checkGenericType, retention, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofInstanceofExpr((Label)this.label), annotations, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
    }
}

