/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.ClassSignature;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.attribute.NestMembersAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.SignatureAttribute;
import io.github.dmlloyd.classfile.attribute.SourceFileAttribute;
import io.github.dmlloyd.classfile.extras.reflect.ClassFileFormatVersion;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.ClassVersion;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.GenericTypes;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.StaticFieldCreator;
import io.quarkus.gizmo2.creator.StaticMethodCreator;
import io.quarkus.gizmo2.creator.TypeCreator;
import io.quarkus.gizmo2.creator.TypeParameterCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.ClassStaticFieldCreatorImpl;
import io.quarkus.gizmo2.impl.GizmoImpl;
import io.quarkus.gizmo2.impl.InterfaceStaticFieldCreatorImpl;
import io.quarkus.gizmo2.impl.ModifiableCreatorImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.StaticFieldCreatorImpl;
import io.quarkus.gizmo2.impl.StaticInterfaceMethodCreatorImpl;
import io.quarkus.gizmo2.impl.StaticMethodCreatorImpl;
import io.quarkus.gizmo2.impl.ThisExpr;
import io.quarkus.gizmo2.impl.TypeParameterCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TypeCreatorImpl
extends ModifiableCreatorImpl
implements TypeCreator {
    private static final ClassMethodDesc MD_invoke_returning_Object = ClassMethodDesc.of(ConstantDescs.CD_MethodHandle, "invoke", ConstantDescs.CD_Object, new ClassDesc[0]);
    final GizmoImpl gizmo;
    private ClassFileFormatVersion version = ClassFileFormatVersion.RELEASE_17;
    private final ClassDesc type;
    private GenericType.OfClass genericType;
    private final ClassOutput output;
    private ThisExpr this_;
    private ClassDesc superType = ConstantDescs.CD_Object;
    private GenericType.OfClass superSig = GenericTypes.GT_Object;
    private List<GenericType.OfClass> interfaceSigs = List.of();
    private List<TypeParameter> typeParameters = List.of();
    final ClassBuilder zb;
    private List<Consumer<BlockCreator>> staticInits = List.of();
    List<Consumer<BlockCreator>> preInits = List.of();
    List<Consumer<BlockCreator>> postInits = List.of();
    private List<ClassDesc> nestMembers = new ArrayList<ClassDesc>();
    private int bootstraps;
    final Map<FieldDesc, Boolean> fields = new LinkedHashMap<FieldDesc, Boolean>();
    final Map<MethodDesc, Boolean> methods = new LinkedHashMap<MethodDesc, Boolean>();
    final Set<ConstructorDesc> constructors = new LinkedHashSet<ConstructorDesc>();
    int lambdaAndAnonClassCounter;

    TypeCreatorImpl(GizmoImpl gizmo, ClassDesc type, ClassOutput output, ClassBuilder zb) {
        super(gizmo);
        this.gizmo = gizmo;
        this.type = type;
        this.output = output;
        this.zb = zb;
    }

    public ClassOutput output() {
        return this.output;
    }

    @Override
    public void setVersion(Runtime.Version version) {
        Assert.checkNotNullParam((String)"version", (Object)version);
        this.version = ClassFileFormatVersion.valueOf((Runtime.Version)version);
    }

    @Override
    public void setVersion(ClassVersion version) {
        Assert.checkNotNullParam((String)"version", (Object)((Object)version));
        this.version = switch (version) {
            default -> throw new IncompatibleClassChangeError();
            case ClassVersion.V17 -> ClassFileFormatVersion.RELEASE_17;
            case ClassVersion.V21 -> ClassFileFormatVersion.RELEASE_21;
        };
    }

    ClassFileFormatVersion version() {
        return this.version;
    }

    void addNestMember(ClassDesc nestMember) {
        this.nestMembers.add(nestMember);
    }

    @Override
    public void sourceFile(String name) {
        this.zb.with((ClassFileElement)SourceFileAttribute.of((String)name));
    }

    void extends_(GenericType.OfClass genericType) {
        ClassDesc desc;
        this.superType = desc = genericType.desc();
        this.zb.withSuperclass(this.superType);
        this.superSig = genericType;
    }

    void extends_(ClassDesc desc) {
        this.superType = desc;
        this.zb.withSuperclass(this.superType);
        this.superSig = (GenericType.OfClass)GenericType.of(desc);
    }

    ClassDesc superClass() {
        return this.superType;
    }

    @Override
    public ClassDesc type() {
        return this.type;
    }

    @Override
    public GenericType.OfClass genericType() {
        GenericType.OfClass genericType = this.genericType;
        if (genericType == null) {
            genericType = GenericType.ofClass(this.type());
            if (!this.typeParameters.isEmpty()) {
                genericType = genericType.withArguments(this.typeParameters.stream().map(TypeParameter::genericType).map(TypeArgument::ofExact).map(TypeArgument.class::cast).toList());
            }
            this.genericType = genericType;
        }
        return genericType;
    }

    @Override
    public boolean hasGenericType() {
        return this.genericType != null;
    }

    boolean signatureNeeded() {
        return !this.typeParameters.isEmpty() || this.superSig.signatureNeeded() || this.interfaceSigs.stream().anyMatch(GenericType::signatureNeeded);
    }

    ClassSignature computeSignature() {
        return ClassSignature.of(this.typeParameters.stream().map(Util::typeParamOf).toList(), (Signature.ClassTypeSig)Util.signatureOf(this.superSig), (Signature.ClassTypeSig[])((Signature.ClassTypeSig[])this.interfaceSigs.stream().map(Util::signatureOf).toArray(Signature.ClassTypeSig[]::new)));
    }

    void implements_(GenericType.OfClass genericType) {
        this.zb.withInterfaceSymbols(new ClassDesc[]{genericType.desc()});
        if (this.interfaceSigs.isEmpty()) {
            this.interfaceSigs = new ArrayList<GenericType.OfClass>(4);
        }
        this.interfaceSigs.add(genericType);
    }

    void implements_(ClassDesc interface_) {
        this.implements_((GenericType.OfClass)GenericType.of(interface_));
    }

    @Override
    public void staticInitializer(Consumer<BlockCreator> builder) {
        if (this.staticInits.isEmpty()) {
            this.staticInits = new ArrayList<Consumer<BlockCreator>>(4);
        }
        this.staticInits.add((Consumer)Assert.checkNotNullParam((String)"builder", builder));
    }

    public void instanceInitializer(Consumer<BlockCreator> builder) {
        if (!this.constructors.isEmpty()) {
            throw new IllegalStateException("Instance initializers may not be added once constructors exist");
        }
        if (this.postInits.isEmpty()) {
            this.postInits = new ArrayList<Consumer<BlockCreator>>(4);
        }
        this.postInits.add((Consumer)Assert.checkNotNullParam((String)"builder", builder));
    }

    void instancePreinitializer(Consumer<BlockCreator> builder) {
        if (!this.constructors.isEmpty()) {
            throw new IllegalStateException("Instance initializers may not be added once constructors exist");
        }
        if (this.preInits.isEmpty()) {
            this.preInits = new ArrayList<Consumer<BlockCreator>>(4);
        }
        this.preInits.add((Consumer)Assert.checkNotNullParam((String)"builder", builder));
    }

    @Override
    public MethodDesc staticMethod(String name, Consumer<StaticMethodCreator> builder) {
        MethodDesc desc;
        boolean isInterface;
        Assert.checkNotNullParam((String)"builder", builder);
        boolean bl = isInterface = (this.modifiers & 0x200) != 0;
        if (isInterface) {
            StaticInterfaceMethodCreatorImpl smc = new StaticInterfaceMethodCreatorImpl(this, name);
            smc.accept(builder);
            desc = smc.desc();
        } else {
            StaticMethodCreatorImpl smc = new StaticMethodCreatorImpl(this, name);
            smc.accept(builder);
            desc = smc.desc();
        }
        if (this.methods.putIfAbsent(desc, Boolean.TRUE) != null) {
            throw new IllegalArgumentException("Duplicate method added: %s".formatted(desc));
        }
        return desc;
    }

    @Override
    public StaticFieldVar staticField(String name, Consumer<StaticFieldCreator> builder) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"builder", builder);
        boolean isInterface = (this.modifiers & 0x200) != 0;
        StaticFieldCreatorImpl fc = isInterface ? new InterfaceStaticFieldCreatorImpl(this, this.type(), name) : new ClassStaticFieldCreatorImpl(this, this.type(), name);
        fc.accept(builder);
        FieldDesc desc = fc.desc();
        if (this.fields.putIfAbsent(desc, Boolean.TRUE) != null) {
            throw new IllegalArgumentException("Duplicate field added: %s".formatted(desc));
        }
        return Expr.staticField(desc);
    }

    @Override
    public This this_() {
        ThisExpr this_ = this.this_;
        if (this_ == null) {
            this_ = this.this_ = new ThisExpr(this.type(), this.hasGenericType() ? this.genericType() : null);
        }
        return this_;
    }

    void preAccept() {
        this.zb.withVersion(this.version.major(), 0);
    }

    void postAccept() {
        int i;
        this.zb.withSuperclass(this.superSig.desc());
        this.zb.withInterfaces(this.interfaceSigs.stream().map(d -> this.zb.constantPool().classEntry(d.desc())).toList());
        this.zb.withFlags(this.modifiers);
        if (this.signatureNeeded()) {
            this.zb.with((ClassFileElement)SignatureAttribute.of((ClassSignature)this.computeSignature()));
        }
        this.addVisible((Consumer<? super RuntimeVisibleAnnotationsAttribute>)this.zb);
        this.addInvisible((Consumer<? super RuntimeInvisibleAnnotationsAttribute>)this.zb);
        if (!this.nestMembers.isEmpty()) {
            this.zb.with((ClassFileElement)NestMembersAttribute.ofSymbols(this.nestMembers));
        }
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        ArrayDeque<TypeAnnotation.TypePathComponent> pathStack = new ArrayDeque<TypeAnnotation.TypePathComponent>();
        for (i = 0; i < this.typeParameters.size(); ++i) {
            TypeParameter tv = this.typeParameters.get(i);
            Util.computeAnnotations(tv, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.CLASS_TYPE_PARAMETER, (int)i), visible, pathStack);
            assert (pathStack.isEmpty());
            Util.computeAnnotations(tv, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.CLASS_TYPE_PARAMETER, (int)i), invisible, pathStack);
            assert (pathStack.isEmpty());
        }
        Util.computeAnnotations(this.superSig, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofClassExtends((int)65535), visible, pathStack);
        assert (pathStack.isEmpty());
        Util.computeAnnotations(this.superSig, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofClassExtends((int)65535), invisible, pathStack);
        assert (pathStack.isEmpty());
        for (i = 0; i < this.interfaceSigs.size(); ++i) {
            Util.computeAnnotations(this.interfaceSigs.get(i), RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofClassExtends((int)i), visible, pathStack);
            assert (pathStack.isEmpty());
            Util.computeAnnotations(this.interfaceSigs.get(i), RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofClassExtends((int)i), invisible, pathStack);
            assert (pathStack.isEmpty());
        }
        if (!visible.isEmpty()) {
            this.zb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            this.zb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(invisible));
        }
        if (!this.staticInits.isEmpty()) {
            this.zb.withMethod("<clinit>", MethodTypeDesc.of(ConstantDescs.CD_void, new ClassDesc[0]), 8, mb -> mb.withCode(cb -> {
                BlockCreatorImpl bc = new BlockCreatorImpl(this, (CodeBuilder)cb, ConstantDescs.CD_void, "static");
                bc.accept(b0 -> {
                    for (Consumer<BlockCreator> init : this.staticInits) {
                        b0.block(init);
                    }
                    if (!b0.done()) {
                        b0.return_();
                    }
                });
                bc.writeCode((CodeBuilder)cb, bc, new StackMapBuilder());
            }));
        }
    }

    abstract MethodDesc methodDesc(String var1, MethodTypeDesc var2);

    private boolean getAndSetBootstrap(Bootstrap bootstrap) {
        int bootstraps = this.bootstraps;
        int bit = 1 << bootstrap.ordinal();
        if ((bootstraps & bit) == 0) {
            this.bootstraps = bootstraps | bit;
            return true;
        }
        return false;
    }

    void buildLambdaBootstrap() {
        if (this.getAndSetBootstrap(Bootstrap.LAMBDA)) {
            this.staticMethod("defineLambdaCallSite", MethodTypeDesc.of(ConstantDescs.CD_CallSite, ConstantDescs.CD_MethodHandles_Lookup, ConstantDescs.CD_String, ConstantDescs.CD_MethodType), smc -> {
                smc.setAccess(AccessLevel.PRIVATE);
                ParamVar lookup = smc.parameter("lookup", 0);
                ParamVar base64 = smc.parameter("base64", 1);
                ParamVar methodType = smc.parameter("methodType", 2);
                smc.body(b0 -> {
                    LocalVar decoder = b0.localVar("decoder", b0.invokeStatic(Descs.MD_Base64.getUrlDecoder));
                    LocalVar bytes = b0.localVar("bytes", b0.invokeVirtual((MethodDesc)Descs.MD_Base64.Decoder.decode_1, (Expr)decoder, (Expr)base64));
                    LocalVar definedLookup = b0.localVar("definedLookup", b0.invokeVirtual((MethodDesc)Descs.MD_MethodHandles.Lookup.defineHiddenClass, (Expr)lookup, bytes, Const.of(false), b0.newArray(Descs.CD_MethodHandles_Lookup_ClassOption, Const.of((Constable)((Object)MethodHandles.Lookup.ClassOption.NESTMATE)))));
                    LocalVar definedClass = b0.localVar("definedClass", b0.invokeVirtual(Descs.MD_MethodHandles.Lookup.lookupClass, definedLookup));
                    LocalVar ctorType = b0.localVar("ctorType", b0.invokeVirtual((MethodDesc)Descs.MD_MethodType.changeReturnType, (Expr)methodType, (Expr)Const.of(Void.TYPE)));
                    LocalVar ctorHandle = b0.localVar("ctorHandle", b0.invokeVirtual((MethodDesc)Descs.MD_MethodHandles.Lookup.findConstructor, (Expr)definedLookup, (Expr)definedClass, (Expr)ctorType));
                    b0.ifElse(b0.eq(b0.invokeVirtual(Descs.MD_MethodType.parameterCount, methodType), 0), t1 -> {
                        LocalVar instance = t1.localVar("instance", t1.invokeVirtual(MD_invoke_returning_Object, ctorHandle));
                        LocalVar constHandle = t1.localVar("constHandle", t1.invokeStatic((MethodDesc)Descs.MD_MethodHandles.constant, (Expr)definedClass, (Expr)instance));
                        t1.return_(t1.new_(Descs.CD_ConstantCallSite, t1.invokeVirtual((MethodDesc)Descs.MD_MethodHandle.asType, (Expr)constHandle, (Expr)methodType)));
                    }, f1 -> f1.return_(f1.new_(Descs.CD_ConstantCallSite, f1.invokeVirtual((MethodDesc)Descs.MD_MethodHandle.asType, (Expr)ctorHandle, (Expr)methodType))));
                });
            });
        }
    }

    @Override
    public List<FieldDesc> staticFields() {
        return this.fields.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
    }

    @Override
    public List<FieldDesc> instanceFields() {
        return this.fields.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).toList();
    }

    @Override
    public List<MethodDesc> staticMethods() {
        return this.methods.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
    }

    @Override
    public List<MethodDesc> instanceMethods() {
        return this.methods.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).toList();
    }

    @Override
    public List<ConstructorDesc> constructors() {
        return List.copyOf(this.constructors);
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.TYPE;
    }

    public GenericType.OfTypeVariable typeParameter(String name, Consumer<TypeParameterCreator> builder) {
        if (this.genericType != null) {
            throw new IllegalStateException("Type has already been established");
        }
        TypeParameterCreatorImpl creator = new TypeParameterCreatorImpl(name);
        builder.accept(creator);
        TypeParameter.OfType var = creator.forType(this.type());
        List<TypeParameter> list = this.typeParameters;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(var);
        } else {
            this.typeParameters = Util.listWith(this.typeParameters, var);
        }
        return var.genericType();
    }

    void buildReadLineBoostrapHelper() {
        if (this.getAndSetBootstrap(Bootstrap.READ_LINE)) {
            this.staticMethod("$readUtfLine", (StaticMethodCreator mc) -> {
                mc.returning(ConstantDescs.CD_String);
                ParamVar sb = mc.parameter("sb", Descs.CD_StringBuilder);
                ParamVar is = mc.parameter("is", Descs.CD_InputStream);
                mc.body(b0 -> {
                    LocalVar a = b0.localVar("a", b0.invokeVirtual(Descs.MD_InputStream.read, is));
                    b0.if_(b0.eq((Expr)a, -1), BlockCreator::returnNull);
                    b0.loop(b1 -> {
                        b1.block(b2 -> {
                            b2.if_(b2.eq((Expr)a, 10), b3 -> {
                                Expr toString = b3.withObject(sb).toString_();
                                b3.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.setLength, (Expr)sb, (Expr)Const.of(0));
                                b3.return_(toString);
                            });
                            b2.if_(b2.lt((Expr)a, 128), b3 -> {
                                b3.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_char, (Expr)sb, b3.cast((Expr)a, ConstantDescs.CD_char));
                                b3.break_((BlockCreator)b2);
                            });
                            b2.if_(b2.lt((Expr)a, 192), b3 -> b3.throw_(CharConversionException.class));
                            LocalVar b = b2.localVar("b", b2.invokeVirtual(Descs.MD_InputStream.read, is));
                            b2.if_(b2.eq((Expr)b, -1), b3 -> b3.throw_(EOFException.class));
                            b2.if_(b2.logicalOr(b2.lt((Expr)b, 128), b3 -> b3.yield(b3.ge((Expr)b, 192))), b3 -> b3.throw_(CharConversionException.class));
                            b2.if_(b2.lt((Expr)a, 224), b3 -> {
                                b3.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.appendCodePoint, (Expr)sb, b3.or(b3.shl(b3.and((Expr)a, 31), 6), b3.and((Expr)b, 63)));
                                b3.break_((BlockCreator)b2);
                            });
                            LocalVar c = b2.localVar("c", b2.invokeVirtual(Descs.MD_InputStream.read, is));
                            b2.if_(b2.eq((Expr)c, -1), b3 -> b3.throw_(EOFException.class));
                            b2.if_(b2.logicalOr(b2.lt((Expr)c, 128), b3 -> b3.yield(b3.ge((Expr)c, 192))), b3 -> b3.throw_(CharConversionException.class));
                            b2.if_(b2.lt((Expr)a, 240), b3 -> {
                                b3.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.appendCodePoint, (Expr)sb, b3.or(b3.or(b3.shl(b3.and((Expr)a, 15), 12), b3.shl(b3.and((Expr)b, 63), 6)), b3.and((Expr)c, 63)));
                                b3.break_((BlockCreator)b2);
                            });
                            LocalVar d = b2.localVar("d", b2.invokeVirtual(Descs.MD_InputStream.read, is));
                            b2.if_(b2.eq((Expr)d, -1), b3 -> b3.throw_(EOFException.class));
                            b2.if_(b2.logicalOr(b2.lt((Expr)d, 128), b3 -> b3.yield(b3.ge((Expr)d, 192))), b3 -> b3.throw_(CharConversionException.class));
                            b2.if_(b2.lt((Expr)a, 248), b3 -> {
                                b3.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.appendCodePoint, (Expr)sb, b3.or(b3.or(b3.shl(b3.and((Expr)a, 7), 18), b3.shl(b3.and((Expr)b, 63), 12)), b3.or(b3.shl(b3.and((Expr)c, 15), 6), b3.and((Expr)d, 63))));
                                b3.break_((BlockCreator)b2);
                            });
                            b2.throw_(CharConversionException.class);
                        });
                        b1.set((Assignable)a, b1.invokeVirtual(Descs.MD_InputStream.read, is));
                        b1.if_(b1.eq((Expr)a, -1), b2 -> b2.throw_(EOFException.class));
                    });
                });
            });
        }
    }

    void buildStringListConstantBootstrap() {
        this.buildReadLineBoostrapHelper();
        if (this.getAndSetBootstrap(Bootstrap.LIST_CONSTANT)) {
            this.staticMethod("loadStringListConstant", (StaticMethodCreator mc) -> {
                mc.returning(ConstantDescs.CD_List);
                mc.parameter("lookup", ConstantDescs.CD_MethodHandles_Lookup);
                ParamVar name = mc.parameter("name", ConstantDescs.CD_String);
                ParamVar clazz = mc.parameter("type", ConstantDescs.CD_Class);
                mc.body(b0 -> {
                    b0.if_(b0.ne((Expr)clazz, Const.of(ConstantDescs.CD_List)), b1 -> b1.throw_(ClassCastException.class));
                    LocalVar is = b0.localVar("is", b0.invokeVirtual((MethodDesc)Descs.MD_Class.getResourceAsStream, (Expr)Const.of(this.type), b0.withString(b0.withString(Const.of(this.type.displayName() + "$")).concat(name)).concat(Const.of(".txt"))));
                    b0.if_(b0.eq((Expr)is, Const.ofNull(Descs.CD_InputStream)), b1 -> b1.throw_(NoSuchElementException.class));
                    b0.autoClose(is, b1 -> {
                        LocalVar sb = b1.localVar("sb", b1.new_(Descs.CD_StringBuilder, (Expr)Const.of(100)));
                        LocalVar list = b1.localVar("list", b1.new_(Descs.CD_ArrayList, (Expr)Const.of(60)));
                        LocalVar line = b1.localVar("line", b1.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        b1.while_(b2 -> b2.yield(b2.isNotNull(line)), b2 -> {
                            b2.withCollection(list).add(line);
                            b2.set((Assignable)line, b2.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        });
                        b1.return_(b1.invokeStatic((MethodDesc)Descs.MD_List.copyOf, (Expr)list));
                    });
                });
            });
        }
    }

    @Override
    public Const stringListResourceConstant(String name, List<String> items) {
        this.buildStringListConstantBootstrap();
        byte[] array = this.encodeStrings(items.stream());
        this.output.write("%s$%s.txt".formatted(Util.internalName(this.type), name), array);
        DynamicConstantDesc stringListConstant = DynamicConstantDesc.ofNamed(ConstantDescs.ofConstantBootstrap(this.type, "loadStringListConstant", ConstantDescs.CD_List, new ClassDesc[0]), name, ConstantDescs.CD_List, new ConstantDesc[0]);
        return Const.of(stringListConstant);
    }

    void buildStringSetConstantBootstrap() {
        this.buildReadLineBoostrapHelper();
        if (this.getAndSetBootstrap(Bootstrap.SET_CONSTANT)) {
            this.staticMethod("loadStringSetConstant", (StaticMethodCreator mc) -> {
                mc.returning(ConstantDescs.CD_Set);
                mc.parameter("lookup", ConstantDescs.CD_MethodHandles_Lookup);
                ParamVar name = mc.parameter("name", ConstantDescs.CD_String);
                ParamVar clazz = mc.parameter("type", ConstantDescs.CD_Class);
                mc.body(b0 -> {
                    b0.if_(b0.ne((Expr)clazz, Const.of(ConstantDescs.CD_Set)), b1 -> b1.throw_(ClassCastException.class));
                    LocalVar is = b0.localVar("is", b0.invokeVirtual((MethodDesc)Descs.MD_Class.getResourceAsStream, (Expr)Const.of(this.type), b0.withString(b0.withString(Const.of(this.type.displayName() + "$")).concat(name)).concat(Const.of(".txt"))));
                    b0.if_(b0.eq((Expr)is, Const.ofNull(Descs.CD_InputStream)), b1 -> b1.throw_(NoSuchElementException.class));
                    b0.autoClose(is, b1 -> {
                        LocalVar sb = b1.localVar("sb", b1.new_(Descs.CD_StringBuilder, (Expr)Const.of(100)));
                        LocalVar list = b1.localVar("list", b1.new_(Descs.CD_ArrayList, (Expr)Const.of(60)));
                        LocalVar line = b1.localVar("line", b1.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        b1.while_(b2 -> b2.yield(b2.isNotNull(line)), b2 -> {
                            b2.withCollection(list).add(line);
                            b2.set((Assignable)line, b2.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        });
                        b1.return_(b1.invokeStatic((MethodDesc)Descs.MD_Set.copyOf, (Expr)list));
                    });
                });
            });
        }
    }

    @Override
    public Const stringSetResourceConstant(String name, Set<String> items) {
        this.buildStringSetConstantBootstrap();
        byte[] array = this.encodeStrings(items.stream());
        this.output.write("%s$%s.txt".formatted(Util.internalName(this.type), name), array);
        DynamicConstantDesc stringSetConstant = DynamicConstantDesc.ofNamed(ConstantDescs.ofConstantBootstrap(this.type, "loadStringSetConstant", ConstantDescs.CD_Set, new ClassDesc[0]), name, ConstantDescs.CD_Set, new ConstantDesc[0]);
        return Const.of(stringSetConstant);
    }

    void buildStringMapConstantBootstrap() {
        this.buildReadLineBoostrapHelper();
        if (this.getAndSetBootstrap(Bootstrap.MAP_CONSTANT)) {
            this.staticMethod("loadStringMapConstant", (StaticMethodCreator mc) -> {
                mc.returning(ConstantDescs.CD_Map);
                mc.parameter("lookup", ConstantDescs.CD_MethodHandles_Lookup);
                ParamVar name = mc.parameter("name", ConstantDescs.CD_String);
                ParamVar clazz = mc.parameter("type", ConstantDescs.CD_Class);
                mc.body(b0 -> {
                    b0.if_(b0.ne((Expr)clazz, Const.of(ConstantDescs.CD_Map)), b1 -> b1.throw_(ClassCastException.class));
                    LocalVar is = b0.localVar("is", b0.invokeVirtual((MethodDesc)Descs.MD_Class.getResourceAsStream, (Expr)Const.of(this.type), b0.withString(b0.withString(Const.of(this.type.displayName() + "$")).concat(name)).concat(Const.of(".txt"))));
                    b0.if_(b0.eq((Expr)is, Const.ofNull(Descs.CD_InputStream)), b1 -> b1.throw_(NoSuchElementException.class));
                    b0.autoClose(is, b1 -> {
                        LocalVar sb = b1.localVar("sb", b1.new_(Descs.CD_StringBuilder, (Expr)Const.of(100)));
                        LocalVar list = b1.localVar("list", b1.new_(Descs.CD_ArrayList, (Expr)Const.of(60)));
                        LocalVar key = b1.localVar("key", b1.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        LocalVar value = b1.localVar("value", b1.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        b1.while_(b2 -> b2.yield(b2.isNotNull(key)), b2 -> {
                            b2.withCollection(list).add(b2.mapEntry(key, value));
                            b2.set((Assignable)key, b2.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                            b2.set((Assignable)value, b2.invokeStatic((MethodDesc)ClassMethodDesc.of(this.type, "$readUtfLine", MethodTypeDesc.of(ConstantDescs.CD_String, Descs.CD_StringBuilder, Descs.CD_InputStream)), (Expr)sb, (Expr)is));
                        });
                        Expr array = b1.newEmptyArray(Descs.CD_Map_Entry, b1.withList(list).size());
                        array = b1.invokeVirtual((MethodDesc)ClassMethodDesc.of(Descs.CD_ArrayList, "toArray", MethodTypeDesc.of(ConstantDescs.CD_Object.arrayType(), ConstantDescs.CD_Object.arrayType())), (Expr)list, array);
                        b1.return_(b1.invokeStatic((MethodDesc)Descs.MD_Map.ofEntries, array));
                    });
                });
            });
        }
    }

    @Override
    public Const stringMapResourceConstant(String name, Map<String, String> items) {
        this.buildStringMapConstantBootstrap();
        byte[] array = this.encodeStrings(items.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())));
        this.output.write("%s$%s.txt".formatted(Util.internalName(this.type), name), array);
        DynamicConstantDesc stringMapConstant = DynamicConstantDesc.ofNamed(ConstantDescs.ofConstantBootstrap(this.type, "loadStringMapConstant", ConstantDescs.CD_Map, new ClassDesc[0]), name, ConstantDescs.CD_Map, new ConstantDesc[0]);
        return Const.of(stringMapConstant);
    }

    private byte[] encodeStrings(Stream<String> stream) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
        try {
            stream.forEachOrdered(s -> {
                int cp;
                for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
                    cp = s.codePointAt(i);
                    if (cp <= 127 && cp != 10) {
                        os.write(cp);
                        continue;
                    }
                    if (cp <= 2047) {
                        os.write(0xC0 | cp >> 6);
                        os.write(0x80 | cp & 0x3F);
                        continue;
                    }
                    if (cp <= 65535) {
                        os.write(0xE0 | cp >> 12);
                        os.write(0x80 | cp >> 6 & 0x3F);
                        os.write(0x80 | cp & 0x3F);
                        continue;
                    }
                    if (cp <= 0x10FFFF) {
                        os.write(0xF0 | cp >> 18);
                        os.write(0x80 | cp >> 12 & 0x3F);
                        os.write(0x80 | cp >> 6 & 0x3F);
                        os.write(0x80 | cp & 0x3F);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected invalid code point");
                }
                os.write(10);
            });
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        os.close();
        return byArray;
    }

    private static enum Bootstrap {
        LAMBDA,
        READ_LINE,
        LIST_CONSTANT,
        SET_CONSTANT,
        MAP_CONSTANT;

    }
}

