/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.lang.constant.ClassDesc;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@FunctionalInterface
public interface ClassOutput {
    default public void write(ClassDesc desc, byte[] bytes) {
        if (!desc.isClassOrInterface()) {
            throw new IllegalArgumentException("Can only write classes/interfaces");
        }
        this.write(Util.internalName(desc) + ".class", bytes);
    }

    public void write(String var1, byte[] var2);

    default public ClassOutput andThen(ClassOutput next) {
        Assert.checkNotNullParam((String)"next", (Object)next);
        return (desc, bytes) -> {
            this.write(desc, bytes);
            next.write(desc, bytes);
        };
    }

    public static ClassOutput fileWriter(Path basePath) {
        Assert.checkNotNullParam((String)"basePath", (Object)basePath);
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path does not exist or is not an accessible directory: %s".formatted(basePath));
        }
        return (name, bytes) -> {
            try {
                Path path = basePath.resolve(name);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to write class %s".formatted(name), e);
            }
        };
    }
}

