/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierFlag;
import java.util.List;
import java.util.stream.Stream;

public final class ModifierLocation
extends Enum<ModifierLocation> {
    public static final /* enum */ ModifierLocation INTERFACE_DEFAULT_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), 0, AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation INTERFACE_PRIVATE_INSTANCE_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), 0, AccessLevel.PRIVATE);
    public static final /* enum */ ModifierLocation INTERFACE_ABSTRACT_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), ModifierLocation.bitsOf(ModifierFlag.ABSTRACT), AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation INTERFACE_STATIC_FIELD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC, ModifierFlag.VOLATILE), ModifierLocation.bitsOf(ModifierFlag.STATIC, ModifierFlag.FINAL), AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation INTERFACE_STATIC_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC), ModifierLocation.bitsOf(ModifierFlag.FINAL, ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), ModifierLocation.bitsOf(ModifierFlag.STATIC), AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation CLASS_CONSTRUCTOR = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), 0, AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation CLASS_INSTANCE_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.BRIDGE, ModifierFlag.FINAL, ModifierFlag.SYNCHRONIZED, ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), 0, AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation CLASS_ABSTRACT_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE), ModifierLocation.bitsOf(ModifierFlag.BRIDGE, ModifierFlag.SYNCHRONIZED, ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), ModifierLocation.bitsOf(ModifierFlag.ABSTRACT), AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation CLASS_NATIVE_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.BRIDGE, ModifierFlag.STATIC, ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), 0, AccessLevel.PRIVATE);
    public static final /* enum */ ModifierLocation CLASS_STATIC_METHOD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.BRIDGE, ModifierFlag.FINAL, ModifierFlag.SYNCHRONIZED, ModifierFlag.SYNTHETIC, ModifierFlag.VARARGS), ModifierLocation.bitsOf(ModifierFlag.STATIC), AccessLevel.PUBLIC);
    public static final /* enum */ ModifierLocation CLASS_INSTANCE_FIELD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.FINAL, ModifierFlag.TRANSIENT, ModifierFlag.VOLATILE, ModifierFlag.SYNTHETIC), 0, AccessLevel.PRIVATE);
    public static final /* enum */ ModifierLocation CLASS_STATIC_FIELD = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PROTECTED, AccessLevel.PACKAGE_PRIVATE, AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.FINAL, ModifierFlag.VOLATILE, ModifierFlag.SYNTHETIC), ModifierLocation.bitsOf(ModifierFlag.STATIC), AccessLevel.PRIVATE);
    public static final /* enum */ ModifierLocation CLASS = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PACKAGE_PRIVATE), ModifierLocation.bitsOf(ModifierFlag.ABSTRACT, ModifierFlag.FINAL, ModifierFlag.SYNTHETIC), 0, AccessLevel.PUBLIC, ModifierFlag.SYNTHETIC);
    public static final /* enum */ ModifierLocation INTERFACE = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PUBLIC, AccessLevel.PACKAGE_PRIVATE), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC), ModifierLocation.bitsOf(ModifierFlag.ABSTRACT), AccessLevel.PUBLIC, ModifierFlag.SYNTHETIC);
    public static final /* enum */ ModifierLocation ANONYMOUS_CLASS = new ModifierLocation(ModifierLocation.bitsOf(AccessLevel.PRIVATE), ModifierLocation.bitsOf(ModifierFlag.SYNTHETIC), ModifierLocation.bitsOf(ModifierFlag.FINAL), AccessLevel.PRIVATE, ModifierFlag.SYNTHETIC);
    public static final /* enum */ ModifierLocation PARAMETER = new ModifierLocation(0, ModifierLocation.bitsOf(ModifierFlag.FINAL, ModifierFlag.SYNTHETIC, ModifierFlag.MANDATED), 0, new Modifier[0]);
    public static final /* enum */ ModifierLocation LOCAL_VARIABLE = new ModifierLocation(0, ModifierLocation.bitsOf(ModifierFlag.FINAL), 0, new Modifier[0]);
    public static final List<ModifierLocation> values;
    private final byte validAccesses;
    private final byte validFlags;
    private final byte requiredFlags;
    private final int defaultModifierBits;
    private static final /* synthetic */ ModifierLocation[] $VALUES;

    public static ModifierLocation[] values() {
        return (ModifierLocation[])$VALUES.clone();
    }

    public static ModifierLocation valueOf(String name) {
        return Enum.valueOf(ModifierLocation.class, name);
    }

    private ModifierLocation(int validAccesses, int validFlags, int requiredFlags, Modifier ... defaultModifiers) {
        this.validAccesses = (byte)validAccesses;
        this.validFlags = (byte)validFlags;
        this.requiredFlags = (byte)requiredFlags;
        this.defaultModifierBits = Stream.of(defaultModifiers).filter(this::check).mapToInt(Modifier::mask).reduce(ModifierLocation.bitsToMask(requiredFlags), (a, b) -> a | b);
    }

    private static int bitsToMask(int requiredFlags) {
        int mask = 0;
        while (requiredFlags != 0) {
            int lob = Integer.lowestOneBit(requiredFlags);
            mask |= ModifierFlag.values.get(Integer.numberOfTrailingZeros(lob)).mask();
            requiredFlags &= ~lob;
        }
        return mask;
    }

    private boolean check(Modifier m) {
        assert (this.supports(m)) : "Unexpected invalid default modifier";
        return true;
    }

    private static int bitsOf(Enum<?> ... vals) {
        return Stream.of(vals).mapToInt(Enum::ordinal).map(a -> 1 << a).reduce(0, (a, b) -> a | b);
    }

    public boolean supports(Modifier m) {
        return m.validIn(this);
    }

    public boolean supports(AccessLevel level) {
        return (this.validAccesses & 1 << level.ordinal()) != 0;
    }

    public boolean supports(ModifierFlag flag) {
        return (this.validFlags & 1 << flag.ordinal()) != 0;
    }

    public boolean requires(ModifierFlag flag) {
        return (this.requiredFlags & 1 << flag.ordinal()) != 0;
    }

    public int defaultModifierBits() {
        return this.defaultModifierBits;
    }

    private static /* synthetic */ ModifierLocation[] $values() {
        return new ModifierLocation[]{INTERFACE_DEFAULT_METHOD, INTERFACE_PRIVATE_INSTANCE_METHOD, INTERFACE_ABSTRACT_METHOD, INTERFACE_STATIC_FIELD, INTERFACE_STATIC_METHOD, CLASS_CONSTRUCTOR, CLASS_INSTANCE_METHOD, CLASS_ABSTRACT_METHOD, CLASS_NATIVE_METHOD, CLASS_STATIC_METHOD, CLASS_INSTANCE_FIELD, CLASS_STATIC_FIELD, CLASS, INTERFACE, ANONYMOUS_CLASS, PARAMETER, LOCAL_VARIABLE};
    }

    static {
        $VALUES = ModifierLocation.$values();
        values = List.of(ModifierLocation.values());
    }
}

