/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ComparableOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;

public final class StringBuilderOps
extends ObjectOps
implements ComparableOps {
    public StringBuilderOps(BlockCreator bc, Expr obj) {
        super(StringBuilder.class, bc, obj);
    }

    public StringBuilderOps(BlockCreator bc) {
        super(StringBuilder.class, bc, bc.localVar("stringBuilder", bc.new_(StringBuilder.class, new Expr[0])));
    }

    public StringBuilderOps(BlockCreator bc, int capacity) {
        super(StringBuilder.class, bc, bc.new_(StringBuilder.class, Const.of(capacity)));
    }

    public StringBuilderOps append(Expr expr) {
        return new StringBuilderOps(this.bc, switch (expr.type().descriptorString()) {
            case "Z" -> this.invokeInstance(StringBuilder.class, "append", Boolean.TYPE, expr);
            case "B", "S", "I" -> this.invokeInstance(StringBuilder.class, "append", Integer.TYPE, expr);
            case "J" -> this.invokeInstance(StringBuilder.class, "append", Long.TYPE, expr);
            case "F" -> this.invokeInstance(StringBuilder.class, "append", Float.TYPE, expr);
            case "D" -> this.invokeInstance(StringBuilder.class, "append", Double.TYPE, expr);
            case "C" -> this.invokeInstance(StringBuilder.class, "append", Character.TYPE, expr);
            case "[C" -> this.invokeInstance(StringBuilder.class, "append", char[].class, expr);
            case "Ljava/lang/String;" -> this.invokeInstance(StringBuilder.class, "append", String.class, expr);
            case "Ljava/lang/CharSequence;" -> this.invokeInstance(StringBuilder.class, "append", CharSequence.class, expr);
            default -> this.invokeInstance(StringBuilder.class, "append", Object.class, expr);
        });
    }

    public StringBuilderOps append(char constant) {
        return this.append(Const.of(constant));
    }

    public StringBuilderOps append(String constant) {
        return this.append(Const.of(constant));
    }

    public StringBuilderOps appendCodePoint(Expr codePoint) {
        return new StringBuilderOps(this.bc, this.invokeInstance(StringBuilder.class, "appendCodePoint", Integer.TYPE, codePoint));
    }

    public StringBuilderOps appendCodePoint(int codePoint) {
        return this.appendCodePoint(Const.of(codePoint));
    }

    public void setLength(Expr length) {
        this.invokeInstance(Void.TYPE, "setLength", Integer.TYPE, length);
    }

    public void setLength(int length) {
        this.setLength(Const.of(length));
    }

    @Override
    public Expr compareTo(Expr other) {
        return this.invokeInstance(Integer.TYPE, "compareTo", StringBuilder.class, other);
    }
}

